/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.cert.dane;

import cn.com.infosec.cert.dane.DANEEntrySelector;
import cn.com.infosec.cert.dane.DANEException;
import cn.com.infosec.operator.DigestCalculator;
import cn.com.infosec.util.Strings;
import cn.com.infosec.util.encoders.Hex;
import java.io.IOException;
import java.io.OutputStream;

public class DANEEntrySelectorFactory {
    private final DigestCalculator digestCalculator;

    public DANEEntrySelectorFactory(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
    }

    public DANEEntrySelector createSelector(String emailAddress) throws DANEException {
        byte[] enc = Strings.toUTF8ByteArray(emailAddress.substring(0, emailAddress.indexOf(64)));
        try {
            OutputStream cOut = this.digestCalculator.getOutputStream();
            cOut.write(enc);
            cOut.close();
        }
        catch (IOException e) {
            throw new DANEException("Unable to calculate digest string: " + e.getMessage(), e);
        }
        byte[] hash = this.digestCalculator.getDigest();
        String domainName = Strings.fromByteArray(Hex.encode(hash)) + "._smimecert." + emailAddress.substring(emailAddress.indexOf(64) + 1);
        return new DANEEntrySelector(domainName);
    }
}

