/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.cert.path.validations;

import cn.com.infosec.asn1.x509.BasicConstraints;
import cn.com.infosec.asn1.x509.Extension;
import cn.com.infosec.cert.X509CertificateHolder;
import cn.com.infosec.cert.path.CertPathValidation;
import cn.com.infosec.cert.path.CertPathValidationContext;
import cn.com.infosec.cert.path.CertPathValidationException;
import cn.com.infosec.util.Memoable;
import java.math.BigInteger;

public class BasicConstraintsValidation
implements CertPathValidation {
    private boolean isMandatory;
    private BasicConstraints bc;
    private int pathLengthRemaining;
    private BigInteger maxPathLength;

    public BasicConstraintsValidation() {
        this(true);
    }

    public BasicConstraintsValidation(boolean isMandatory) {
        this.isMandatory = isMandatory;
    }

    @Override
    public void validate(CertPathValidationContext context, X509CertificateHolder certificate) throws CertPathValidationException {
        if (this.maxPathLength != null && this.pathLengthRemaining < 0) {
            throw new CertPathValidationException("BasicConstraints path length exceeded");
        }
        context.addHandledExtension(Extension.basicConstraints);
        BasicConstraints certBC = BasicConstraints.fromExtensions(certificate.getExtensions());
        if (certBC != null) {
            if (this.bc != null) {
                int plc;
                BigInteger pathLengthConstraint;
                if (certBC.isCA() && (pathLengthConstraint = certBC.getPathLenConstraint()) != null && (plc = pathLengthConstraint.intValue()) < this.pathLengthRemaining) {
                    this.pathLengthRemaining = plc;
                    this.bc = certBC;
                }
            } else {
                this.bc = certBC;
                if (certBC.isCA()) {
                    this.maxPathLength = certBC.getPathLenConstraint();
                    if (this.maxPathLength != null) {
                        this.pathLengthRemaining = this.maxPathLength.intValue();
                    }
                }
            }
        } else if (this.bc != null) {
            --this.pathLengthRemaining;
        }
        if (this.isMandatory && this.bc == null) {
            throw new CertPathValidationException("BasicConstraints not present in path");
        }
    }

    @Override
    public Memoable copy() {
        BasicConstraintsValidation v = new BasicConstraintsValidation(this.isMandatory);
        v.bc = this.bc;
        v.pathLengthRemaining = this.pathLengthRemaining;
        return v;
    }

    @Override
    public void reset(Memoable other) {
        BasicConstraintsValidation v = (BasicConstraintsValidation)other;
        this.isMandatory = v.isMandatory;
        this.bc = v.bc;
        this.pathLengthRemaining = v.pathLengthRemaining;
    }
}

