/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.cms;

import cn.com.infosec.operator.InputAEADDecryptor;
import cn.com.infosec.operator.InputDecryptor;
import cn.com.infosec.operator.MacCalculator;
import cn.com.infosec.util.io.TeeInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class RecipientOperator {
    private final Object operator;

    public RecipientOperator(InputDecryptor decryptor) {
        this.operator = decryptor;
    }

    public RecipientOperator(MacCalculator macCalculator) {
        this.operator = macCalculator;
    }

    public InputStream getInputStream(InputStream dataIn) {
        if (this.operator instanceof InputDecryptor) {
            return ((InputDecryptor)this.operator).getInputStream(dataIn);
        }
        return new TeeInputStream(dataIn, ((MacCalculator)this.operator).getOutputStream());
    }

    public boolean isAEADBased() {
        return this.operator instanceof InputAEADDecryptor;
    }

    public OutputStream getAADStream() {
        return ((InputAEADDecryptor)this.operator).getAADStream();
    }

    public boolean isMacBased() {
        return this.operator instanceof MacCalculator;
    }

    public byte[] getMac() {
        return ((MacCalculator)this.operator).getMac();
    }
}

