/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.common.logging;

import cn.com.infosec.common.spi.logging.LogDelegateAdapter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JULLogDelegate
extends LogDelegateAdapter {
    private final Logger logger;

    JULLogDelegate(String name) {
        this.logger = Logger.getLogger(name);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public void fatal(Object message) {
        this.log(Level.SEVERE, message);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    @Override
    public void error(Object message) {
        this.log(Level.SEVERE, message);
    }

    @Override
    public void error(Object message, Object ... params) {
        this.log(Level.SEVERE, message, null, params);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    @Override
    public void error(Object message, Throwable t, Object ... params) {
        this.log(Level.SEVERE, message, t, params);
    }

    @Override
    public void warn(Object message) {
        this.log(Level.WARNING, message);
    }

    @Override
    public void warn(Object message, Object ... params) {
        this.log(Level.WARNING, message, null, params);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }

    @Override
    public void warn(Object message, Throwable t, Object ... params) {
        this.log(Level.WARNING, message, t, params);
    }

    @Override
    public void info(Object message) {
        this.log(Level.INFO, message);
    }

    @Override
    public void info(Object message, Object ... params) {
        this.log(Level.INFO, message, null, params);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    @Override
    public void info(Object message, Throwable t, Object ... params) {
        this.log(Level.INFO, message, t, params);
    }

    @Override
    public void debug(Object message) {
        this.log(Level.FINE, message);
    }

    @Override
    public void debug(Object message, Object ... params) {
        this.log(Level.FINE, message, null, params);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.log(Level.FINE, message, t);
    }

    @Override
    public void debug(Object message, Throwable t, Object ... params) {
        this.log(Level.FINE, message, t, params);
    }

    @Override
    public void trace(Object message) {
        this.log(Level.FINEST, message);
    }

    @Override
    public void trace(Object message, Object ... params) {
        this.log(Level.FINEST, message, null, params);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.log(Level.FINEST, message, t);
    }

    @Override
    public void trace(Object message, Throwable t, Object ... params) {
        this.log(Level.FINEST, message, t, params);
    }

    private void log(Level level, Object message) {
        this.log(level, message, null);
    }

    private void log(Level level, Object message, Throwable t, Object ... params) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        String msg = message == null ? "NULL" : message.toString();
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(this.logger.getName());
        if (t != null) {
            record.setThrown(t);
        } else if (params != null && params.length != 0 && params[params.length - 1] instanceof Throwable) {
            record.setThrown((Throwable)params[params.length - 1]);
        }
        record.setSourceClassName(null);
        record.setParameters(params);
        this.logger.log(record);
    }

    private void log(Level level, Object message, Throwable t) {
        this.log(level, message, t, null);
    }

    @Override
    public Object unwrap() {
        return this.logger;
    }
}

