/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.agreement;

import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.params.IPPSM2KeyExchangePrivateParameters;
import cn.com.infosec.crypto.params.IPPSM2KeyExchangePublicParameters;
import cn.com.infosec.crypto.params.ParametersWithID;
import cn.com.infosec.device.SDSFactory;
import cn.com.infosec.device.crypto.CryptoException;
import cn.com.infosec.device.crypto.ISDSCrypto;

public class IPPSM2Agreement {
    private byte[] userID;
    private byte[] staticKey;
    private byte[] staticPubPoint;
    private byte[] ephemeralPubPoint;
    private byte[] ephemeralKey;
    private boolean initiator;

    public void init(CipherParameters privParam) {
        IPPSM2KeyExchangePrivateParameters baseParam;
        if (privParam instanceof ParametersWithID) {
            baseParam = (IPPSM2KeyExchangePrivateParameters)((ParametersWithID)privParam).getParameters();
            this.userID = ((ParametersWithID)privParam).getID();
        } else {
            baseParam = (IPPSM2KeyExchangePrivateParameters)privParam;
            this.userID = new byte[0];
        }
        this.initiator = baseParam.isInitiator();
        this.staticKey = baseParam.getStaticPrivateKey();
        this.ephemeralKey = baseParam.getEphemeralPrivateKey();
        this.staticPubPoint = baseParam.getStaticPublicPoint();
        this.ephemeralPubPoint = baseParam.getEphemeralPublicPoint();
    }

    public byte[] calculateKey(int kLen, CipherParameters pubParam) {
        byte[] rv;
        byte[] otherUserID;
        IPPSM2KeyExchangePublicParameters otherPub;
        if (pubParam instanceof ParametersWithID) {
            otherPub = (IPPSM2KeyExchangePublicParameters)((ParametersWithID)pubParam).getParameters();
            otherUserID = ((ParametersWithID)pubParam).getID();
        } else {
            otherPub = (IPPSM2KeyExchangePublicParameters)pubParam;
            otherUserID = new byte[]{};
        }
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        try {
            rv = device.sm2KeyExchange(this.userID, this.userID.length, this.ephemeralKey, this.ephemeralKey.length, this.ephemeralPubPoint, this.ephemeralPubPoint.length, this.staticKey, this.staticKey.length, this.staticPubPoint, this.staticPubPoint.length, otherUserID, otherUserID.length, otherPub.getEphemeralPublicKey(), otherPub.getEphemeralPublicKey().length, otherPub.getStaticPublicKey(), otherPub.getStaticPublicKey().length, this.initiator);
        }
        catch (CryptoException e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        return rv;
    }
}

