/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.digests;

import cn.com.infosec.crypto.Digest;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.device.SDSFactory;
import cn.com.infosec.device.crypto.ISDSCrypto;
import cn.com.infosec.device.util.PrintUtil;
import cn.com.infosec.util.Debug;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class IPPSM3Digest
implements Digest {
    private static final int DIGEST_LENGTH = 32;
    private ByteArrayOutputStream buf = new ByteArrayOutputStream();

    public IPPSM3Digest() {
    }

    public IPPSM3Digest(IPPSM3Digest digest) {
    }

    @Override
    public String getAlgorithmName() {
        return "SM3";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public int doFinal(byte[] out, int offset) {
        if (this.buf.size() == 0) {
            throw new RuntimeException("the input data size is 0");
        }
        byte[] input = this.buf.toByteArray();
        this.buf.reset();
        try {
            this.buf.close();
        }
        catch (IOException e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        try {
            device.sm3Hash(input, input.length, out);
        }
        catch (Exception e) {
            Debug.println(Debug.ERROR, "sm3Hash error");
            System.err.println("data input");
            System.err.println(PrintUtil.toHexString(input));
            throw new RuntimeCryptoException(e.getMessage());
        }
        return 32;
    }

    @Override
    public void reset() {
        this.buf.reset();
        try {
            this.buf.close();
        }
        catch (IOException e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
    }

    @Override
    public void update(byte input) {
        this.buf.write(input);
    }

    public void update(byte[] input) {
        try {
            this.buf.write(input);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void update(byte[] input, int offset, int len) {
        this.buf.write(input, offset, len);
    }
}

