/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.encodings;

import cn.com.infosec.crypto.AsymmetricBlockCipher;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.CryptoServicesRegistrar;
import cn.com.infosec.crypto.InvalidCipherTextException;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.crypto.params.RSAKeyParameters;
import cn.com.infosec.crypto.params.RSAPrivateCrtKeyParameters;
import cn.com.infosec.device.IPPRsaFactory;
import cn.com.infosec.device.ipp.rsa.IPPRsaKeyPair;
import cn.com.infosec.device.sds.IPPRsaDevice;
import cn.com.infosec.device.util.PrintUtil;
import cn.com.infosec.util.BigIntegerUtil;
import cn.com.infosec.util.Debug;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;

public class IPPPKCS1Encoding
implements AsymmetricBlockCipher {
    public static final String STRICT_LENGTH_ENABLED_PROPERTY = "cn.com.infosec.pkcs1.strict";
    public static final String NOT_STRICT_LENGTH_ENABLED_PROPERTY = "cn.com.infosec.pkcs1.not_strict";
    private static final int HEADER_LENGTH = 10;
    private RSAKeyParameters key;
    private SecureRandom random;
    private boolean forEncryption;
    private boolean useStrictLength = this.useStrict();

    private boolean useStrict() {
        String strict = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(IPPPKCS1Encoding.STRICT_LENGTH_ENABLED_PROPERTY);
            }
        });
        String notStrict = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(IPPPKCS1Encoding.NOT_STRICT_LENGTH_ENABLED_PROPERTY);
            }
        });
        if (notStrict != null) {
            return !notStrict.equals("true");
        }
        return strict == null || strict.equals("true");
    }

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (RSAKeyParameters)rParam.getParameters();
            this.random = this.key instanceof RSAPrivateCrtKeyParameters ? rParam.getRandom() : null;
        } else {
            this.key = (RSAKeyParameters)param;
            this.random = this.key instanceof RSAPrivateCrtKeyParameters ? CryptoServicesRegistrar.getSecureRandom() : null;
        }
        this.forEncryption = forEncryption;
    }

    @Override
    public int getInputBlockSize() {
        int bitSize = this.key.getModulus().bitLength();
        if (this.forEncryption) {
            return (bitSize + 7) / 8 - 1;
        }
        return (bitSize + 7) / 8;
    }

    @Override
    public int getOutputBlockSize() {
        int bitSize = this.key.getModulus().bitLength();
        if (this.forEncryption) {
            return (bitSize + 7) / 8;
        }
        return (bitSize + 7) / 8 - 1;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int len) throws InvalidCipherTextException {
        byte[] signature;
        if (this.key == null) {
            throw new IllegalStateException("RSA pkcs1 cipher engine not initialised");
        }
        IPPRsaDevice device = null;
        try {
            device = IPPRsaFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        if (this.forEncryption) {
            int keyBytes = (this.key.getModulus().bitLength() + 7) / 8;
            IPPRsaKeyPair keyPair = new IPPRsaKeyPair(this.key.getExponent().intValue(), BigIntegerUtil.asUnsignedNByteArray(this.key.getModulus(), keyBytes), null, null, null, null, null, null);
            try {
                return device.rsaEncryptPKCSv15(in, len, keyPair);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException(e.getMessage());
            }
        }
        RSAPrivateCrtKeyParameters keyParam = (RSAPrivateCrtKeyParameters)this.key;
        int keyBytes = (keyParam.getP().bitLength() + 7) / 8;
        IPPRsaKeyPair keyPair = new IPPRsaKeyPair(0, null, null, BigIntegerUtil.asUnsignedNByteArray(keyParam.getP(), keyBytes), BigIntegerUtil.asUnsignedNByteArray(keyParam.getQ(), keyBytes), BigIntegerUtil.asUnsignedNByteArray(keyParam.getDP(), keyBytes), BigIntegerUtil.asUnsignedNByteArray(keyParam.getDQ(), keyBytes), BigIntegerUtil.asUnsignedNByteArray(keyParam.getQInv(), keyBytes));
        try {
            signature = device.rsaDecryptPKCSv15(in, len, keyPair);
        }
        catch (Exception e) {
            Debug.println(Debug.ERROR, "RSA PKCS15 Sign error");
            System.err.println("data input");
            System.err.println(PrintUtil.toHexString(in));
            throw new RuntimeCryptoException(e.getMessage());
        }
        return signature;
    }
}

