/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.engines;

import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.InvalidCipherTextException;
import cn.com.infosec.crypto.Wrapper;
import cn.com.infosec.crypto.engines.GOST28147Engine;
import cn.com.infosec.crypto.macs.GOST28147Mac;
import cn.com.infosec.crypto.params.ParametersWithIV;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.crypto.params.ParametersWithUKM;
import cn.com.infosec.util.Arrays;

public class GOST28147WrapEngine
implements Wrapper {
    private GOST28147Engine cipher = new GOST28147Engine();
    private GOST28147Mac mac = new GOST28147Mac();

    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom pr = (ParametersWithRandom)param;
            param = pr.getParameters();
        }
        ParametersWithUKM pU = (ParametersWithUKM)param;
        this.cipher.init(forWrapping, pU.getParameters());
        this.mac.init(new ParametersWithIV(pU.getParameters(), pU.getUKM()));
    }

    @Override
    public String getAlgorithmName() {
        return "GOST28147Wrap";
    }

    @Override
    public byte[] wrap(byte[] input, int inOff, int inLen) {
        this.mac.update(input, inOff, inLen);
        byte[] wrappedKey = new byte[inLen + this.mac.getMacSize()];
        this.cipher.processBlock(input, inOff, wrappedKey, 0);
        this.cipher.processBlock(input, inOff + 8, wrappedKey, 8);
        this.cipher.processBlock(input, inOff + 16, wrappedKey, 16);
        this.cipher.processBlock(input, inOff + 24, wrappedKey, 24);
        this.mac.doFinal(wrappedKey, inLen);
        return wrappedKey;
    }

    @Override
    public byte[] unwrap(byte[] input, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] decKey = new byte[inLen - this.mac.getMacSize()];
        this.cipher.processBlock(input, inOff, decKey, 0);
        this.cipher.processBlock(input, inOff + 8, decKey, 8);
        this.cipher.processBlock(input, inOff + 16, decKey, 16);
        this.cipher.processBlock(input, inOff + 24, decKey, 24);
        byte[] macResult = new byte[this.mac.getMacSize()];
        this.mac.update(decKey, 0, decKey.length);
        this.mac.doFinal(macResult, 0);
        byte[] macExpected = new byte[this.mac.getMacSize()];
        System.arraycopy(input, inOff + inLen - 4, macExpected, 0, this.mac.getMacSize());
        if (!Arrays.constantTimeAreEqual(macResult, macExpected)) {
            throw new IllegalStateException("mac mismatch");
        }
        return decKey;
    }
}

