/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.generators;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.AsymmetricCipherKeyPairGenerator;
import cn.com.infosec.crypto.KeyGenerationParameters;
import cn.com.infosec.crypto.params.Ed25519PrivateKeyParameters;
import cn.com.infosec.crypto.params.Ed25519PublicKeyParameters;
import java.security.SecureRandom;

public class Ed25519KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters parameters) {
        this.random = parameters.getRandom();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed25519PrivateKeyParameters privateKey = new Ed25519PrivateKeyParameters(this.random);
        Ed25519PublicKeyParameters publicKey = privateKey.generatePublicKey();
        return new AsymmetricCipherKeyPair(publicKey, privateKey);
    }
}

