/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.generators;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.AsymmetricCipherKeyPairGenerator;
import cn.com.infosec.crypto.KeyGenerationParameters;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.params.ECKeyGenerationParameters;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.device.SDSFactory;
import cn.com.infosec.device.bean.ECCrefKeyPair;
import cn.com.infosec.device.bean.ECCrefPrivateKey;
import cn.com.infosec.device.bean.ECCrefPublicKey;
import cn.com.infosec.device.crypto.ISDSCrypto;
import cn.com.infosec.math.ec.ECPoint;
import cn.com.infosec.util.BigIntegerUtil;
import java.math.BigInteger;

public class IPPECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ECKeyGenerationParameters param;

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        int strength = this.param.getStrength();
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        ECCrefKeyPair keyPair = null;
        try {
            keyPair = device.generateECCKeyPair(strength);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        BigInteger d = null;
        ECPoint Q = null;
        ECCrefPrivateKey privateKey = keyPair.getPrivateKey();
        d = BigIntegerUtil.toPositiveInteger(privateKey.getD());
        ECCrefPublicKey publicKey = keyPair.getPublicKey();
        Q = this.param.getDomainParameters().getCurve().decodePoint(publicKey.getQ());
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(Q, this.param.getDomainParameters()), new ECPrivateKeyParameters(d, this.param.getDomainParameters()));
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (ECKeyGenerationParameters)param;
    }
}

