/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.generators;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.AsymmetricCipherKeyPairGenerator;
import cn.com.infosec.crypto.KeyGenerationParameters;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.params.SM9PrivateKeyParameters;
import cn.com.infosec.crypto.params.SM9PublicKeyParameters;
import cn.com.infosec.device.IBEFactory;
import cn.com.infosec.device.ibe.SM9MasterKeyPair;
import cn.com.infosec.device.sds.IBEDevice;

public class SM9MasterKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private KeyGenerationParameters param;

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        int strength = this.param.getStrength();
        IBEDevice device = null;
        try {
            device = IBEFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        SM9MasterKeyPair keyPair = null;
        try {
            keyPair = device.generateMasterKeyPair(strength);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        byte[] zzn12sign = keyPair.getZzn12Sign();
        byte[] privateKey = keyPair.getPrivateKey();
        byte[] publicKey = keyPair.getPublicKey();
        return new AsymmetricCipherKeyPair(new SM9PublicKeyParameters(zzn12sign, keyPair.getZzn12Enc(), 0, null, publicKey), new SM9PrivateKeyParameters(zzn12sign, keyPair.getZzn12Enc(), privateKey));
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = param;
    }
}

