/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.modes;

import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.device.SDSFactory;
import cn.com.infosec.device.crypto.ISDSCrypto;
import cn.com.infosec.jcajce.spec.AEADParameterSpec;
import cn.com.infosec.util.Strings;
import cn.com.infosec.util.encoders.Hex;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public class IPPCCMBlockCipher
extends CipherSpi {
    private String padd = "NoPadding";
    private String mode = "CCM";
    private int blockSize;
    private boolean forEncryption;
    private byte[] nonce = null;
    private int macSize;
    private byte[] key = null;
    private ExposedByteArrayOutputStream data = new ExposedByteArrayOutputStream();
    private byte[] associatedText = null;
    private Class[] availableSpecs = new Class[]{IvParameterSpec.class, AEADParameterSpec.class};

    public IPPCCMBlockCipher(String algName, int blockSize) {
        this.blockSize = blockSize;
    }

    public IPPCCMBlockCipher(String algName, int blockSize, String padd, String mode) {
        this(algName, blockSize);
        this.padd = padd;
    }

    public String getAlgorithmName() {
        return "SM4/CCM";
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] buf = new byte[this.engineGetOutputSize(inputLen)];
        try {
            int len = this.engineDoFinal(input, inputOffset, inputLen, buf, 0);
            byte[] out = new byte[len];
            System.arraycopy(buf, 0, out, 0, len);
            return out;
        }
        catch (ShortBufferException e) {
            return null;
        }
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (input != null) {
            this.data.write(input, inputOffset, inputLen);
        }
        if (this.data.size() == 0) {
            throw new BadPaddingException("the input data size is 0");
        }
        byte[] out = this.process();
        System.arraycopy(out, 0, output, outputOffset, out.length);
        return out.length;
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        int totalData = inputLen + this.data.size();
        if (this.forEncryption) {
            return totalData + this.macSize;
        }
        return totalData < this.macSize ? 0 : totalData - this.macSize;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return key.getEncoded().length << 3;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameters)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params instanceof AEADParameterSpec) {
            AEADParameterSpec aeadSpec = (AEADParameterSpec)params;
            this.associatedText = aeadSpec.getAssociatedData();
            this.nonce = aeadSpec.getNonce();
            int macbitsize = aeadSpec.getMacSizeInBits();
            if ((macbitsize & 1) != 0 || macbitsize % 8 != 0 || macbitsize < 32 || macbitsize > 128) {
                throw new InvalidAlgorithmParameterException("tag must have length from 4 to 16 octets, can't be odd");
            }
            this.macSize = macbitsize >> 3;
        } else if (params instanceof IvParameterSpec) {
            IvParameterSpec ivParaSpec = (IvParameterSpec)params;
            this.associatedText = null;
            this.nonce = ivParaSpec.getIV();
            this.macSize = this.blockSize >> 1;
        } else {
            throw new InvalidAlgorithmParameterException("invalid parameters passed to CCM: " + params.getClass().getName());
        }
        if (this.nonce == null || this.nonce.length < 7 || this.nonce.length > 13) {
            throw new InvalidAlgorithmParameterException("nonce must have length from 7 to 13 octets");
        }
        if (key.getEncoded().length % 16 != 0) {
            throw new InvalidKeyException("key size invalid; key: " + new String(Hex.encode(key.getEncoded())));
        }
        this.key = key.getEncoded();
        if (opmode == 1) {
            this.forEncryption = true;
        } else if (opmode == 2) {
            this.forEncryption = false;
        } else {
            throw new InvalidAlgorithmParameterException("unknown opmode " + opmode + " passed");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec paramSpec = null;
        if (params != null) {
            for (int i = 0; i != this.availableSpecs.length; ++i) {
                if (this.availableSpecs[i] == null) continue;
                try {
                    paramSpec = (AlgorithmParameterSpec)params.getParameterSpec(this.availableSpecs[i]);
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (paramSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + params.toString());
            }
        }
        this.engineInit(opmode, key, paramSpec, random);
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        String paddingName = Strings.toUpperCase(padding);
        if (paddingName.equalsIgnoreCase("NOPADDING")) {
            this.padd = "NoPadding";
        } else if (paddingName.equalsIgnoreCase("PKCS5PADDING")) {
            this.padd = "PKCS5Padding";
        } else {
            throw new NoSuchPaddingException("Padding " + padding + " unknown.");
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.data.write(input, inputOffset, inputLen);
        return this.data.toByteArray();
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        this.data.write(input, inputOffset, inputLen);
        System.arraycopy(this.data.toByteArray(), 0, output, outputOffset, this.data.size());
        return this.data.size();
    }

    public void reset() {
        this.associatedText = null;
        this.data.reset();
    }

    private byte[] process() throws BadPaddingException, IllegalBlockSizeException {
        byte[] input = this.data.toByteArray();
        int adlen = this.associatedText == null ? 0 : this.associatedText.length;
        ISDSCrypto crypto = null;
        try {
            crypto = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        byte[] out = null;
        if (this.forEncryption) {
            try {
                out = crypto.encrypt(this.mode, this.padd, this.key, this.nonce, this.associatedText, adlen, this.macSize, input);
            }
            catch (Exception ex) {
                this.reset();
                throw new RuntimeCryptoException(ex.getMessage());
            }
        }
        try {
            out = crypto.decrypt(this.mode, this.padd, this.key, this.nonce, this.associatedText, adlen, this.macSize, input);
        }
        catch (Exception ex) {
            this.reset();
            throw new RuntimeCryptoException(ex.getMessage());
        }
        this.reset();
        return out;
    }

    private class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

