/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.params;

import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.device.SDSFactory;
import cn.com.infosec.device.crypto.CryptoException;
import cn.com.infosec.device.crypto.ISDSCrypto;
import cn.com.infosec.util.BigIntegerUtil;

public class IPPSM2KeyExchangePrivateParameters
implements CipherParameters {
    private final boolean initiator;
    private final byte[] staticPrivateKey;
    private final byte[] staticPublicPoint;
    private final byte[] ephemeralPrivateKey;
    private final byte[] ephemeralPublicPoint;

    public IPPSM2KeyExchangePrivateParameters(boolean initiator, ECPrivateKeyParameters staticPrivateKey, ECPrivateKeyParameters ephemeralPrivateKey) {
        if (staticPrivateKey == null) {
            throw new NullPointerException("staticPrivateKey cannot be null");
        }
        if (ephemeralPrivateKey == null) {
            throw new NullPointerException("ephemeralPrivateKey cannot be null");
        }
        ECDomainParameters parameters = staticPrivateKey.getParameters();
        if (!parameters.equals(ephemeralPrivateKey.getParameters())) {
            throw new IllegalArgumentException("Static and ephemeral private keys have different domain parameters");
        }
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        this.initiator = initiator;
        this.staticPrivateKey = BigIntegerUtil.asUnsigned32ByteArray(staticPrivateKey.getD());
        try {
            this.staticPublicPoint = device.Sm2DerivePubkey(this.staticPrivateKey, this.staticPrivateKey.length);
        }
        catch (CryptoException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.ephemeralPrivateKey = BigIntegerUtil.asUnsigned32ByteArray(ephemeralPrivateKey.getD());
        try {
            this.ephemeralPublicPoint = device.Sm2DerivePubkey(this.ephemeralPrivateKey, this.ephemeralPrivateKey.length);
        }
        catch (CryptoException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public boolean isInitiator() {
        return this.initiator;
    }

    public byte[] getStaticPrivateKey() {
        return this.staticPrivateKey;
    }

    public byte[] getStaticPublicPoint() {
        return this.staticPublicPoint;
    }

    public byte[] getEphemeralPrivateKey() {
        return this.ephemeralPrivateKey;
    }

    public byte[] getEphemeralPublicPoint() {
        return this.ephemeralPublicPoint;
    }
}

