/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.params;

import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;

public class IPPSM2KeyExchangePublicParameters
implements CipherParameters {
    private final byte[] staticPublicKey;
    private final byte[] ephemeralPublicKey;

    public IPPSM2KeyExchangePublicParameters(ECPublicKeyParameters staticPublicKey, ECPublicKeyParameters ephemeralPublicKey) {
        if (staticPublicKey == null) {
            throw new NullPointerException("staticPublicKey cannot be null");
        }
        if (ephemeralPublicKey == null) {
            throw new NullPointerException("ephemeralPublicKey cannot be null");
        }
        if (!staticPublicKey.getParameters().equals(ephemeralPublicKey.getParameters())) {
            throw new IllegalArgumentException("Static and ephemeral public keys have different domain parameters");
        }
        this.staticPublicKey = staticPublicKey.getQ().getEncoded(false);
        this.ephemeralPublicKey = ephemeralPublicKey.getQ().getEncoded(false);
    }

    public byte[] getStaticPublicKey() {
        return this.staticPublicKey;
    }

    public byte[] getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }
}

