/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.device.bean;

import cn.com.infosec.device.bean.inf.IStructure;
import cn.com.infosec.device.crypto.CryptoException;
import cn.com.infosec.device.util.Bytes;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

public class SM2refPrivateKey
implements IStructure {
    private int bits;
    private byte[] D = new byte[32];

    public SM2refPrivateKey() {
    }

    public SM2refPrivateKey(byte[] D) {
        this.bits = 256;
        if (D.length > 32) {
            System.arraycopy(D, D.length - 32, this.D, 0, this.D.length);
        } else {
            System.arraycopy(D, 0, this.D, this.D.length - D.length, D.length);
        }
    }

    public int getBits() {
        return this.bits;
    }

    public byte[] getD() {
        return this.D;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append("bits: ").append(this.bits).append(nl);
        buf.append("   D: ").append(new BigInteger(1, this.D).toString(16)).append(nl);
        return buf.toString();
    }

    @Override
    public void decode(byte[] privateKey) throws CryptoException {
        this.bits = Bytes.bytes2int(privateKey);
        int pos = 0;
        System.arraycopy(privateKey, pos, this.D, 0, 32);
        if ((pos += this.D.length) != privateKey.length) {
            throw new CryptoException("inputData length != SM2PrivateKey length");
        }
    }

    @Override
    public byte[] encode() {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(this.D);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buf.toByteArray();
    }

    @Override
    public int size() {
        return 32;
    }

    public static int sizeof() {
        return 32;
    }
}

