/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.device.bean;

import cn.com.infosec.device.bean.inf.IStructure;
import cn.com.infosec.device.crypto.CryptoException;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

public class SM2refPublicKey
implements IStructure {
    private int bits;
    private byte[] x = new byte[32];
    private byte[] y = new byte[32];
    private byte[] q = new byte[65];

    public int getBits() {
        return this.bits;
    }

    public byte[] getX() {
        return this.x;
    }

    public byte[] getY() {
        return this.y;
    }

    public byte[] getQ() {
        return this.q;
    }

    public SM2refPublicKey() {
    }

    public SM2refPublicKey(byte[] x, byte[] y) {
        this.bits = 256;
        if (x.length > 32) {
            System.arraycopy(x, x.length - 32, this.x, 0, this.x.length);
        } else {
            System.arraycopy(x, 0, this.x, this.x.length - x.length, x.length);
        }
        if (y.length > 32) {
            System.arraycopy(y, y.length - 32, this.y, 0, this.y.length);
        } else {
            System.arraycopy(y, 0, this.y, this.y.length - y.length, y.length);
        }
        this.q[0] = 4;
        System.arraycopy(x, 0, this.q, 1, this.x.length);
        System.arraycopy(y, 0, this.q, 33, this.y.length);
    }

    @Override
    public void decode(byte[] publicKey) throws CryptoException {
        this.bits = 256;
        int pos = 1;
        System.arraycopy(publicKey, pos, this.x, 0, 32);
        System.arraycopy(publicKey, pos += this.x.length, this.y, 0, 32);
        if ((pos += this.y.length) != publicKey.length) {
            throw new CryptoException("inputData length != SM2PublicKey length");
        }
        System.arraycopy(publicKey, 0, this.q, 0, 65);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append(nl);
        buf.append("bits: ").append(this.bits).append(nl);
        buf.append("   X: ").append(new BigInteger(1, this.x).toString(16)).append(nl);
        buf.append("   Y: ").append(new BigInteger(1, this.y).toString(16)).append(nl);
        return buf.toString();
    }

    @Override
    public byte[] encode() {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(4);
            buf.write(this.x);
            buf.write(this.y);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buf.toByteArray();
    }

    @Override
    public int size() {
        return 65;
    }

    public static int sizeof() {
        return 65;
    }
}

