/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.device.sds;

import cn.com.infosec.device.crypto.CryptoException;
import cn.com.infosec.device.sds.UtilDevcie;
import cn.com.infosec.device.sm4.CbSm4;
import cn.com.infosec.device.sm4.InfosecCbSms4;

public class CbSms4Device
extends UtilDevcie {
    static CbSm4 cbsm4;
    static boolean inited;
    static long handler;

    public CbSms4Device() throws CryptoException {
        try {
            InfosecCbSms4.initialize();
            cbsm4 = InfosecCbSms4.cbsms4;
        }
        catch (Exception e) {
            throw new CryptoException(e.getMessage());
        }
    }

    public byte[] encrypt(String mode, String padding, byte[] key, byte[] iv, byte[] input) throws CryptoException {
        try {
            this.checkAlgoAndIV(mode, iv);
        }
        catch (CryptoException ex) {
            throw new CryptoException(ex.getMessage());
        }
        if (key == null) {
            throw new CryptoException("key size is null");
        }
        if (input == null || input.length == 0) {
            throw new CryptoException("input data size is 0");
        }
        byte[] dst = null;
        dst = mode.equalsIgnoreCase("ECB") ? (padding.equalsIgnoreCase("NoPadding") ? cbsm4.cbSms4EcbEncrypt(input, input.length, key, false) : cbsm4.cbSms4EcbEncrypt(input, input.length, key, true)) : (padding.equalsIgnoreCase("NoPadding") ? cbsm4.cbSms4CbcEncrypt(input, input.length, key, iv, false) : cbsm4.cbSms4CbcEncrypt(input, input.length, key, iv, true));
        if (dst == null) {
            throw new CryptoException("SM4 encrypt error: ");
        }
        return dst;
    }

    public byte[] decrypt(String mode, String padding, byte[] key, byte[] iv, byte[] input) throws CryptoException {
        try {
            this.checkAlgoAndIV(mode, iv);
        }
        catch (CryptoException ex) {
            throw new CryptoException(ex.getMessage());
        }
        if (key == null) {
            throw new CryptoException("key is null");
        }
        if (input == null) {
            throw new CryptoException("input data size is 0");
        }
        byte[] dst = null;
        dst = mode.equalsIgnoreCase("ECB") ? (padding.equalsIgnoreCase("NoPadding") ? cbsm4.cbSms4EcbDecrypt(input, input.length, key, false) : cbsm4.cbSms4EcbDecrypt(input, input.length, key, true)) : (padding.equalsIgnoreCase("NoPadding") ? cbsm4.cbSms4CbcDecrypt(input, input.length, key, iv, false) : cbsm4.cbSms4CbcDecrypt(input, input.length, key, iv, true));
        if (dst == null) {
            throw new CryptoException("SM4 decrypt error: ");
        }
        return dst;
    }

    static {
        inited = false;
    }
}

