/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.device.sds;

import cn.com.infosec.asn1.gm.SM9CurveParameters;
import cn.com.infosec.common.logging.Logger;
import cn.com.infosec.common.logging.LoggerFactory;
import cn.com.infosec.device.crypto.CryptoException;
import cn.com.infosec.device.ibe.Ibe;
import cn.com.infosec.device.ibe.InfosecIbeSM9;
import cn.com.infosec.device.ibe.SM9MasterKeyPair;
import cn.com.infosec.device.ibe.SM9UserKeyPair;
import cn.com.infosec.device.ibe.UserPublicKey;
import cn.com.infosec.util.ByteArrayUtil;
import java.math.BigInteger;
import java.security.SecureRandom;

public class IBEDevice {
    private static final Logger log = LoggerFactory.getLogger(IBEDevice.class);
    static BigInteger n = SM9CurveParameters.N;
    static Ibe ibe;
    static boolean inited;
    static long handler;

    public IBEDevice() throws CryptoException {
        try {
            InfosecIbeSM9.initialize();
            ibe = InfosecIbeSM9.ibe;
            handler = ibe.ibeInit();
            if (handler != 0L) {
                inited = true;
                log.info("handler : " + handler);
            } else {
                inited = false;
                log.error("[ErrorLog] : initialize ibe handler error");
            }
        }
        catch (Exception e) {
            throw new CryptoException(e.getMessage());
        }
    }

    private byte[] genSM9PrivateKey(int keysize) {
        BigInteger d;
        while ((d = new BigInteger(keysize, new SecureRandom())).equals(BigInteger.ZERO) || d.compareTo(n) >= 0) {
        }
        return d.toByteArray();
    }

    public byte[] sm3(byte[] input) {
        return null;
    }

    public long init() throws CryptoException {
        return ibe.ibeInit();
    }

    public SM9MasterKeyPair generateMasterKeyPair(int keysize) throws CryptoException {
        if (keysize != 256) {
            throw new CryptoException("sm9 user key length error( " + keysize + " )");
        }
        byte[][] rands = new byte[][]{this.genSM9PrivateKey(keysize), this.genSM9PrivateKey(keysize), this.genSM9PrivateKey(keysize)};
        int[] hids = new int[]{1, 2, 3};
        int[] refPrivateKey = new int[256];
        int[] refPublicKey = new int[256];
        byte[] zzn12sign = new byte[384];
        byte[] zzn12enc = new byte[384];
        int rv = ibe.ibeGenMasterKeys(handler, rands, hids, refPrivateKey, refPublicKey, zzn12sign, zzn12enc);
        if (rv == 0) {
            throw new CryptoException("generate sm9 master keypair error: ");
        }
        byte[] mprv = ByteArrayUtil.intArrayToByteArray(refPrivateKey, 0, 25);
        byte[] mpub = ByteArrayUtil.intArrayToByteArray(refPublicKey, 0, 92);
        return new SM9MasterKeyPair(mprv, mpub, zzn12sign, zzn12enc);
    }

    public SM9UserKeyPair generateUserKeyPair(int keysize, int[] mpk, int[] msk, byte[] uid) throws CryptoException {
        if (keysize != 256) {
            throw new CryptoException("sm9 user key length error( " + keysize + " )");
        }
        byte[] refusk = new byte[488];
        byte[] refupk = new byte[360];
        int rv = ibe.ibeGenUserKeys(handler, mpk, msk, uid, uid.length, refusk, refupk);
        if (rv == 0) {
            throw new CryptoException("generate sm9 user keypair error: ");
        }
        return new SM9UserKeyPair(uid.length, uid, refusk, refupk);
    }

    public byte[] sm9Encrypt(byte[] zzn12enc, UserPublicKey refPublicKey, byte[] msg, byte[] rand) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("the public key is null");
        }
        if (msg == null || msg.length == 0) {
            throw new CryptoException("the input data size is 0");
        }
        byte[] ciphertxt = new byte[msg.length + 109];
        int rv = ibe.ibeEncrypt(handler, zzn12enc, refPublicKey, msg, msg.length, rand, ciphertxt);
        if (rv == 0) {
            throw new CryptoException("SM9 encrypt error ");
        }
        return ciphertxt;
    }

    public byte[] sm9Decrypt(UserPublicKey refPublicKey, byte[] refPrivateKey, byte[] refCipher) throws CryptoException {
        if (refPrivateKey == null || refPublicKey == null) {
            throw new CryptoException("the private key is null");
        }
        if (refCipher == null || refCipher.length == 0) {
            throw new CryptoException("the input data size is 0");
        }
        byte[] plaintxt = new byte[refCipher.length - 109];
        int rv = ibe.ibeDecrypt(handler, refPublicKey, refPrivateKey, refCipher, refCipher.length, plaintxt);
        if (rv == 0) {
            throw new CryptoException("SM9 decrypt error ");
        }
        return plaintxt;
    }

    public byte[] sm9Sign(byte[] zzn12sign, byte[] refPrivateKey, byte[] msg, byte[] rand) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("the private key is null");
        }
        if (msg == null || msg.length == 0) {
            throw new CryptoException("the input data size is 0");
        }
        byte[] sig = new byte[104];
        int rv = ibe.ibeSignature(handler, zzn12sign, refPrivateKey, msg, msg.length, rand, sig);
        if (rv == 0) {
            throw new CryptoException("SM9 sign error: ");
        }
        return sig;
    }

    public boolean sm9Verify(byte[] zzn12sign, UserPublicKey refPublicKey, byte[] msg, byte[] refSig) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("the public key is null");
        }
        if (msg == null || msg.length == 0) {
            throw new CryptoException("the input data size is 0");
        }
        if (refSig == null || refSig.length == 0) {
            throw new CryptoException("the signature size is 0");
        }
        int rv = ibe.ibeVerify(handler, zzn12sign, refPublicKey, msg, msg.length, refSig);
        if (rv == 0) {
            throw new CryptoException("SM9 verify error ");
        }
        return true;
    }

    static {
        inited = false;
    }
}

