/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.device.sds;

import cn.com.infosec.device.bean.ECCrefKeyPair;
import cn.com.infosec.device.bean.ECCrefPrivateKey;
import cn.com.infosec.device.bean.ECCrefPublicKey;
import cn.com.infosec.device.bean.IPPECCCurveEnum;
import cn.com.infosec.device.bean.SM2refKeyPair;
import cn.com.infosec.device.bean.SM2refPrivateKey;
import cn.com.infosec.device.bean.SM2refPublicKey;
import cn.com.infosec.device.crypto.CryptoException;
import cn.com.infosec.device.crypto.ISDSCrypto;
import cn.com.infosec.device.ipp.InfosecIPPSM;
import cn.com.infosec.device.sds.UtilDevcie;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class IPPDevice
extends UtilDevcie
implements ISDSCrypto {
    private static final byte[] id = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};

    public IPPDevice() throws CryptoException {
        try {
            InfosecIPPSM.initialize();
        }
        catch (Exception e) {
            throw new CryptoException(e.getMessage());
        }
    }

    public byte[] sm3(byte[] input) {
        return null;
    }

    @Override
    public SM2refKeyPair generateSM2KeyPair(int keysize) throws CryptoException {
        if (keysize != 256) {
            throw new CryptoException("sm2 key size error( " + keysize + " )");
        }
        byte[] pubkey = new byte[SM2refPublicKey.sizeof()];
        byte[] prikey = new byte[SM2refPrivateKey.sizeof()];
        int rv = InfosecIPPSM.sm2.ippSm2Keypair(prikey, pubkey);
        if (rv == 0) {
            throw new CryptoException("generate sm2 keypair error");
        }
        SM2refPublicKey refPublicKey = new SM2refPublicKey();
        SM2refPrivateKey refPrivateKey = new SM2refPrivateKey();
        refPublicKey.decode(pubkey);
        refPrivateKey.decode(prikey);
        return new SM2refKeyPair(refPublicKey, refPrivateKey);
    }

    @Override
    public byte[] sm2Encrypt(SM2refPublicKey refPublicKey, byte[] input) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("the public key is null");
        }
        if (input == null || input.length == 0) {
            throw new CryptoException("the input data size is 0");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int rv = InfosecIPPSM.sm2.ippSm2Encrypt(input, input.length, refPublicKey.getQ(), out);
        if (rv == 0) {
            throw new CryptoException("SM2 encrypt error ");
        }
        byte[] cipher = out.toByteArray();
        return cipher;
    }

    @Override
    public byte[] sm2Decrypt(SM2refPrivateKey refPrivateKey, byte[] refCipher) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("the private key is null");
        }
        if (refCipher == null || refCipher.length == 0) {
            throw new CryptoException("the input data size is 0");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int rv = InfosecIPPSM.sm2.ippSm2Decrypt(refCipher, refCipher.length, refPrivateKey.encode(), out);
        if (rv == 0) {
            throw new CryptoException("SM2 decrypt error");
        }
        byte[] plain = out.toByteArray();
        return plain;
    }

    @Override
    public byte[] sm2Sign(SM2refPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("the private key is null");
        }
        if (input == null || input.length == 0) {
            throw new CryptoException("the input data size is 0");
        }
        if (input.length != 32) {
            throw new CryptoException("input data length error( " + input.length + " )");
        }
        ByteArrayOutputStream sigout = new ByteArrayOutputStream();
        int rv = InfosecIPPSM.sm2.ippSm2Sign(input, refPrivateKey.encode(), sigout);
        if (rv == 0) {
            throw new CryptoException("SM2 sign error: ");
        }
        return sigout.toByteArray();
    }

    @Override
    public boolean sm2Verify(SM2refPublicKey refPublicKey, byte[] input, byte[] refSig) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("the public key is null");
        }
        if (input == null || input.length == 0) {
            throw new CryptoException("the input data size is 0");
        }
        if (input.length != 32) {
            throw new CryptoException("input data length error( " + input.length + " )");
        }
        if (refSig == null || refSig.length == 0) {
            throw new CryptoException("the signature size is 0");
        }
        int rv = InfosecIPPSM.sm2.ippSm2Verify(input, refPublicKey.getQ(), refSig, refSig.length);
        if (rv == 0) {
            throw new CryptoException("SM2 verify error ");
        }
        return true;
    }

    @Override
    public byte[] encrypt(String mode, String padding, byte[] key, byte[] iv, byte[] ad, int adlen, int macSize, byte[] input) throws CryptoException {
        try {
            this.checkAlgoAndIV(mode, iv);
        }
        catch (CryptoException ex) {
            throw new CryptoException(ex.getMessage());
        }
        if (key == null || key.length == 0) {
            throw new CryptoException("key size is 0");
        }
        if (input == null || input.length == 0) {
            throw new CryptoException("input data size is 0");
        }
        int rv = 0;
        ByteArrayOutputStream dst = new ByteArrayOutputStream();
        if (mode.equalsIgnoreCase("ECB")) {
            rv = padding.equalsIgnoreCase("NoPadding") ? InfosecIPPSM.sm4.ippSms4EcbEncrypt(input, input.length, key, dst, false) : InfosecIPPSM.sm4.ippSms4EcbEncrypt(input, input.length, key, dst, true);
        } else if (mode.equalsIgnoreCase("CBC")) {
            rv = padding.equalsIgnoreCase("NoPadding") ? InfosecIPPSM.sm4.ippSms4CbcEncrypt(input, input.length, key, iv, dst, false) : InfosecIPPSM.sm4.ippSms4CbcEncrypt(input, input.length, key, iv, dst, true);
        } else if (mode.equalsIgnoreCase("CCM")) {
            ByteArrayOutputStream tag = new ByteArrayOutputStream();
            if (padding.equalsIgnoreCase("NoPadding")) {
                rv = InfosecIPPSM.sm4.sslSms4CcmEncrypt(input, input.length, key, iv, iv.length, ad, adlen, dst, tag, macSize);
            }
            try {
                dst.write(tag.toByteArray());
            }
            catch (IOException e) {
                throw new CryptoException(e.getMessage());
            }
        }
        if (rv == 0) {
            throw new CryptoException("SM4 CCM encrypt error: ");
        }
        return dst.toByteArray();
    }

    @Override
    public byte[] decrypt(String mode, String padding, byte[] key, byte[] iv, byte[] ad, int adlen, int macSize, byte[] input) throws CryptoException {
        try {
            this.checkAlgoAndIV(mode, iv);
        }
        catch (CryptoException ex) {
            throw new CryptoException(ex.getMessage());
        }
        if (key == null) {
            throw new CryptoException("key size is 0");
        }
        if (input == null) {
            throw new CryptoException("input data size is 0");
        }
        int rv = 0;
        ByteArrayOutputStream dst = new ByteArrayOutputStream();
        if (mode.equalsIgnoreCase("ECB")) {
            rv = padding.equalsIgnoreCase("NoPadding") ? InfosecIPPSM.sm4.ippSms4EcbDecrypt(input, input.length, key, dst, false) : InfosecIPPSM.sm4.ippSms4EcbDecrypt(input, input.length, key, dst, true);
        } else if (mode.equalsIgnoreCase("CBC")) {
            rv = padding.equalsIgnoreCase("NoPadding") ? InfosecIPPSM.sm4.ippSms4CbcDecrypt(input, input.length, key, iv, dst, false) : InfosecIPPSM.sm4.ippSms4CbcDecrypt(input, input.length, key, iv, dst, true);
        } else if (mode.equalsIgnoreCase("CCM")) {
            byte[] src = new byte[input.length - macSize];
            byte[] macBlock = new byte[macSize];
            System.arraycopy(input, 0, src, 0, src.length);
            System.arraycopy(input, src.length, macBlock, 0, macSize);
            if (padding.equalsIgnoreCase("NoPadding")) {
                rv = InfosecIPPSM.sm4.sslSms4CcmDecrypt(src, src.length, key, iv, iv.length, ad, adlen, dst, macBlock, macSize);
            }
        }
        if (rv == 0) {
            throw new CryptoException("SM4 decrypt error: ");
        }
        return dst.toByteArray();
    }

    @Override
    public byte[] calculateExtMAC(int paramInt, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, byte[] paramArrayOfByte3) throws CryptoException {
        return null;
    }

    @Override
    public byte[] calculateIntMAC(int paramInt1, int paramInt2, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2) throws CryptoException {
        return null;
    }

    @Override
    public byte[] keyAgreement_SM2(int paramInt1, int paramInt2, SM2refPublicKey paramSM2refPublicKey1, SM2refPrivateKey paramSM2refPrivateKey, SM2refPublicKey paramSM2refPublicKey2, SM2refPublicKey paramSM2refPublicKey3, int paramInt3, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2) throws Exception {
        return null;
    }

    @Override
    public int[] getKeyStatus(int paramInt) throws CryptoException {
        return null;
    }

    @Override
    public byte[] genKCV(int paramInt) throws CryptoException {
        return null;
    }

    @Override
    public String getCryptoName() {
        return null;
    }

    @Override
    public byte[] sm3Hash(byte[] input, int len, byte[] dgst) throws CryptoException {
        if (input == null || input.length == 0) {
            throw new CryptoException("input data size is 0");
        }
        byte[] rv = InfosecIPPSM.sm3.ippSm3Hash(input, len, dgst);
        if (rv == null) {
            throw new CryptoException("SM3 hash error ");
        }
        return dgst;
    }

    @Override
    public byte[] Sm2DerivePubkey(byte[] prvkey, int prvkeylen) throws CryptoException {
        if (prvkey == null || prvkey.length != 32) {
            throw new CryptoException("key size is 0");
        }
        byte[] pubkey = new byte[65];
        int rv = InfosecIPPSM.sm2.ippSm2DerivePubkey(prvkey, 32, pubkey);
        if (rv == 0) {
            throw new CryptoException("Derive Pubkey error ");
        }
        return pubkey;
    }

    @Override
    public byte[] getZa(byte[] id, byte[] pub) throws CryptoException {
        byte[] hash;
        int rv;
        if (pub == null || pub.length != 65) {
            throw new CryptoException("key size is 0");
        }
        if (id == null || id.length == 0) {
            id = IPPDevice.id;
        }
        if ((rv = InfosecIPPSM.sm2.ippSm2GetZ(id, id.length, pub, 65, hash = new byte[32])) == 0) {
            throw new CryptoException("Get Z error ");
        }
        return hash;
    }

    @Override
    public byte[] sm2KeyExchange(byte[] self_id, int self_id_len, byte[] self_tmp_prvkey, int self_tmp_prvkey_len, byte[] self_tmp_pubkey, int self_tmp_pubkey_len, byte[] self_enc_prvkey, int self_enc_prvkey_len, byte[] self_enc_pubkey, int self_enc_pubkey_len, byte[] peer_id, int peer_id_len, byte[] peer_tmp_pubkey, int peer_tmp_pubkey_len, byte[] peer_enc_pubkey, int peer_enc_pubkey_len, boolean is_server) throws CryptoException {
        if (self_id == null || self_id_len == 0) {
            throw new CryptoException("self_id size is 0");
        }
        if (peer_id == null || peer_id_len == 0) {
            throw new CryptoException("peer_id size is 0");
        }
        if (self_tmp_prvkey == null || self_tmp_prvkey_len != 32) {
            throw new CryptoException("key size is 0");
        }
        if (self_tmp_pubkey == null || self_tmp_pubkey_len != 65) {
            throw new CryptoException("key size is 0");
        }
        if (self_enc_prvkey == null || self_enc_prvkey_len != 32) {
            throw new CryptoException("key size is 0");
        }
        if (self_enc_pubkey == null || self_enc_pubkey_len != 65) {
            throw new CryptoException("key size is 0");
        }
        if (peer_tmp_pubkey == null || peer_tmp_pubkey_len != 65) {
            throw new CryptoException("key size is 0");
        }
        if (peer_enc_pubkey == null || peer_enc_pubkey_len != 65) {
            throw new CryptoException("key size is 0");
        }
        byte[] out = new byte[16];
        int rv = InfosecIPPSM.sm2.ippSm2Exchange(self_id, self_id_len, self_tmp_prvkey, self_tmp_prvkey_len, self_tmp_pubkey, self_tmp_pubkey_len, self_enc_prvkey, self_enc_prvkey_len, self_enc_pubkey, self_enc_pubkey_len, peer_id, peer_id_len, peer_tmp_pubkey, peer_tmp_pubkey_len, peer_enc_pubkey, peer_enc_pubkey_len, out, out.length, is_server);
        if (rv != 16) {
            throw new CryptoException("calc sm2 exchange key error");
        }
        return out;
    }

    @Override
    public ECCrefKeyPair generateECCKeyPair(int keysize) throws CryptoException {
        byte[] prv;
        long y;
        long bn;
        long point;
        int type = this.getECCCurveType(keysize);
        long ecc = InfosecIPPSM.ecc.ippEccNew(type, keysize);
        int rv = InfosecIPPSM.ecc.ippEccKeypair(ecc, keysize, point = InfosecIPPSM.ecc.ippPointNew(keysize), bn = InfosecIPPSM.ecc.ippBnNew(keysize));
        if (rv == 0) {
            throw new CryptoException("generate ecc keypair error");
        }
        long x = InfosecIPPSM.ecc.ippBnNew(keysize);
        int ret = InfosecIPPSM.ecc.ippPointGet(ecc, point, x, y = InfosecIPPSM.ecc.ippBnNew(keysize));
        if (ret <= 0) {
            System.out.printf("ippPointGet failed!\n", new Object[0]);
            InfosecIPPSM.ecc.ippFree(x);
            InfosecIPPSM.ecc.ippFree(y);
        }
        int blen = keysize / 8;
        byte[] qx = new byte[blen];
        byte[] qy = new byte[blen];
        ret = InfosecIPPSM.ecc.ippBnGet(x, qx, blen);
        if (ret <= 0) {
            System.out.printf("get qx error!\n", new Object[0]);
            InfosecIPPSM.ecc.ippFree(x);
        }
        if ((ret = InfosecIPPSM.ecc.ippBnGet(y, qy, blen)) <= 0) {
            System.out.printf("get qy error!\n", new Object[0]);
            InfosecIPPSM.ecc.ippFree(x);
        }
        if ((ret = InfosecIPPSM.ecc.ippBnGet(bn, prv = new byte[blen], blen)) <= 0) {
            System.out.printf("get d error!\n", new Object[0]);
            InfosecIPPSM.ecc.ippFree(bn);
        }
        ECCrefPublicKey refPublicKey = new ECCrefPublicKey(keysize, qx, qy);
        ECCrefPrivateKey refPrivateKey = new ECCrefPrivateKey(keysize, prv);
        return new ECCrefKeyPair(refPublicKey, refPrivateKey);
    }

    @Override
    public byte[][] ecDsaSign(ECCrefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("the private key is null");
        }
        if (input == null || input.length == 0) {
            throw new CryptoException("the input data size is 0");
        }
        int keysize = refPrivateKey.getBits();
        int type = this.getECCCurveType(keysize);
        long ecc = InfosecIPPSM.ecc.ippEccNew(type, keysize);
        long dgst = InfosecIPPSM.ecc.ippBnNew(input.length << 3);
        int ret = InfosecIPPSM.ecc.ippBnSet(dgst, input, input.length);
        if (ret <= 0) {
            throw new CryptoException("set digest failed!");
        }
        long prv = InfosecIPPSM.ecc.ippBnNew(keysize);
        ret = InfosecIPPSM.ecc.ippBnSet(prv, refPrivateKey.encode(), refPrivateKey.encode().length);
        if (ret <= 0) {
            throw new CryptoException("set private key failed!");
        }
        long r = InfosecIPPSM.ecc.ippBnNew(keysize);
        long s = InfosecIPPSM.ecc.ippBnNew(keysize);
        int blen = keysize / 8;
        byte[] br = new byte[blen];
        byte[] bs = new byte[blen];
        int rv = InfosecIPPSM.ecc.ippEccDsaSign(ecc, keysize, dgst, prv, r, s);
        if (rv == 0) {
            throw new CryptoException("ECC Dsa sign error: ");
        }
        ret = InfosecIPPSM.ecc.ippBnGet(r, br, blen);
        if (ret <= 0) {
            System.out.printf("get r error!\n", new Object[0]);
            InfosecIPPSM.ecc.ippFree(r);
        }
        if ((ret = InfosecIPPSM.ecc.ippBnGet(s, bs, blen)) <= 0) {
            System.out.printf("get s error!\n", new Object[0]);
            InfosecIPPSM.ecc.ippFree(s);
        }
        InfosecIPPSM.ecc.ippFree(dgst);
        InfosecIPPSM.ecc.ippFree(ecc);
        InfosecIPPSM.ecc.ippFree(r);
        InfosecIPPSM.ecc.ippFree(s);
        return new byte[][]{br, bs};
    }

    @Override
    public boolean eccDsaVerify(ECCrefPublicKey refPublicKey, byte[] input, byte[] br, byte[] bs) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("the public key is null");
        }
        if (input == null || input.length == 0) {
            throw new CryptoException("the input data size is 0");
        }
        int keysize = refPublicKey.getBits();
        int type = this.getECCCurveType(keysize);
        long ecc = InfosecIPPSM.ecc.ippEccNew(type, keysize);
        long dgst = InfosecIPPSM.ecc.ippBnNew(input.length << 3);
        int ret = InfosecIPPSM.ecc.ippBnSet(dgst, input, input.length);
        if (ret <= 0) {
            InfosecIPPSM.ecc.ippFree(dgst);
            throw new CryptoException("set digest failed!");
        }
        long point = InfosecIPPSM.ecc.ippPointNew(keysize);
        long x = InfosecIPPSM.ecc.ippBnNew(keysize);
        long y = InfosecIPPSM.ecc.ippBnNew(keysize);
        ret = InfosecIPPSM.ecc.ippBnSet(x, refPublicKey.getX(), refPublicKey.getX().length);
        if (ret <= 0) {
            InfosecIPPSM.ecc.ippFree(x);
            throw new CryptoException("set qx failed!");
        }
        ret = InfosecIPPSM.ecc.ippBnSet(y, refPublicKey.getY(), refPublicKey.getY().length);
        if (ret <= 0) {
            InfosecIPPSM.ecc.ippFree(y);
            throw new CryptoException("set qy failed!");
        }
        ret = InfosecIPPSM.ecc.ippPointSet(ecc, point, x, y);
        if (ret <= 0) {
            throw new CryptoException("set public key point failed!");
        }
        long r = InfosecIPPSM.ecc.ippBnNew(keysize);
        long s = InfosecIPPSM.ecc.ippBnNew(keysize);
        ret = InfosecIPPSM.ecc.ippBnSet(r, br, br.length);
        if (ret <= 0) {
            InfosecIPPSM.ecc.ippFree(r);
            throw new CryptoException("set r failed!");
        }
        ret = InfosecIPPSM.ecc.ippBnSet(s, bs, bs.length);
        if (ret <= 0) {
            InfosecIPPSM.ecc.ippFree(s);
            throw new CryptoException("set s failed!");
        }
        int rv = InfosecIPPSM.ecc.ippEccDsaVerify(ecc, keysize, dgst, point, r, s);
        if (rv == 0) {
            throw new CryptoException("EC DSA verify error ");
        }
        InfosecIPPSM.ecc.ippFree(dgst);
        InfosecIPPSM.ecc.ippFree(point);
        InfosecIPPSM.ecc.ippFree(ecc);
        InfosecIPPSM.ecc.ippFree(x);
        InfosecIPPSM.ecc.ippFree(y);
        InfosecIPPSM.ecc.ippFree(r);
        InfosecIPPSM.ecc.ippFree(s);
        return true;
    }

    @Override
    public byte[][] ecNrSign(ECCrefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("the private key is null");
        }
        if (input == null || input.length == 0) {
            throw new CryptoException("the input data size is 0");
        }
        int keysize = refPrivateKey.getBits();
        int type = this.getECCCurveType(keysize);
        long ecc = InfosecIPPSM.ecc.ippEccNew(type, keysize);
        long dgst = InfosecIPPSM.ecc.ippBnNew(input.length << 3);
        int ret = InfosecIPPSM.ecc.ippBnSet(dgst, input, input.length);
        if (ret <= 0) {
            throw new CryptoException("set digest failed!");
        }
        long prv = InfosecIPPSM.ecc.ippBnNew(keysize);
        ret = InfosecIPPSM.ecc.ippBnSet(prv, refPrivateKey.encode(), refPrivateKey.encode().length);
        if (ret <= 0) {
            throw new CryptoException("set private key failed!");
        }
        long r = InfosecIPPSM.ecc.ippBnNew(keysize);
        long s = InfosecIPPSM.ecc.ippBnNew(keysize);
        int blen = keysize / 8;
        byte[] br = new byte[blen];
        byte[] bs = new byte[blen];
        int rv = InfosecIPPSM.ecc.ippEccNrSign(ecc, keysize, dgst, prv, r, s);
        if (rv == 0) {
            throw new CryptoException("ECC Dsa sign error: ");
        }
        ret = InfosecIPPSM.ecc.ippBnGet(r, br, blen);
        if (ret <= 0) {
            System.out.printf("get r error!\n", new Object[0]);
            InfosecIPPSM.ecc.ippFree(r);
        }
        if ((ret = InfosecIPPSM.ecc.ippBnGet(s, bs, blen)) <= 0) {
            System.out.printf("get s error!\n", new Object[0]);
            InfosecIPPSM.ecc.ippFree(s);
        }
        InfosecIPPSM.ecc.ippFree(dgst);
        InfosecIPPSM.ecc.ippFree(ecc);
        InfosecIPPSM.ecc.ippFree(r);
        InfosecIPPSM.ecc.ippFree(s);
        return new byte[][]{br, bs};
    }

    @Override
    public boolean eccNrVerify(ECCrefPublicKey refPublicKey, byte[] input, byte[] br, byte[] bs) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("the public key is null");
        }
        if (input == null || input.length == 0) {
            throw new CryptoException("the input data size is 0");
        }
        int keysize = refPublicKey.getBits();
        int type = this.getECCCurveType(keysize);
        long ecc = InfosecIPPSM.ecc.ippEccNew(type, keysize);
        long dgst = InfosecIPPSM.ecc.ippBnNew(input.length << 3);
        int ret = InfosecIPPSM.ecc.ippBnSet(dgst, input, input.length);
        if (ret <= 0) {
            InfosecIPPSM.ecc.ippFree(dgst);
            throw new CryptoException("set digest failed!");
        }
        long point = InfosecIPPSM.ecc.ippPointNew(keysize);
        long x = InfosecIPPSM.ecc.ippBnNew(keysize);
        long y = InfosecIPPSM.ecc.ippBnNew(keysize);
        ret = InfosecIPPSM.ecc.ippBnSet(x, refPublicKey.getX(), refPublicKey.getX().length);
        if (ret <= 0) {
            InfosecIPPSM.ecc.ippFree(x);
            throw new CryptoException("set qx failed!");
        }
        ret = InfosecIPPSM.ecc.ippBnSet(y, refPublicKey.getY(), refPublicKey.getY().length);
        if (ret <= 0) {
            InfosecIPPSM.ecc.ippFree(y);
            throw new CryptoException("set qy failed!");
        }
        ret = InfosecIPPSM.ecc.ippPointSet(ecc, point, x, y);
        if (ret <= 0) {
            throw new CryptoException("set public key point failed!");
        }
        long r = InfosecIPPSM.ecc.ippBnNew(keysize);
        long s = InfosecIPPSM.ecc.ippBnNew(keysize);
        ret = InfosecIPPSM.ecc.ippBnSet(r, br, br.length);
        if (ret <= 0) {
            InfosecIPPSM.ecc.ippFree(r);
            throw new CryptoException("set r failed!");
        }
        ret = InfosecIPPSM.ecc.ippBnSet(s, bs, bs.length);
        if (ret <= 0) {
            InfosecIPPSM.ecc.ippFree(s);
            throw new CryptoException("set s failed!");
        }
        int rv = InfosecIPPSM.ecc.ippEccNrVerify(ecc, keysize, dgst, point, r, s);
        if (rv == 0) {
            throw new CryptoException("EC DSA verify error ");
        }
        InfosecIPPSM.ecc.ippFree(dgst);
        InfosecIPPSM.ecc.ippFree(point);
        InfosecIPPSM.ecc.ippFree(ecc);
        InfosecIPPSM.ecc.ippFree(x);
        InfosecIPPSM.ecc.ippFree(y);
        InfosecIPPSM.ecc.ippFree(r);
        InfosecIPPSM.ecc.ippFree(s);
        return true;
    }

    private int getECCCurveType(int keysize) {
        IPPECCCurveEnum curveEnum;
        switch (keysize) {
            case 192: {
                curveEnum = IPPECCCurveEnum.ippECPstd192r1;
                break;
            }
            case 224: {
                curveEnum = IPPECCCurveEnum.ippECPstd224r1;
                break;
            }
            case 256: {
                curveEnum = IPPECCCurveEnum.ippECPstd256r1;
                break;
            }
            case 384: {
                curveEnum = IPPECCCurveEnum.ippECPstd384r1;
                break;
            }
            case 521: {
                curveEnum = IPPECCCurveEnum.ippECPstd521r1;
                break;
            }
            case 239: {
                curveEnum = IPPECCCurveEnum.IppECCBStd239k1;
                break;
            }
            default: {
                return 0;
            }
        }
        return curveEnum.getType();
    }
}

