/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.crypto.signers;

import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.CryptoServicesRegistrar;
import cn.com.infosec.crypto.DSAExt;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.ECKeyParameters;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.device.SDSFactory;
import cn.com.infosec.device.bean.ECCrefPrivateKey;
import cn.com.infosec.device.bean.ECCrefPublicKey;
import cn.com.infosec.device.crypto.ISDSCrypto;
import cn.com.infosec.device.util.PrintUtil;
import cn.com.infosec.math.ec.ECAlgorithms;
import cn.com.infosec.math.ec.ECConstants;
import cn.com.infosec.math.ec.ECPoint;
import cn.com.infosec.util.BigIntegerUtil;
import cn.com.infosec.util.BigIntegers;
import cn.com.infosec.util.Debug;
import java.math.BigInteger;
import java.security.SecureRandom;

public class IPPECNRSigner
implements DSAExt {
    private boolean forSigning;
    private ECKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        this.forSigning = forSigning;
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = CryptoServicesRegistrar.getSecureRandom();
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger getOrder() {
        return this.key.getParameters().getN();
    }

    @Override
    public BigInteger[] generateSignature(byte[] digest) {
        byte[][] signature;
        if (!this.forSigning) {
            throw new IllegalStateException("not initialised for signing");
        }
        if (this.key == null) {
            throw new IllegalStateException("ECC NR sign engine not initialised");
        }
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        ECPrivateKeyParameters keyParam = (ECPrivateKeyParameters)this.key;
        byte[] d = BigIntegerUtil.asUnsigned32ByteArray(keyParam.getD());
        ECCrefPrivateKey privateKey = new ECCrefPrivateKey(d);
        try {
            signature = device.ecNrSign(privateKey, digest);
        }
        catch (Exception e) {
            Debug.println(Debug.ERROR, "eccSign error");
            System.err.println(privateKey);
            System.err.println("data input");
            System.err.println(PrintUtil.toHexString(digest));
            throw new RuntimeCryptoException(e.getMessage());
        }
        return new BigInteger[]{BigIntegerUtil.toPositiveInteger(signature[0]), BigIntegerUtil.toPositiveInteger(signature[1])};
    }

    @Override
    public boolean verifySignature(byte[] digest, BigInteger r, BigInteger s) {
        boolean flag;
        if (this.forSigning) {
            throw new IllegalStateException("not initialised for verifying");
        }
        if (this.key == null) {
            throw new IllegalStateException("ECC DSA sign engine not initialised");
        }
        ECDomainParameters ec = this.key.getParameters();
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        ECPublicKeyParameters keyParam = (ECPublicKeyParameters)this.key;
        byte[] x = BigIntegerUtil.asUnsigned32ByteArray(keyParam.getQ().getAffineXCoord().toBigInteger());
        byte[] y = BigIntegerUtil.asUnsigned32ByteArray(keyParam.getQ().getAffineYCoord().toBigInteger());
        ECCrefPublicKey publicKey = new ECCrefPublicKey(x, y);
        try {
            flag = device.eccNrVerify(publicKey, digest, BigIntegerUtil.asUnsigned32ByteArray(r), BigIntegerUtil.asUnsigned32ByteArray(s));
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        return flag;
    }

    public byte[] getRecoveredMessage(BigInteger r, BigInteger s) {
        if (this.forSigning) {
            throw new IllegalStateException("not initialised for verifying/recovery");
        }
        BigInteger t = this.extractT((ECPublicKeyParameters)this.key, r, s);
        if (t != null) {
            return BigIntegers.asUnsignedByteArray(t);
        }
        return null;
    }

    private BigInteger extractT(ECPublicKeyParameters pubKey, BigInteger r, BigInteger s) {
        ECPoint W;
        BigInteger n = pubKey.getParameters().getN();
        if (r.compareTo(ECConstants.ONE) < 0 || r.compareTo(n) >= 0) {
            return null;
        }
        if (s.compareTo(ECConstants.ZERO) < 0 || s.compareTo(n) >= 0) {
            return null;
        }
        ECPoint G = pubKey.getParameters().getG();
        ECPoint P = ECAlgorithms.sumOfTwoMultiplies(G, s, W = pubKey.getQ(), r).normalize();
        if (P.isInfinity()) {
            return null;
        }
        BigInteger x = P.getAffineXCoord().toBigInteger();
        return r.subtract(x).mod(n);
    }
}

