/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider.asymmetric;

import cn.com.infosec.asn1.gm.GMObjectIdentifiers;
import cn.com.infosec.jcajce.provider.config.ConfigurableProvider;
import cn.com.infosec.jcajce.provider.util.AsymmetricAlgorithmProvider;
import java.util.HashMap;
import java.util.Map;

public class SM2 {
    private static final String PREFIX = "cn.com.infosec.ipp.provider.asymmetric.sm2.";
    private static final Map<String, String> generalSm2Attributes = new HashMap<String, String>();

    static {
        generalSm2Attributes.put("SupportedKeyClasses", "java.security.interfaces.ECPublicKey|java.security.interfaces.ECPrivateKey");
        generalSm2Attributes.put("SupportedKeyFormats", "PKCS#8|X.509");
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAttributes("KeyAgreement.SM2DH", generalSm2Attributes);
            provider.addAlgorithm("KeyAgreement.SM2DH", "cn.com.infosec.ipp.provider.asymmetric.sm2.KeyAgreementSpi$SM2DH");
            provider.addAlgorithm("KeyFactory.SM2", "cn.com.infosec.ipp.provider.asymmetric.sm2.KeyFactorySpi$SM2");
            provider.addAlgorithm("Alg.Alias.KeyFactory." + GMObjectIdentifiers.sm2p256v1, "SM2");
            provider.addAlgorithm("KeyPairGenerator.SM2", "cn.com.infosec.ipp.provider.asymmetric.sm2.KeyPairGeneratorSpi$SM2");
            provider.addAlgorithm("Cipher.SM2", "cn.com.infosec.ipp.provider.asymmetric.sm2.CipherSpi");
            provider.addAlgorithm("Cipher.sm2", "cn.com.infosec.ipp.provider.asymmetric.sm2.CipherSpi");
            provider.addAlgorithm("Signature.SM3withSM2", "cn.com.infosec.ipp.provider.asymmetric.sm2.SignatureSpi$SM2");
            provider.addAlgorithm("Signature.SM3WITHSM2", "cn.com.infosec.ipp.provider.asymmetric.sm2.SignatureSpi$SM2");
            provider.addAlgorithm("Signature.sm3withsm2", "cn.com.infosec.ipp.provider.asymmetric.sm2.SignatureSpi$SM2");
            provider.addAlgorithm("Signature.SM3WithSM2", "cn.com.infosec.ipp.provider.asymmetric.sm2.SignatureSpi$SM2");
            provider.addAlgorithm("Signature.SM2", "cn.com.infosec.ipp.provider.asymmetric.sm2.SignatureSpi$SM2");
            provider.addAlgorithm("Signature.sm2", "cn.com.infosec.ipp.provider.asymmetric.sm2.SignatureSpi$SM2");
            provider.addAlgorithm("Alg.Alias.Signature.1.2.156.10197.1.501", "SM3withSM2");
            provider.addAlgorithm("Alg.Alias.Signature.OID.1.2.156.10197.1.501", "SM3withSM2");
        }
    }
}

