/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider.asymmetric.ec;

import cn.com.infosec.asn1.ASN1ObjectIdentifier;
import cn.com.infosec.asn1.pkcs.PrivateKeyInfo;
import cn.com.infosec.asn1.sec.ECPrivateKey;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.asn1.x9.X9ObjectIdentifiers;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.crypto.util.OpenSSHPublicKeyUtil;
import cn.com.infosec.ipp.provider.asymmetric.ec.INFOSECECPrivateKey;
import cn.com.infosec.ipp.provider.asymmetric.ec.INFOSECECPublicKey;
import cn.com.infosec.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import cn.com.infosec.jcajce.provider.asymmetric.util.EC5Util;
import cn.com.infosec.jcajce.provider.config.ProviderConfiguration;
import cn.com.infosec.jcajce.provider.util.AsymmetricKeyInfoConverter;
import cn.com.infosec.jce.provider.INFOSECProvider;
import cn.com.infosec.jce.spec.ECParameterSpec;
import cn.com.infosec.jce.spec.ECPrivateKeySpec;
import cn.com.infosec.jce.spec.ECPublicKeySpec;
import cn.com.infosec.jce.spec.OpenSSHPrivateKeySpec;
import cn.com.infosec.jce.spec.OpenSSHPublicKeySpec;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public class KeyFactorySpi
extends BaseKeyFactorySpi
implements AsymmetricKeyInfoConverter {
    String algorithm;
    ProviderConfiguration configuration;

    KeyFactorySpi(String algorithm, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.configuration = configuration;
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof ECPublicKey) {
            return new INFOSECECPublicKey((ECPublicKey)key, this.configuration);
        }
        if (key instanceof java.security.interfaces.ECPrivateKey) {
            return new INFOSECECPrivateKey((java.security.interfaces.ECPrivateKey)key, this.configuration);
        }
        throw new InvalidKeyException("key type unknown");
    }

    @Override
    protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
        if (spec.isAssignableFrom(java.security.spec.ECPublicKeySpec.class) && key instanceof ECPublicKey) {
            ECPublicKey k = (ECPublicKey)key;
            if (k.getParams() != null) {
                return new java.security.spec.ECPublicKeySpec(k.getW(), k.getParams());
            }
            ECParameterSpec implicitSpec = INFOSECProvider.CONFIGURATION.getEcImplicitlyCa();
            return new java.security.spec.ECPublicKeySpec(k.getW(), EC5Util.convertSpec(EC5Util.convertCurve(implicitSpec.getCurve(), implicitSpec.getSeed()), implicitSpec));
        }
        if (spec.isAssignableFrom(java.security.spec.ECPrivateKeySpec.class) && key instanceof java.security.interfaces.ECPrivateKey) {
            java.security.interfaces.ECPrivateKey k = (java.security.interfaces.ECPrivateKey)key;
            if (k.getParams() != null) {
                return new java.security.spec.ECPrivateKeySpec(k.getS(), k.getParams());
            }
            ECParameterSpec implicitSpec = INFOSECProvider.CONFIGURATION.getEcImplicitlyCa();
            return new java.security.spec.ECPrivateKeySpec(k.getS(), EC5Util.convertSpec(EC5Util.convertCurve(implicitSpec.getCurve(), implicitSpec.getSeed()), implicitSpec));
        }
        if (spec.isAssignableFrom(ECPublicKeySpec.class) && key instanceof ECPublicKey) {
            ECPublicKey k = (ECPublicKey)key;
            if (k.getParams() != null) {
                return new ECPublicKeySpec(EC5Util.convertPoint(k.getParams(), k.getW()), EC5Util.convertSpec(k.getParams()));
            }
            ECParameterSpec implicitSpec = INFOSECProvider.CONFIGURATION.getEcImplicitlyCa();
            return new ECPublicKeySpec(EC5Util.convertPoint(k.getParams(), k.getW()), implicitSpec);
        }
        if (spec.isAssignableFrom(ECPrivateKeySpec.class) && key instanceof java.security.interfaces.ECPrivateKey) {
            java.security.interfaces.ECPrivateKey k = (java.security.interfaces.ECPrivateKey)key;
            if (k.getParams() != null) {
                return new ECPrivateKeySpec(k.getS(), EC5Util.convertSpec(k.getParams()));
            }
            ECParameterSpec implicitSpec = INFOSECProvider.CONFIGURATION.getEcImplicitlyCa();
            return new ECPrivateKeySpec(k.getS(), implicitSpec);
        }
        if (spec.isAssignableFrom(OpenSSHPublicKeySpec.class) && key instanceof ECPublicKey) {
            if (key instanceof INFOSECECPublicKey) {
                INFOSECECPublicKey bcPk = (INFOSECECPublicKey)key;
                ECParameterSpec sc = bcPk.getParameters();
                try {
                    return new OpenSSHPublicKeySpec(OpenSSHPublicKeyUtil.encodePublicKey(new ECPublicKeyParameters(bcPk.getQ(), new ECDomainParameters(sc.getCurve(), sc.getG(), sc.getN(), sc.getH(), sc.getSeed()))));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("unable to produce encoding: " + e.getMessage());
                }
            }
            throw new IllegalArgumentException("invalid key type: " + key.getClass().getName());
        }
        if (spec.isAssignableFrom(OpenSSHPrivateKeySpec.class) && key instanceof java.security.interfaces.ECPrivateKey) {
            if (key instanceof INFOSECECPrivateKey) {
                try {
                    return new OpenSSHPrivateKeySpec(PrivateKeyInfo.getInstance(key.getEncoded()).parsePrivateKey().toASN1Primitive().getEncoded());
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("cannot encoded key: " + e.getMessage());
                }
            }
            throw new IllegalArgumentException("invalid key type: " + key.getClass().getName());
        }
        return super.engineGetKeySpec(key, spec);
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof ECPrivateKeySpec) {
            return new INFOSECECPrivateKey(this.algorithm, (ECPrivateKeySpec)keySpec, this.configuration);
        }
        if (keySpec instanceof java.security.spec.ECPrivateKeySpec) {
            return new INFOSECECPrivateKey(this.algorithm, (java.security.spec.ECPrivateKeySpec)keySpec, this.configuration);
        }
        if (keySpec instanceof OpenSSHPrivateKeySpec) {
            ECPrivateKey ecKey = ECPrivateKey.getInstance(((OpenSSHPrivateKeySpec)keySpec).getEncoded());
            try {
                return new INFOSECECPrivateKey(this.algorithm, new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, ecKey.getParameters()), ecKey), this.configuration);
            }
            catch (IOException e) {
                throw new InvalidKeySpecException("bad encoding: " + e.getMessage());
            }
        }
        return super.engineGeneratePrivate(keySpec);
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof ECPublicKeySpec) {
                return new INFOSECECPublicKey(this.algorithm, (ECPublicKeySpec)keySpec, this.configuration);
            }
            if (keySpec instanceof java.security.spec.ECPublicKeySpec) {
                return new INFOSECECPublicKey(this.algorithm, (java.security.spec.ECPublicKeySpec)keySpec, this.configuration);
            }
            if (keySpec instanceof OpenSSHPublicKeySpec) {
                AsymmetricKeyParameter params = OpenSSHPublicKeyUtil.parsePublicKey(((OpenSSHPublicKeySpec)keySpec).getEncoded());
                if (params instanceof ECPublicKeyParameters) {
                    ECDomainParameters parameters = ((ECPublicKeyParameters)params).getParameters();
                    return this.engineGeneratePublic(new ECPublicKeySpec(((ECPublicKeyParameters)params).getQ(), new ECParameterSpec(parameters.getCurve(), parameters.getG(), parameters.getN(), parameters.getH(), parameters.getSeed())));
                }
                throw new IllegalArgumentException("openssh key is not ec public key");
            }
        }
        catch (Exception e) {
            throw new InvalidKeySpecException("invalid KeySpec: " + e.getMessage(), e);
        }
        return super.engineGeneratePublic(keySpec);
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (algOid.equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            return new INFOSECECPrivateKey(this.algorithm, keyInfo, this.configuration);
        }
        throw new IOException("algorithm identifier " + algOid + " in key not recognised");
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getAlgorithm().getAlgorithm();
        if (algOid.equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            return new INFOSECECPublicKey(this.algorithm, keyInfo, this.configuration);
        }
        throw new IOException("algorithm identifier " + algOid + " in key not recognised");
    }

    public static class ECMQV
    extends KeyFactorySpi {
        public ECMQV() {
            super("ECMQV", INFOSECProvider.CONFIGURATION);
        }
    }

    public static class ECDHC
    extends KeyFactorySpi {
        public ECDHC() {
            super("ECDHC", INFOSECProvider.CONFIGURATION);
        }
    }

    public static class ECDH
    extends KeyFactorySpi {
        public ECDH() {
            super("ECDH", INFOSECProvider.CONFIGURATION);
        }
    }

    public static class ECGOST3410_2012
    extends KeyFactorySpi {
        public ECGOST3410_2012() {
            super("ECGOST3410-2012", INFOSECProvider.CONFIGURATION);
        }
    }

    public static class ECGOST3410
    extends KeyFactorySpi {
        public ECGOST3410() {
            super("ECGOST3410", INFOSECProvider.CONFIGURATION);
        }
    }

    public static class ECDSA
    extends KeyFactorySpi {
        public ECDSA() {
            super("ECDSA", INFOSECProvider.CONFIGURATION);
        }
    }

    public static class EC
    extends KeyFactorySpi {
        public EC() {
            super("EC", INFOSECProvider.CONFIGURATION);
        }
    }
}

