/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider.asymmetric.sm2;

import cn.com.infosec.asn1.gm.GMNamedCurves;
import cn.com.infosec.asn1.x9.X9ECParameters;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.device.SDSFactory;
import cn.com.infosec.device.bean.SM2refPrivateKey;
import cn.com.infosec.device.bean.SM2refPublicKey;
import cn.com.infosec.device.crypto.ISDSCrypto;
import cn.com.infosec.device.util.PrintUtil;
import cn.com.infosec.jcajce.provider.asymmetric.util.BaseCipherSpi;
import cn.com.infosec.jcajce.provider.asymmetric.util.ECUtil;
import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.math.ec.ECPoint;
import cn.com.infosec.util.BigIntegerUtil;
import cn.com.infosec.util.Debug;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class CipherSpi
extends BaseCipherSpi {
    Key key;
    boolean encrypt;
    static X9ECParameters param = GMNamedCurves.getByName("sm2p256v1");
    static ECCurve curve = param.getCurve();
    static ECPoint G = param.getG();
    static BigInteger n = param.getN();

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return 32;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return 65 + inputLen + 32;
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.key = key;
        this.encrypt = opmode == 1;
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec paramSpec = null;
        this.engineInit(opmode, key, paramSpec, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("Eeeek! " + e.toString(), e);
        }
    }

    public static byte[] combineByteArray(byte[] a, int rlen1, byte[] b, int rlen2) {
        byte[] ca = new byte[rlen1];
        for (int i = 0; i < ca.length; ++i) {
            ca[i] = 0;
        }
        if (a.length == rlen1) {
            System.arraycopy(a, 0, ca, 0, rlen1);
        } else if (a.length > rlen1) {
            int aStart = a.length - rlen1;
            System.arraycopy(a, aStart, ca, 0, rlen1);
        } else {
            int caStart = rlen1 - a.length;
            System.arraycopy(a, 0, ca, caStart, a.length);
        }
        byte[] cb = new byte[rlen2];
        for (int i = 0; i < cb.length; ++i) {
            cb[i] = 0;
        }
        if (b.length == rlen2) {
            System.arraycopy(b, 0, cb, 0, rlen2);
        } else if (b.length > rlen2) {
            int bStart = b.length - rlen2;
            System.arraycopy(b, bStart, cb, 0, rlen2);
        } else {
            int cbStart = rlen2 - b.length;
            System.arraycopy(b, 0, cb, cbStart, b.length);
        }
        byte[] c = new byte[rlen1 + rlen2];
        System.arraycopy(ca, 0, c, 0, rlen1);
        System.arraycopy(cb, 0, c, rlen1, rlen2);
        return c;
    }

    public static byte[] combineByteArray(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static byte[] int2bytes(int num) {
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bytes[3 - i] = (byte)(0xFF & num >> i * 8);
        }
        return bytes;
    }

    private static byte[] enc(PublicKey pub, byte[] plain) {
        AsymmetricKeyParameter param;
        if (pub == null) {
            throw new IllegalStateException("SM2 engine not initialised");
        }
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        try {
            param = ECUtil.generatePublicKeyParameter(pub);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        ECPublicKeyParameters keyParam = (ECPublicKeyParameters)param;
        byte[] x = BigIntegerUtil.asUnsigned32ByteArray(keyParam.getQ().getAffineXCoord().toBigInteger());
        byte[] y = BigIntegerUtil.asUnsigned32ByteArray(keyParam.getQ().getAffineYCoord().toBigInteger());
        SM2refPublicKey publicKey = new SM2refPublicKey(x, y);
        byte[] refCipher = null;
        try {
            refCipher = device.sm2Encrypt(publicKey, plain);
        }
        catch (Exception e) {
            Debug.println(Debug.ERROR, "sm2PublicKeyEncryption error");
            System.out.println("\u516c\u94a5:");
            System.out.println(publicKey);
            System.out.println(PrintUtil.toHexString(plain));
            throw new RuntimeCryptoException(e.getMessage());
        }
        return refCipher;
    }

    private static byte[] dec(PrivateKey pri, byte[] encData) {
        AsymmetricKeyParameter param;
        if (pri == null) {
            throw new IllegalStateException("SM2 engine not initialised");
        }
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        try {
            param = ECUtil.generatePrivateKeyParameter(pri);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        ECPrivateKeyParameters keyParam = (ECPrivateKeyParameters)param;
        SM2refPrivateKey privateKey = new SM2refPrivateKey(keyParam.getD().toByteArray());
        byte[] refCipher = null;
        try {
            refCipher = device.sm2Decrypt(privateKey, encData);
        }
        catch (Exception e) {
            Debug.println(Debug.ERROR, "sm2privateKeyDecryption error");
            System.out.println("privatekey:");
            System.out.println(privateKey);
            System.out.println(PrintUtil.toHexString(encData));
            throw new RuntimeCryptoException(e.getMessage());
        }
        return refCipher;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (this.encrypt) {
            byte[] M = new byte[inputLen];
            System.arraycopy(input, inputOffset, M, 0, inputLen);
            return CipherSpi.enc((PublicKey)this.key, M);
        }
        byte[] M = new byte[inputLen];
        System.arraycopy(input, inputOffset, M, 0, inputLen);
        return CipherSpi.dec((PrivateKey)this.key, M);
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException {
        byte[] out = this.engineDoFinal(input, inputOffset, inputLen);
        System.arraycopy(out, 0, output, outputOffset, out.length);
        return 0;
    }

    @Override
    protected byte[] engineUpdate(byte[] arg0, int arg1, int arg2) {
        return new byte[0];
    }

    @Override
    protected int engineUpdate(byte[] arg0, int arg1, int arg2, byte[] arg3, int arg4) throws ShortBufferException {
        return 0;
    }
}

