/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider.asymmetric.sm2;

import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.agreement.IPPSM2Agreement;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.crypto.params.IPPSM2KeyExchangePrivateParameters;
import cn.com.infosec.crypto.params.IPPSM2KeyExchangePublicParameters;
import cn.com.infosec.crypto.params.ParametersWithID;
import cn.com.infosec.jcajce.provider.asymmetric.util.ECUtil;
import cn.com.infosec.jcajce.spec.MQVParameterSpec;
import cn.com.infosec.jcajce.spec.SM2DHParameterSpec;
import cn.com.infosec.jce.interfaces.INFOSECPublicKey;
import cn.com.infosec.jce.interfaces.SM2DHPrivateKey;
import cn.com.infosec.jce.interfaces.SM2DHPublicKey;
import cn.com.infosec.util.Arrays;
import cn.com.infosec.util.Strings;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class KeyAgreementSpi
extends javax.crypto.KeyAgreementSpi {
    private String kaAlgorithm;
    private Object agreement;
    private SM2DHParameterSpec sm2dheParameters;
    private byte[] result;

    protected KeyAgreementSpi(String kaAlgorithm, IPPSM2Agreement agreement) {
        this.kaAlgorithm = kaAlgorithm;
        this.agreement = agreement;
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        byte[] id;
        CipherParameters pubKey;
        if (!(key instanceof SM2DHPublicKey) && this.sm2dheParameters == null) {
            throw new IllegalStateException(this.kaAlgorithm + " not initialised.");
        }
        if (!lastPhase) {
            throw new IllegalStateException(this.kaAlgorithm + " can only be between two parties.");
        }
        if (this.agreement instanceof IPPSM2Agreement) {
            if (!(key instanceof SM2DHPublicKey)) {
                ECPublicKeyParameters staticKey = (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter((PublicKey)key);
                ECPublicKeyParameters ephemKey = (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter(this.sm2dheParameters.getOtherPartyEphemeralKey());
                pubKey = new IPPSM2KeyExchangePublicParameters(staticKey, ephemKey);
                id = this.sm2dheParameters.getOtherId();
            } else {
                SM2DHPublicKey sm2DhPubKey = (SM2DHPublicKey)key;
                ECPublicKeyParameters staticKey = (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter(sm2DhPubKey.getStaticKey());
                ECPublicKeyParameters ephemKey = (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter(sm2DhPubKey.getEphemeralKey());
                pubKey = new IPPSM2KeyExchangePublicParameters(staticKey, ephemKey);
                id = sm2DhPubKey.getId();
            }
        } else {
            if (!(key instanceof PublicKey)) {
                throw new InvalidKeyException(this.kaAlgorithm + " key agreement requires " + KeyAgreementSpi.getSimpleName(INFOSECPublicKey.class) + " for doPhase");
            }
            pubKey = ECUtil.generatePublicKeyParameter((PublicKey)key);
            id = new byte[]{};
        }
        try {
            this.result = ((IPPSM2Agreement)this.agreement).calculateKey(128, new ParametersWithID(pubKey, id));
        }
        catch (Exception e) {
            throw new InvalidKeyException("calculation failed: " + e.getMessage()){

                @Override
                public Throwable getCause() {
                    return e;
                }
            };
        }
        return null;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null && !(params instanceof SM2DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("No algorithm parameters supported");
        }
        this.initFromKey(key, params);
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.initFromKey(key, null);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    private void initFromKey(Key key, AlgorithmParameterSpec parameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.agreement instanceof IPPSM2Agreement) {
            byte[] id;
            boolean initiator;
            ECPrivateKeyParameters ephemPrivKey;
            ECPrivateKeyParameters staticPrivKey;
            this.sm2dheParameters = null;
            if (!(key instanceof SM2DHPrivateKey) && !(parameterSpec instanceof SM2DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException(this.kaAlgorithm + " key agreement requires " + KeyAgreementSpi.getSimpleName(MQVParameterSpec.class) + " for initialisation");
            }
            if (key instanceof SM2DHPrivateKey) {
                SM2DHPrivateKey sm2dhPrivKey = (SM2DHPrivateKey)key;
                staticPrivKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter(sm2dhPrivKey.getStaticPrivateKey());
                ephemPrivKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter(sm2dhPrivKey.getEphemeralPrivateKey());
                initiator = sm2dhPrivKey.isInitiator();
                id = ((SM2DHPrivateKey)key).getId();
            } else {
                SM2DHParameterSpec sm2DhParameterSpec = (SM2DHParameterSpec)parameterSpec;
                staticPrivKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)key);
                ephemPrivKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter(sm2DhParameterSpec.getEphemeralPrivateKey());
                initiator = sm2DhParameterSpec.isInitiator();
                id = sm2DhParameterSpec.getId();
                this.sm2dheParameters = sm2DhParameterSpec;
            }
            IPPSM2KeyExchangePrivateParameters localParams = new IPPSM2KeyExchangePrivateParameters(initiator, staticPrivKey, ephemPrivKey);
            ((IPPSM2Agreement)this.agreement).init(new ParametersWithID(localParams, id));
        }
    }

    private static String getSimpleName(Class clazz) {
        String fullName = clazz.getName();
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    protected byte[] calcSecret() {
        return Arrays.clone(this.result);
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        return this.calcSecret();
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        byte[] secret = this.engineGenerateSecret();
        if (sharedSecret.length - offset < secret.length) {
            throw new ShortBufferException(this.kaAlgorithm + " key agreement: need " + secret.length + " bytes");
        }
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        return secret.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        String algKey = Strings.toUpperCase(algorithm);
        if (algorithm.equals("TlsPremasterSecret")) {
            return new SecretKeySpec(KeyAgreementSpi.trimZeroes(this.result), algorithm);
        }
        byte[] secret = this.calcSecret();
        return new SecretKeySpec(secret, algKey);
    }

    protected static byte[] trimZeroes(byte[] secret) {
        int ind;
        if (secret[0] != 0) {
            return secret;
        }
        for (ind = 0; ind < secret.length && secret[ind] == 0; ++ind) {
        }
        byte[] rv = new byte[secret.length - ind];
        System.arraycopy(secret, ind, rv, 0, rv.length);
        return rv;
    }

    public static class SM2DH
    extends KeyAgreementSpi {
        public SM2DH() {
            super("SM2", new IPPSM2Agreement());
        }
    }
}

