/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider.asymmetric.sm9;

import cn.com.infosec.asn1.gm.SM9CurveParameters;
import cn.com.infosec.asn1.x9.X962NamedCurves;
import cn.com.infosec.asn1.x9.X9ECParameters;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.digests.SM3Digest;
import cn.com.infosec.device.IBEFactory;
import cn.com.infosec.device.ibe.UserPublicKey;
import cn.com.infosec.device.sds.IBEDevice;
import cn.com.infosec.device.util.PrintUtil;
import cn.com.infosec.ipp.provider.asymmetric.sm9.SM9UserPrivateKey;
import cn.com.infosec.ipp.provider.asymmetric.sm9.SM9UserPublicKey;
import cn.com.infosec.jcajce.provider.asymmetric.util.BaseCipherSpi;
import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.math.ec.ECPoint;
import cn.com.infosec.util.Debug;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class CipherSpi
extends BaseCipherSpi {
    Key key;
    boolean encrypt;
    static X9ECParameters param = X962NamedCurves.getByName("prime256v1_sm2");
    static ECCurve curve = param.getCurve();
    static ECPoint G = param.getG();
    static BigInteger n = param.getN();

    private static byte[] sm3hash(byte[] d) {
        SM3Digest sm3 = new SM3Digest();
        sm3.update(d, 0, d.length);
        byte[] r = new byte[32];
        sm3.doFinal(r, 0);
        return r;
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return 32;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return 65 + inputLen + 32;
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.key = key;
        this.encrypt = opmode == 1;
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec paramSpec = null;
        this.engineInit(opmode, key, paramSpec, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("Eeeek! " + e.toString(), e);
        }
    }

    public static byte[] combineByteArray(byte[] a, int rlen1, byte[] b, int rlen2) {
        byte[] ca = new byte[rlen1];
        for (int i = 0; i < ca.length; ++i) {
            ca[i] = 0;
        }
        if (a.length == rlen1) {
            System.arraycopy(a, 0, ca, 0, rlen1);
        } else if (a.length > rlen1) {
            int aStart = a.length - rlen1;
            System.arraycopy(a, aStart, ca, 0, rlen1);
        } else {
            int caStart = rlen1 - a.length;
            System.arraycopy(a, 0, ca, caStart, a.length);
        }
        byte[] cb = new byte[rlen2];
        for (int i = 0; i < cb.length; ++i) {
            cb[i] = 0;
        }
        if (b.length == rlen2) {
            System.arraycopy(b, 0, cb, 0, rlen2);
        } else if (b.length > rlen2) {
            int bStart = b.length - rlen2;
            System.arraycopy(b, bStart, cb, 0, rlen2);
        } else {
            int cbStart = rlen2 - b.length;
            System.arraycopy(b, 0, cb, cbStart, b.length);
        }
        byte[] c = new byte[rlen1 + rlen2];
        System.arraycopy(ca, 0, c, 0, rlen1);
        System.arraycopy(cb, 0, c, rlen1, rlen2);
        return c;
    }

    public static byte[] combineByteArray(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static byte[] int2bytes(int num) {
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bytes[3 - i] = (byte)(0xFF & num >> i * 8);
        }
        return bytes;
    }

    private static byte[] KDF(byte[] Z, int klen) {
        int blockSize = 32;
        int outLen = klen % blockSize == 0 ? klen : (klen / blockSize + 1) * blockSize;
        byte[] out = new byte[outLen];
        int ct = 1;
        byte[] hash = null;
        int outOffset = 0;
        for (int i = 0; i < outLen / blockSize; ++i) {
            byte[] bsct = CipherSpi.int2bytes(ct);
            byte[] buf = new byte[Z.length + bsct.length];
            System.arraycopy(Z, 0, buf, 0, Z.length);
            System.arraycopy(bsct, 0, buf, Z.length, bsct.length);
            hash = CipherSpi.sm3hash(buf);
            System.arraycopy(hash, 0, out, outOffset, hash.length);
            outOffset += hash.length;
            ++ct;
        }
        return out;
    }

    private static byte[] enc(SM9UserPublicKey pub, byte[] plain) {
        if (pub == null) {
            throw new IllegalStateException("SM2 engine not initialised");
        }
        IBEDevice device = null;
        try {
            device = IBEFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        UserPublicKey refPublicKey = new UserPublicKey();
        refPublicKey.len = pub.getIdLen();
        refPublicKey.pid = pub.getUid();
        refPublicKey.reseved = pub.getQ();
        BigInteger r = BigInteger.ZERO;
        while ((r = new BigInteger(256, new SecureRandom())).equals(BigInteger.ZERO) || r.compareTo(SM9CurveParameters.N) >= 0) {
        }
        byte[] refCipher = null;
        try {
            refCipher = device.sm9Encrypt(pub.getZzn12Enc(), refPublicKey, plain, r.toByteArray());
        }
        catch (Exception e) {
            Debug.println(Debug.ERROR, "sm2PublicKeyEncryption error");
            System.out.println("\u516c\u94a5:");
            System.out.println(PrintUtil.toHexString(pub.getQ()));
            System.out.println(PrintUtil.toHexString(plain));
            throw new RuntimeCryptoException(e.getMessage());
        }
        return refCipher;
    }

    private static byte[] dec(SM9UserPrivateKey pri, byte[] encData) {
        if (pri == null) {
            throw new IllegalStateException("SM9 engine not initialised");
        }
        IBEDevice device = null;
        try {
            device = IBEFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        UserPublicKey refPublicKey = new UserPublicKey();
        refPublicKey.len = pri.getIdLen();
        refPublicKey.pid = pri.getUid();
        byte[] plain = null;
        try {
            plain = device.sm9Decrypt(refPublicKey, pri.getD(), encData);
        }
        catch (Exception e) {
            Debug.println(Debug.ERROR, "sm2privateKeyDecryption error");
            System.out.println("privatekey:");
            System.out.println("LEN:" + pri.getD().length);
            System.out.println(PrintUtil.toHexString(pri.getD()));
            System.out.println(PrintUtil.toHexString(encData));
            throw new RuntimeCryptoException(e.getMessage());
        }
        return plain;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (this.encrypt) {
            byte[] M = new byte[inputLen];
            System.arraycopy(input, inputOffset, M, 0, inputLen);
            return CipherSpi.enc((SM9UserPublicKey)this.key, M);
        }
        byte[] M = new byte[inputLen];
        System.arraycopy(input, inputOffset, M, 0, inputLen);
        return CipherSpi.dec((SM9UserPrivateKey)this.key, M);
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException {
        byte[] out = this.engineDoFinal(input, inputOffset, inputLen);
        System.arraycopy(out, 0, output, outputOffset, out.length);
        return 0;
    }

    @Override
    protected byte[] engineUpdate(byte[] arg0, int arg1, int arg2) {
        return new byte[0];
    }

    @Override
    protected int engineUpdate(byte[] arg0, int arg1, int arg2, byte[] arg3, int arg4) throws ShortBufferException {
        return 0;
    }
}

