/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider.asymmetric.sm9;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.KeyGenerationParameters;
import cn.com.infosec.crypto.generators.SM9MasterKeyPairGenerator;
import cn.com.infosec.crypto.generators.SM9UserKeyPairGenerator;
import cn.com.infosec.crypto.params.SM9PrivateKeyParameters;
import cn.com.infosec.crypto.params.SM9PublicKeyParameters;
import cn.com.infosec.crypto.params.SM9UserKeyGenerationParameters;
import cn.com.infosec.crypto.params.SM9UserPublicKeyParameters;
import cn.com.infosec.ipp.provider.asymmetric.sm9.SM9MasterPrivateKey;
import cn.com.infosec.ipp.provider.asymmetric.sm9.SM9MasterPublicKey;
import cn.com.infosec.ipp.provider.asymmetric.sm9.SM9UserPrivateKey;
import cn.com.infosec.ipp.provider.asymmetric.sm9.SM9UserPublicKey;
import cn.com.infosec.jcajce.provider.config.ProviderConfiguration;
import cn.com.infosec.jce.provider.INFOSECProvider;
import cn.com.infosec.jce.spec.SM9ParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public abstract class KeyPairGeneratorSpi
extends KeyPairGenerator {
    public KeyPairGeneratorSpi(String algorithmName) {
        super(algorithmName);
    }

    public static class SM9
    extends KeyPairGeneratorSpi {
        SM9UserKeyGenerationParameters param;
        SM9UserKeyPairGenerator engine = new SM9UserKeyPairGenerator();
        int strength = 239;
        int certainty = 50;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;
        String algorithm;
        ProviderConfiguration configuration;

        public SM9() {
            super("SM9");
            this.algorithm = "SM9";
            this.configuration = INFOSECProvider.CONFIGURATION;
        }

        public SM9(String algorithm, ProviderConfiguration configuration) {
            super(algorithm);
            this.algorithm = algorithm;
            this.configuration = configuration;
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof SM9ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a SM9ParameterSpec");
            }
            SM9ParameterSpec p = (SM9ParameterSpec)params;
            this.param = new SM9UserKeyGenerationParameters(p, random);
            this.engine.init(this.param);
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                throw new InvalidParameterException(" AlgorithmParameter has not been initialized.");
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            SM9UserPublicKeyParameters pub = (SM9UserPublicKeyParameters)pair.getPublic();
            SM9PrivateKeyParameters priv = (SM9PrivateKeyParameters)pair.getPrivate();
            SM9UserPublicKey pubKey = new SM9UserPublicKey(this.algorithm, pub, this.configuration);
            return new KeyPair(pubKey, new SM9UserPrivateKey(this.algorithm, priv, pubKey, this.configuration));
        }
    }

    public static class KGC
    extends KeyPairGeneratorSpi {
        KeyGenerationParameters param;
        SM9MasterKeyPairGenerator engine = new SM9MasterKeyPairGenerator();
        int strength = 239;
        int certainty = 50;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;
        String algorithm;
        ProviderConfiguration configuration;

        public KGC() {
            super("SM9");
            this.algorithm = "SM9";
            this.configuration = INFOSECProvider.CONFIGURATION;
        }

        public KGC(String algorithm, ProviderConfiguration configuration) {
            super(algorithm);
            this.algorithm = algorithm;
            this.configuration = configuration;
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
            this.param = new KeyGenerationParameters(random, strength);
            this.engine.init(this.param);
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.initialize(this.strength, new SecureRandom());
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            SM9PublicKeyParameters pub = (SM9PublicKeyParameters)pair.getPublic();
            SM9PrivateKeyParameters priv = (SM9PrivateKeyParameters)pair.getPrivate();
            SM9MasterPublicKey pubKey = new SM9MasterPublicKey(this.algorithm, pub, this.configuration);
            return new KeyPair(pubKey, new SM9MasterPrivateKey(this.algorithm, priv, pubKey, this.configuration));
        }
    }
}

