/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider.asymmetric.sm9;

import cn.com.infosec.asn1.ASN1Primitive;
import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.gm.GMObjectIdentifiers;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.SM9KeyParameters;
import cn.com.infosec.jcajce.provider.asymmetric.util.KeyUtil;
import cn.com.infosec.jcajce.provider.config.ProviderConfiguration;
import cn.com.infosec.jce.provider.INFOSECProvider;
import cn.com.infosec.jce.spec.SM9PublicKeySpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public class SM9MasterPublicKey
implements PublicKey {
    static final long serialVersionUID = 2422789860422731812L;
    private String algorithm = "SM9";
    private boolean withCompression;
    private transient byte[] q;
    private transient ProviderConfiguration configuration;

    public SM9MasterPublicKey(String algorithm, SM9MasterPublicKey key) {
        this.algorithm = algorithm;
        this.q = key.q;
        this.configuration = key.configuration;
    }

    public SM9MasterPublicKey(String algorithm, SM9KeyParameters pub, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.q = pub.getParameters();
        this.configuration = configuration;
    }

    SM9MasterPublicKey(String algorithm, SubjectPublicKeyInfo info, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.configuration = configuration;
        this.populateFromPubKeyInfo(info);
    }

    public SM9MasterPublicKey(String algorithm, SM9PublicKeySpec keySpec, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.q = keySpec.getQ();
        this.configuration = configuration;
    }

    private ECParameterSpec createSpec(EllipticCurve ellipticCurve, ECDomainParameters dp) {
        return new ECParameterSpec(ellipticCurve, new ECPoint(dp.getG().getAffineXCoord().toBigInteger(), dp.getG().getAffineYCoord().toBigInteger()), dp.getN(), dp.getH().intValue());
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo info) {
        DERBitString bits = info.getPublicKeyData();
        byte[] data = bits.getBytes();
        this.q = data;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(GMObjectIdentifiers.id_sm9PublicKey), this.q);
        return KeyUtil.getEncodedSubjectPublicKeyInfo(info);
    }

    private void extractBytes(byte[] encKey, int offSet, BigInteger bI) {
        byte[] val = bI.toByteArray();
        if (val.length < 32) {
            byte[] tmp = new byte[32];
            System.arraycopy(val, 0, tmp, tmp.length - val.length, val.length);
            val = tmp;
        }
        for (int i = 0; i != 32; ++i) {
            encKey[offSet + i] = val[val.length - 1 - i];
        }
    }

    public byte[] getQ() {
        return this.q;
    }

    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(enc)));
        this.configuration = INFOSECProvider.CONFIGURATION;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

