/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider.symmetric;

import cn.com.infosec.crypto.CipherKeyGenerator;
import cn.com.infosec.crypto.CryptoServicesRegistrar;
import cn.com.infosec.crypto.engines.SM4Engine;
import cn.com.infosec.crypto.generators.Poly1305KeyGenerator;
import cn.com.infosec.crypto.macs.CMac;
import cn.com.infosec.crypto.macs.GMac;
import cn.com.infosec.crypto.modes.GCMBlockCipher;
import cn.com.infosec.crypto.modes.IPPCCMBlockCipher;
import cn.com.infosec.ipp.provider.symmetric.SymmetricAlgorithmProvider;
import cn.com.infosec.jcajce.provider.config.ConfigurableProvider;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseMac;
import cn.com.infosec.jcajce.provider.symmetric.util.IPPBlockCipher;
import cn.com.infosec.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class SM4 {
    private SM4() {
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = SM4.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.SM4", PREFIX + "$AlgParams");
            provider.addAlgorithm("AlgorithmParameterGenerator.SM4", PREFIX + "$AlgParamGen");
            provider.addAlgorithm("Cipher.SM4", PREFIX + "$ECB");
            provider.addAlgorithm("Cipher.SM4/ECB", PREFIX + "$ECB");
            provider.addAlgorithm("Cipher.SM4/CBC", PREFIX + "$CBC");
            provider.addAlgorithm("Cipher.SM4/CCM", PREFIX + "$CCM");
            provider.addAlgorithm("Alg.Alias.Cipher.1.2.156.10197.1.104", "SM4");
            provider.addAlgorithm("KeyGenerator.SM4", PREFIX + "$KeyGen");
            this.addCMacAlgorithm(provider, "SM4", PREFIX + "$CMAC", PREFIX + "$KeyGen");
            this.addGMacAlgorithm(provider, "SM4", PREFIX + "$GMAC", PREFIX + "$KeyGen");
            this.addPoly1305Algorithm(provider, "SM4", PREFIX + "$Poly1305", PREFIX + "$Poly1305KeyGen");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "SM4 IV";
        }
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for SM4 parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = this.createParametersInstance("SM4");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-SM4", 256, new Poly1305KeyGenerator());
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new cn.com.infosec.crypto.macs.Poly1305(new SM4Engine()));
        }
    }

    public static class CCM
    extends IPPCCMBlockCipher {
        public CCM() {
            super("SM4", 16);
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new SM4Engine())));
        }
    }

    public static class CMAC
    extends BaseMac {
        public CMAC() {
            super(new CMac(new SM4Engine()));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("SM4", 128, new CipherKeyGenerator());
        }
    }

    public static class CBC
    extends IPPBlockCipher {
        public CBC() {
            super("SM4", 16, "PKCS5Padding", "CBC");
        }
    }

    public static class ECB
    extends IPPBlockCipher {
        public ECB() {
            super("SM4", 16);
        }
    }
}

