/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.asymmetric;

import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.x9.X9ObjectIdentifiers;
import cn.com.infosec.jcajce.provider.asymmetric.dh.KeyFactorySpi;
import cn.com.infosec.jcajce.provider.config.ConfigurableProvider;
import cn.com.infosec.jcajce.provider.util.AsymmetricAlgorithmProvider;
import java.util.HashMap;
import java.util.Map;

public class DH {
    private static final String PREFIX = "cn.com.infosec.jcajce.provider.asymmetric.dh.";
    private static final Map<String, String> generalDhAttributes = new HashMap<String, String>();

    static {
        generalDhAttributes.put("SupportedKeyClasses", "javax.crypto.interfaces.DHPublicKey|javax.crypto.interfaces.DHPrivateKey");
        generalDhAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("KeyPairGenerator.DH", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyPairGeneratorSpi");
            provider.addAlgorithm("Alg.Alias.KeyPairGenerator.DIFFIEHELLMAN", "DH");
            provider.addAttributes("KeyAgreement.DH", generalDhAttributes);
            provider.addAlgorithm("KeyAgreement.DH", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi");
            provider.addAlgorithm("Alg.Alias.KeyAgreement.DIFFIEHELLMAN", "DH");
            provider.addAlgorithm("KeyAgreement", PKCSObjectIdentifiers.id_alg_ESDH, "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHwithRFC2631KDF");
            provider.addAlgorithm("KeyAgreement", PKCSObjectIdentifiers.id_alg_SSDH, "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHwithRFC2631KDF");
            provider.addAlgorithm("KeyFactory.DH", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyFactorySpi");
            provider.addAlgorithm("Alg.Alias.KeyFactory.DIFFIEHELLMAN", "DH");
            provider.addAlgorithm("AlgorithmParameters.DH", "cn.com.infosec.jcajce.provider.asymmetric.dh.AlgorithmParametersSpi");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters.DIFFIEHELLMAN", "DH");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator.DIFFIEHELLMAN", "DH");
            provider.addAlgorithm("AlgorithmParameterGenerator.DH", "cn.com.infosec.jcajce.provider.asymmetric.dh.AlgorithmParameterGeneratorSpi");
            provider.addAlgorithm("Cipher.IES", "cn.com.infosec.jcajce.provider.asymmetric.dh.IESCipher$IES");
            provider.addAlgorithm("Cipher.IESwithAES-CBC", "cn.com.infosec.jcajce.provider.asymmetric.dh.IESCipher$IESwithAESCBC");
            provider.addAlgorithm("Cipher.IESWITHAES-CBC", "cn.com.infosec.jcajce.provider.asymmetric.dh.IESCipher$IESwithAESCBC");
            provider.addAlgorithm("Cipher.IESWITHDESEDE-CBC", "cn.com.infosec.jcajce.provider.asymmetric.dh.IESCipher$IESwithDESedeCBC");
            provider.addAlgorithm("Cipher.DHIES", "cn.com.infosec.jcajce.provider.asymmetric.dh.IESCipher$IES");
            provider.addAlgorithm("Cipher.DHIESwithAES-CBC", "cn.com.infosec.jcajce.provider.asymmetric.dh.IESCipher$IESwithAESCBC");
            provider.addAlgorithm("Cipher.DHIESWITHAES-CBC", "cn.com.infosec.jcajce.provider.asymmetric.dh.IESCipher$IESwithAESCBC");
            provider.addAlgorithm("Cipher.DHIESWITHDESEDE-CBC", "cn.com.infosec.jcajce.provider.asymmetric.dh.IESCipher$IESwithDESedeCBC");
            provider.addAlgorithm("KeyAgreement.DHWITHSHA1KDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHwithSHA1KDF");
            provider.addAlgorithm("KeyAgreement.DHWITHSHA224KDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHwithSHA224KDF");
            provider.addAlgorithm("KeyAgreement.DHWITHSHA256KDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHwithSHA256KDF");
            provider.addAlgorithm("KeyAgreement.DHWITHSHA384KDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHwithSHA384KDF");
            provider.addAlgorithm("KeyAgreement.DHWITHSHA512KDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHwithSHA512KDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA1KDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA1KDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA224KDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA224KDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA256KDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA256KDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA384KDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA384KDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA512KDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA512KDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA1CKDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA1CKDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA224CKDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA224CKDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA256CKDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA256CKDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA384CKDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA384CKDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA512CKDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA512CKDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA1KDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA1KDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA224KDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA224KDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA256KDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA256KDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA384KDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA384KDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA512KDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA512KDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA1CKDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA1CKDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA224CKDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA224CKDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA256CKDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA256CKDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA384CKDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA384CKDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA512CKDF", "cn.com.infosec.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA512CKDF");
            this.registerOid(provider, PKCSObjectIdentifiers.dhKeyAgreement, "DH", new KeyFactorySpi());
            this.registerOid(provider, X9ObjectIdentifiers.dhpublicnumber, "DH", new KeyFactorySpi());
        }
    }
}

