/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.asymmetric.edec;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1ObjectIdentifier;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.edec.EdECObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.PrivateKeyInfo;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.params.Ed25519PrivateKeyParameters;
import cn.com.infosec.crypto.params.Ed25519PublicKeyParameters;
import cn.com.infosec.crypto.util.OpenSSHPrivateKeyUtil;
import cn.com.infosec.crypto.util.OpenSSHPublicKeyUtil;
import cn.com.infosec.jcajce.provider.asymmetric.edec.INFOSECEdDSAPrivateKey;
import cn.com.infosec.jcajce.provider.asymmetric.edec.INFOSECEdDSAPublicKey;
import cn.com.infosec.jcajce.provider.asymmetric.edec.INFOSECXDHPrivateKey;
import cn.com.infosec.jcajce.provider.asymmetric.edec.INFOSECXDHPublicKey;
import cn.com.infosec.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import cn.com.infosec.jcajce.provider.util.AsymmetricKeyInfoConverter;
import cn.com.infosec.jce.spec.OpenSSHPrivateKeySpec;
import cn.com.infosec.jce.spec.OpenSSHPublicKeySpec;
import cn.com.infosec.util.encoders.Hex;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;

public class KeyFactorySpi
extends BaseKeyFactorySpi
implements AsymmetricKeyInfoConverter {
    static final byte[] x448Prefix = Hex.decode("3042300506032b656f033900");
    static final byte[] x25519Prefix = Hex.decode("302a300506032b656e032100");
    static final byte[] Ed448Prefix = Hex.decode("3043300506032b6571033a00");
    static final byte[] Ed25519Prefix = Hex.decode("302a300506032b6570032100");
    private static final byte x448_type = 111;
    private static final byte x25519_type = 110;
    private static final byte Ed448_type = 113;
    private static final byte Ed25519_type = 112;
    String algorithm;
    private final boolean isXdh;
    private final int specificBase;

    public KeyFactorySpi(String algorithm, boolean isXdh, int specificBase) {
        this.algorithm = algorithm;
        this.isXdh = isXdh;
        this.specificBase = specificBase;
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("key type unknown");
    }

    @Override
    protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
        if (spec.isAssignableFrom(OpenSSHPrivateKeySpec.class) && key instanceof INFOSECEdDSAPrivateKey) {
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance(key.getEncoded());
                DEROctetString val = (DEROctetString)seq.getObjectAt(2);
                ASN1InputStream in = new ASN1InputStream(val.getOctets());
                return new OpenSSHPrivateKeySpec(OpenSSHPrivateKeyUtil.encodePrivateKey(new Ed25519PrivateKeyParameters(((DEROctetString)in.readObject()).getOctets(), 0)));
            }
            catch (IOException ex) {
                throw new InvalidKeySpecException(ex.getMessage(), ex.getCause());
            }
        }
        if (spec.isAssignableFrom(OpenSSHPublicKeySpec.class) && key instanceof INFOSECEdDSAPublicKey) {
            try {
                return new OpenSSHPublicKeySpec(OpenSSHPublicKeyUtil.encodePublicKey(new Ed25519PublicKeyParameters(key.getEncoded(), Ed25519Prefix.length)));
            }
            catch (IOException ex) {
                throw new InvalidKeySpecException(ex.getMessage(), ex.getCause());
            }
        }
        return super.engineGetKeySpec(key, spec);
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof OpenSSHPrivateKeySpec) {
            AsymmetricKeyParameter parameters = OpenSSHPrivateKeyUtil.parsePrivateKeyBlob(((OpenSSHPrivateKeySpec)keySpec).getEncoded());
            if (parameters instanceof Ed25519PrivateKeyParameters) {
                return new INFOSECEdDSAPrivateKey((Ed25519PrivateKeyParameters)parameters);
            }
            throw new IllegalStateException("openssh private key not Ed25519 private key");
        }
        return super.engineGeneratePrivate(keySpec);
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            byte[] enc = ((X509EncodedKeySpec)keySpec).getEncoded();
            if (this.specificBase == 0 || this.specificBase == enc[8]) {
                switch (enc[8]) {
                    case 111: {
                        return new INFOSECXDHPublicKey(x448Prefix, enc);
                    }
                    case 110: {
                        return new INFOSECXDHPublicKey(x25519Prefix, enc);
                    }
                    case 113: {
                        return new INFOSECEdDSAPublicKey(Ed448Prefix, enc);
                    }
                    case 112: {
                        return new INFOSECEdDSAPublicKey(Ed25519Prefix, enc);
                    }
                }
                return super.engineGeneratePublic(keySpec);
            }
        } else if (keySpec instanceof OpenSSHPublicKeySpec) {
            AsymmetricKeyParameter parameters = OpenSSHPublicKeyUtil.parsePublicKey(((OpenSSHPublicKeySpec)keySpec).getEncoded());
            if (parameters instanceof Ed25519PublicKeyParameters) {
                return new INFOSECEdDSAPublicKey(new byte[0], ((Ed25519PublicKeyParameters)parameters).getEncoded());
            }
            throw new IllegalStateException("openssh public key not Ed25519 public key");
        }
        return super.engineGeneratePublic(keySpec);
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (this.isXdh) {
            if ((this.specificBase == 0 || this.specificBase == 111) && algOid.equals(EdECObjectIdentifiers.id_X448)) {
                return new INFOSECXDHPrivateKey(keyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 110) && algOid.equals(EdECObjectIdentifiers.id_X25519)) {
                return new INFOSECXDHPrivateKey(keyInfo);
            }
        } else if (algOid.equals(EdECObjectIdentifiers.id_Ed448) || algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
            if ((this.specificBase == 0 || this.specificBase == 113) && algOid.equals(EdECObjectIdentifiers.id_Ed448)) {
                return new INFOSECEdDSAPrivateKey(keyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 112) && algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
                return new INFOSECEdDSAPrivateKey(keyInfo);
            }
        }
        throw new IOException("algorithm identifier " + algOid + " in key not recognized");
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getAlgorithm().getAlgorithm();
        if (this.isXdh) {
            if ((this.specificBase == 0 || this.specificBase == 111) && algOid.equals(EdECObjectIdentifiers.id_X448)) {
                return new INFOSECXDHPublicKey(keyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 110) && algOid.equals(EdECObjectIdentifiers.id_X25519)) {
                return new INFOSECXDHPublicKey(keyInfo);
            }
        } else if (algOid.equals(EdECObjectIdentifiers.id_Ed448) || algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
            if ((this.specificBase == 0 || this.specificBase == 113) && algOid.equals(EdECObjectIdentifiers.id_Ed448)) {
                return new INFOSECEdDSAPublicKey(keyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 112) && algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
                return new INFOSECEdDSAPublicKey(keyInfo);
            }
        }
        throw new IOException("algorithm identifier " + algOid + " in key not recognized");
    }

    public static class ED25519
    extends KeyFactorySpi {
        public ED25519() {
            super("Ed25519", false, 112);
        }
    }

    public static class ED448
    extends KeyFactorySpi {
        public ED448() {
            super("Ed448", false, 113);
        }
    }

    public static class EDDSA
    extends KeyFactorySpi {
        public EDDSA() {
            super("EdDSA", false, 0);
        }
    }

    public static class X25519
    extends KeyFactorySpi {
        public X25519() {
            super("X25519", true, 110);
        }
    }

    public static class X448
    extends KeyFactorySpi {
        public X448() {
            super("X448", true, 111);
        }
    }

    public static class XDH
    extends KeyFactorySpi {
        public XDH() {
            super("XDH", true, 0);
        }
    }
}

