/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.asymmetric.sm2;

import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Integer;
import cn.com.infosec.asn1.ASN1Primitive;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.x9.X962NamedCurves;
import cn.com.infosec.asn1.x9.X9ECParameters;
import cn.com.infosec.crypto.DSAExt;
import cn.com.infosec.crypto.Digest;
import cn.com.infosec.crypto.digests.SM3Digest;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.crypto.signers.DSAEncoding;
import cn.com.infosec.crypto.signers.INFOSECSM2Signer;
import cn.com.infosec.crypto.signers.StandardDSAEncoding;
import cn.com.infosec.jcajce.provider.asymmetric.util.DSABase;
import cn.com.infosec.jcajce.provider.asymmetric.util.DSAEncoder;
import cn.com.infosec.jcajce.provider.asymmetric.util.ECUtil;
import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.math.ec.ECPoint;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;

public class SignatureSpi
extends DSABase {
    boolean inited = false;
    byte[] paddPrefix = new byte[0];
    static X9ECParameters param1 = X962NamedCurves.getByName("prime256v1_sm2");
    static ECCurve curve = param1.getCurve();
    static ECPoint G = param1.getG();
    static BigInteger n = param1.getN();

    SignatureSpi(Digest digest, DSAExt signer, DSAEncoding encoder) {
        super(digest, signer, encoder);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter param = ECUtil.generatePublicKeyParameter(publicKey);
        this.digest.reset();
        this.signer.init(false, param);
        ECPublicKeyParameters key = (ECPublicKeyParameters)param;
        ECPoint P = key.getQ();
        this.paddPrefix = SignatureSpi.genSM2Prefix(P);
        this.inited = false;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        ECPrivateKeyParameters key;
        AsymmetricKeyParameter param = ECUtil.generatePrivateKeyParameter(privateKey);
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)((Object)param);
            key = (ECPrivateKeyParameters)rParam.getParameters();
        } else {
            key = (ECPrivateKeyParameters)param;
        }
        ECPoint P = G.multiply(key.getD()).normalize();
        this.paddPrefix = SignatureSpi.genSM2Prefix(P);
        this.digest.reset();
        if (this.appRandom != null) {
            this.signer.init(true, new ParametersWithRandom(param, this.appRandom));
        } else {
            this.signer.init(true, param);
        }
        this.inited = false;
    }

    private static void copyBytes2Buffer(byte[] bs, ByteArrayOutputStream buff, int len) {
        byte[] b = new byte[len];
        for (int i = 0; i < b.length; ++i) {
            b[i] = 0;
        }
        if (bs.length == len) {
            System.arraycopy(bs, 0, b, 0, len);
        }
        if (bs.length > len) {
            System.arraycopy(bs, bs.length - len, b, 0, len);
        } else if (bs.length < len) {
            System.arraycopy(bs, 0, b, len - bs.length, bs.length);
        }
        try {
            buff.write(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] sm3hash(byte[] d) {
        SM3Digest sm3 = new SM3Digest();
        sm3.update(d, 0, d.length);
        byte[] r = new byte[32];
        sm3.doFinal(r, 0);
        return r;
    }

    private static byte[] genSM2Prefix(ECPoint P) {
        byte[] ID = "1234567812345678".getBytes();
        X9ECParameters param = X962NamedCurves.getByName("prime256v1_sm2");
        ECCurve curve = param.getCurve();
        ECPoint G = param.getG();
        BigInteger n = param.getN();
        byte[] a = param.getCurve().getA().toBigInteger().toByteArray();
        byte[] b = param.getCurve().getB().toBigInteger().toByteArray();
        byte[] x = P.getAffineXCoord().toBigInteger().toByteArray();
        byte[] y = P.getAffineYCoord().toBigInteger().toByteArray();
        try {
            byte[] xg = G.getAffineXCoord().toBigInteger().toByteArray();
            byte[] yg = G.getAffineYCoord().toBigInteger().toByteArray();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(0);
            baos.write(128);
            baos.write(ID);
            SignatureSpi.copyBytes2Buffer(a, baos, 32);
            SignatureSpi.copyBytes2Buffer(b, baos, 32);
            SignatureSpi.copyBytes2Buffer(xg, baos, 32);
            SignatureSpi.copyBytes2Buffer(yg, baos, 32);
            SignatureSpi.copyBytes2Buffer(x, baos, 32);
            SignatureSpi.copyBytes2Buffer(y, baos, 32);
            byte[] M = baos.toByteArray();
            byte[] h1 = SignatureSpi.sm3hash(M);
            return h1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class CVCDSAEncoder
    implements DSAEncoder {
        private CVCDSAEncoder() {
        }

        @Override
        public byte[] encode(BigInteger r, BigInteger s) throws IOException {
            byte[] second;
            byte[] first = this.makeUnsigned(r);
            byte[] res = first.length > (second = this.makeUnsigned(s)).length ? new byte[first.length * 2] : new byte[second.length * 2];
            System.arraycopy(first, 0, res, res.length / 2 - first.length, first.length);
            System.arraycopy(second, 0, res, res.length - second.length, second.length);
            return res;
        }

        private byte[] makeUnsigned(BigInteger val) {
            byte[] res = val.toByteArray();
            if (res[0] == 0) {
                byte[] tmp = new byte[res.length - 1];
                System.arraycopy(res, 1, tmp, 0, tmp.length);
                return tmp;
            }
            return res;
        }

        @Override
        public BigInteger[] decode(byte[] encoding) throws IOException {
            BigInteger[] sig = new BigInteger[2];
            byte[] first = new byte[encoding.length / 2];
            byte[] second = new byte[encoding.length / 2];
            System.arraycopy(encoding, 0, first, 0, first.length);
            System.arraycopy(encoding, first.length, second, 0, second.length);
            sig[0] = new BigInteger(1, first);
            sig[1] = new BigInteger(1, second);
            return sig;
        }
    }

    private static class StdDSAEncoder
    implements DSAEncoder {
        private StdDSAEncoder() {
        }

        @Override
        public byte[] encode(BigInteger r, BigInteger s) throws IOException {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new ASN1Integer(r));
            v.add(new ASN1Integer(s));
            return new DERSequence(v).getEncoded("DER");
        }

        @Override
        public BigInteger[] decode(byte[] encoding) throws IOException {
            ASN1Sequence s = (ASN1Sequence)ASN1Primitive.fromByteArray(encoding);
            BigInteger[] sig = new BigInteger[]{ASN1Integer.getInstance(s.getObjectAt(0)).getValue(), ASN1Integer.getInstance(s.getObjectAt(1)).getValue()};
            return sig;
        }
    }

    public static class SM2
    extends SignatureSpi {
        public SM2() {
            super(new SM3Digest(), new INFOSECSM2Signer(), StandardDSAEncoding.INSTANCE);
            this.inited = false;
        }

        @Override
        protected void engineUpdate(byte b) throws SignatureException {
            byte[] tbhash = new byte[]{b};
            if (!this.inited) {
                tbhash = new byte[1 + this.paddPrefix.length];
                System.arraycopy(this.paddPrefix, 0, tbhash, 0, this.paddPrefix.length);
                tbhash[this.paddPrefix.length] = b;
                super.engineUpdate(tbhash, 0, 1 + this.paddPrefix.length);
                this.inited = true;
            } else {
                super.engineUpdate(b);
            }
        }

        @Override
        protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
            byte[] tbhash = b;
            if (!this.inited) {
                tbhash = new byte[len + this.paddPrefix.length];
                System.arraycopy(this.paddPrefix, 0, tbhash, 0, this.paddPrefix.length);
                System.arraycopy(b, off, tbhash, this.paddPrefix.length, len);
                super.engineUpdate(tbhash, 0, len + this.paddPrefix.length);
                this.inited = true;
            } else {
                super.engineUpdate(b, off, len);
            }
        }
    }
}

