/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.keystore.ckx;

import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.jcajce.provider.asymmetric.util.ECUtil;
import cn.com.infosec.util.Arrays;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class CkxUtil {
    public CkxUtil() throws IllegalAccessException {
        throw new IllegalAccessException("util class");
    }

    public static boolean keyMatch(PrivateKey privateKey, PublicKey publicKey) {
        if (privateKey instanceof ECPrivateKey && publicKey instanceof ECPublicKey) {
            try {
                ECPrivateKeyParameters priParams = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter(privateKey);
                byte[] point = priParams.getParameters().getG().multiply(priParams.getD()).getEncoded(false);
                ECPublicKeyParameters pubParams = (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter(publicKey);
                return Arrays.areEqual(point, pubParams.getQ().getEncoded(false));
            }
            catch (InvalidKeyException e) {
                e.printStackTrace();
            }
        }
        if (privateKey instanceof RSAPrivateKey && publicKey instanceof RSAPublicKey) {
            BigInteger privateModulus = ((RSAKey)((Object)privateKey)).getModulus();
            BigInteger publicModulus = ((RSAKey)((Object)publicKey)).getModulus();
            return privateModulus.equals(publicModulus);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCkxKeyStore(BufferedInputStream inputStream) throws IOException {
        try {
            inputStream.mark(2);
            byte[] bytes = new byte[2];
            inputStream.read(bytes, 0, 2);
            inputStream.reset();
            int two = bytes[1] & 0xFF;
            int realLen = two % 8;
            int readlimit = realLen + 2 + 3;
            inputStream.mark(readlimit);
            byte[] byte2 = new byte[readlimit];
            inputStream.read(byte2, 0, byte2.length);
            boolean bl = byte2[byte2.length - 1] == 1;
            return bl;
        }
        finally {
            inputStream.reset();
        }
    }
}

