/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.keystore.ckx;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.gm.GMObjectIdentifiers;
import cn.com.infosec.asn1.gm.Q5PBESParameters;
import cn.com.infosec.asn1.gm.Q5PBKDFParams;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.jcajce.spec.PBKDF2KeySpec;
import cn.com.infosec.jcajce.util.DefaultJcaJceHelper;
import cn.com.infosec.jcajce.util.JcaJceHelper;
import cn.com.infosec.jcajce.util.NamedJcaJceHelper;
import cn.com.infosec.jcajce.util.ProviderJcaJceHelper;
import cn.com.infosec.operator.GenericKey;
import cn.com.infosec.operator.OutputEncryptor;
import cn.com.infosec.operator.jcajce.JceGenericKey;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;

public class GMPKCS8EncryptorBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private char[] password;
    private final AlgorithmIdentifier algId;

    public GMPKCS8EncryptorBuilder(AlgorithmIdentifier algId) {
        this.algId = algId;
    }

    public GMPKCS8EncryptorBuilder setPassword(char[] password) {
        this.password = password;
        return this;
    }

    public GMPKCS8EncryptorBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public GMPKCS8EncryptorBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public OutputEncryptor build() throws Exception {
        Q5PBESParameters alg = Q5PBESParameters.getInstance(this.algId.getParameters());
        Q5PBKDFParams func = Q5PBKDFParams.getInstance(alg.getKeyDerivationFunc().getParameters());
        AlgorithmIdentifier encScheme = AlgorithmIdentifier.getInstance(alg.getEncryptionScheme());
        try {
            SecretKeyFactory keyFact = this.helper.createSecretKeyFactory(alg.getKeyDerivationFunc().getAlgorithm().getId());
            if (!GMObjectIdentifiers.sms4_cbc.getId().equals(encScheme.getAlgorithm().getId())) {
                throw new IllegalArgumentException("we need sm4-cbc here, input: " + encScheme.getAlgorithm());
            }
            int sm4KeySize = 128;
            final SecretKey key = keyFact.generateSecret(new PBKDF2KeySpec(this.password, func.getSalt(), func.getIterationCount().intValue(), sm4KeySize, func.getPrf()));
            final Cipher cipher = Cipher.getInstance(alg.getEncryptionScheme().getAlgorithm().getId());
            ASN1Encodable encParams = alg.getEncryptionScheme().getParameters();
            cipher.init(1, (Key)key, new IvParameterSpec(ASN1OctetString.getInstance(encParams).getOctets()));
            return new OutputEncryptor(){

                @Override
                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return GMPKCS8EncryptorBuilder.this.algId;
                }

                @Override
                public OutputStream getOutputStream(OutputStream encOut) {
                    return new CipherOutputStream(encOut, cipher);
                }

                @Override
                public GenericKey getKey() {
                    return new JceGenericKey(GMPKCS8EncryptorBuilder.this.algId, key);
                }
            };
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return null;
    }
}

