/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.symmetric;

import cn.com.infosec.asn1.ASN1Primitive;
import cn.com.infosec.asn1.gm.GMObjectIdentifiers;
import cn.com.infosec.asn1.gm.Q5PBKDFParams;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.jcajce.provider.config.ConfigurableProvider;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import cn.com.infosec.jcajce.provider.symmetric.util.INFOSECPBEKey;
import cn.com.infosec.jcajce.provider.symmetric.util.PBE;
import cn.com.infosec.jcajce.provider.util.AlgorithmProvider;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class Q5PBKDF {
    private Q5PBKDF() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Q5PBKDF.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.GMPBKDF", PREFIX + "$AlgParams");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters." + GMObjectIdentifiers.id_PBKDF, "GMPBKDF");
            provider.addAlgorithm("Alg.Alias.SecretKeyFactory." + GMObjectIdentifiers.id_PBKDF, "GMPBKDF");
            provider.addAlgorithm("SecretKeyFactory.GMPBKDF", PREFIX + "$GMPBKDF");
        }
    }

    public static class GMPBKDF
    extends BasePBKDF {
        public GMPBKDF() {
            super("GMPBKDF", 5);
        }
    }

    public static class BasePBKDF
    extends BaseSecretKeyFactory {
        private int scheme;

        public BasePBKDF(String name, int scheme) {
            super(name, GMObjectIdentifiers.id_PBKDF);
            this.scheme = scheme;
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pbeSpec = (PBEKeySpec)keySpec;
                if (pbeSpec.getSalt() == null) {
                    throw new InvalidKeySpecException("salt empty");
                }
                if (pbeSpec.getIterationCount() <= 0) {
                    throw new InvalidKeySpecException("positive iteration count required: " + pbeSpec.getIterationCount());
                }
                if (pbeSpec.getKeyLength() <= 0) {
                    throw new InvalidKeySpecException("positive key length required: " + pbeSpec.getKeyLength());
                }
                if (pbeSpec.getPassword().length == 0) {
                    throw new IllegalArgumentException("password empty");
                }
                int keySize = pbeSpec.getKeyLength();
                int ivSize = -1;
                CipherParameters param = PBE.Util.makePBEMacParameters(pbeSpec, this.scheme, 14, keySize);
                return new INFOSECPBEKey(this.algName, this.algOid, this.scheme, 14, keySize, ivSize, pbeSpec, param);
            }
            throw new InvalidKeySpecException("Invalid KeySpec");
        }
    }

    public static class AlgParams
    extends BaseAlgorithmParameters {
        Q5PBKDFParams params;

        @Override
        protected byte[] engineGetEncoded() {
            try {
                return this.params.getEncoded("DER");
            }
            catch (IOException e) {
                throw new RuntimeException("Oooops! " + e.toString());
            }
        }

        @Override
        protected byte[] engineGetEncoded(String format) {
            if (this.isASN1FormatString(format)) {
                return this.engineGetEncoded();
            }
            return null;
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == PBEParameterSpec.class) {
                return new PBEParameterSpec(this.params.getSalt(), this.params.getIterationCount().intValue());
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to GMPBKDF PBE parameters object.");
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof PBEParameterSpec)) {
                throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a GMPBKDF PBE parameters algorithm parameters object");
            }
            PBEParameterSpec pbeSpec = (PBEParameterSpec)paramSpec;
            this.params = new Q5PBKDFParams(pbeSpec.getSalt(), pbeSpec.getIterationCount());
        }

        @Override
        protected void engineInit(byte[] params) throws IOException {
            this.params = Q5PBKDFParams.getInstance(ASN1Primitive.fromByteArray(params));
        }

        @Override
        protected void engineInit(byte[] params, String format) throws IOException {
            if (this.isASN1FormatString(format)) {
                this.engineInit(params);
                return;
            }
            throw new IOException("Unknown parameters format in GMPBKDF parameters object");
        }

        @Override
        protected String engineToString() {
            return "GMPBKDF Parameters";
        }
    }
}

