/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.symmetric.util;

import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.device.SDSFactory;
import cn.com.infosec.device.crypto.ISDSCrypto;
import cn.com.infosec.util.Arrays;
import cn.com.infosec.util.Strings;
import cn.com.infosec.util.encoders.Hex;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public class IPPBlockCipher
extends CipherSpi {
    private int blockSize;
    private int ivBlockSize;
    private byte[] key = null;
    private String padd = "NoPadding";
    private String mode = "ECB";
    private int opmode;
    private byte[] iv = null;
    private byte[] ivRemain = null;
    private AlgorithmParameters ivParameters = null;
    ByteArrayOutputStream buf = new ByteArrayOutputStream();

    public IPPBlockCipher(String algName, int blockSize) {
        this.blockSize = blockSize;
        this.ivBlockSize = blockSize;
        this.iv = new byte[blockSize];
    }

    public IPPBlockCipher(String algName, int blockSize, String padd, String mode) {
        this(algName, blockSize);
        this.padd = padd;
        this.mode = mode;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] buf = new byte[this.engineGetOutputSize(inputLen)];
        try {
            int len = this.engineDoFinal(input, inputOffset, inputLen, buf, 0);
            byte[] out = new byte[len];
            System.arraycopy(buf, 0, out, 0, len);
            return out;
        }
        catch (ShortBufferException e) {
            return null;
        }
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (input != null) {
            this.buf.write(input, inputOffset, inputLen);
        }
        if (this.buf.size() == 0) {
            throw new BadPaddingException("the input data size is 0");
        }
        byte[] out = this.process();
        System.arraycopy(out, 0, output, outputOffset, out.length);
        if (this.iv.length > 0) {
            System.arraycopy(this.ivRemain, 0, this.iv, 0, this.iv.length);
        }
        return out.length;
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    @Override
    protected byte[] engineGetIV() {
        return this.iv;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        if (this.opmode == 1) {
            if (this.padd.equalsIgnoreCase("NoPadding")) {
                return this.buf.size() + inputLen;
            }
            return ((this.buf.size() + inputLen) / this.blockSize + 1) * this.blockSize;
        }
        if (this.opmode == 2) {
            if (this.padd.equalsIgnoreCase("NoPadding")) {
                return this.buf.size() + inputLen;
            }
            return this.buf.size() + inputLen;
        }
        return this.buf.size() + inputLen + this.blockSize;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return this.ivParameters;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return key.getEncoded().length << 3;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameters)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null && params instanceof IvParameterSpec) {
            this.iv = ((IvParameterSpec)params).getIV();
        } else {
            Arrays.fill(this.iv, (byte)0);
        }
        if (this.iv.length != this.ivBlockSize) {
            throw new InvalidAlgorithmParameterException("IV size is not blockSize");
        }
        if (this.iv.length > 0) {
            this.ivRemain = new byte[this.iv.length];
            System.arraycopy(this.iv, 0, this.ivRemain, 0, this.iv.length);
        }
        this.buf.reset();
        if (key.getEncoded().length % 16 != 0) {
            throw new InvalidKeyException("key size invalid; key: " + new String(Hex.encode(key.getEncoded())));
        }
        this.key = key.getEncoded();
        if (opmode != 1 && opmode != 2) {
            throw new InvalidParameterException("unknown opmode " + opmode + " passed");
        }
        this.opmode = opmode;
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec spec = null;
        if (params != null) {
            try {
                spec = params.getParameterSpec(IvParameterSpec.class);
                this.ivParameters = params;
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameters get IvParameterSpec error:" + e.getMessage());
            }
        }
        this.engineInit(opmode, key, spec, random);
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        String modeName = Strings.toUpperCase(mode);
        if (modeName.equalsIgnoreCase("ECB")) {
            this.mode = "ECB";
        } else if (modeName.equalsIgnoreCase("CBC")) {
            this.mode = "CBC";
        } else {
            throw new NoSuchAlgorithmException("can't support mode " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        String paddingName = Strings.toUpperCase(padding);
        if (paddingName.equalsIgnoreCase("NOPADDING")) {
            this.padd = "NoPadding";
        } else if (paddingName.equalsIgnoreCase("PKCS5PADDING")) {
            this.padd = "PKCS5Padding";
        } else if (paddingName.equalsIgnoreCase("PKCS7PADDING")) {
            this.padd = "PKCS7Padding";
        } else {
            throw new NoSuchPaddingException("Padding " + padding + " unknown.");
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.buf.write(input, inputOffset, inputLen);
        return this.buf.toByteArray();
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        this.buf.write(input, inputOffset, inputLen);
        System.arraycopy(this.buf.toByteArray(), 0, output, outputOffset, this.buf.size());
        return this.buf.size();
    }

    private byte[] process() throws BadPaddingException, IllegalBlockSizeException {
        byte[] input = this.buf.toByteArray();
        this.buf.reset();
        ISDSCrypto crypto = null;
        try {
            crypto = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        if (this.padd.equalsIgnoreCase("NoPadding") && input.length % 16 != 0) {
            throw new IllegalBlockSizeException("input size Illegal; input: " + new String(Hex.encode(input)));
        }
        byte[] out = null;
        if (this.opmode == 1) {
            try {
                out = crypto.encrypt(this.mode, this.padd, this.key, this.iv, null, 0, 0, input);
            }
            catch (Exception ex) {
                throw new RuntimeCryptoException(ex.getMessage());
            }
        }
        if (this.opmode == 2) {
            try {
                out = crypto.decrypt(this.mode, this.padd, this.key, this.iv, null, 0, 0, input);
            }
            catch (Exception ex) {
                throw new RuntimeCryptoException(ex.getMessage());
            }
        }
        return out;
    }

    public int getIvBlockSize() {
        return this.ivBlockSize;
    }

    public void setIvBlockSize(int ivBlockSize) {
        this.ivBlockSize = ivBlockSize;
    }
}

