/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.spec;

import cn.com.infosec.device.ipp.rsa.HashAlgType;
import java.security.spec.AlgorithmParameterSpec;

public class IPPPSSParameterSpec
implements AlgorithmParameterSpec {
    private HashAlgType digest = HashAlgType.SHA1;
    private int saltLen = 20;
    public static final IPPPSSParameterSpec DEFAULT = new IPPPSSParameterSpec();

    private IPPPSSParameterSpec() {
    }

    public IPPPSSParameterSpec(HashAlgType digest, int saltLen) {
        if (digest == null) {
            throw new NullPointerException("digest algorithm is null");
        }
        if (saltLen < 0) {
            throw new IllegalArgumentException("negative saltLen value: " + saltLen);
        }
        this.digest = digest;
        this.saltLen = saltLen;
    }

    public IPPPSSParameterSpec(int saltLen) {
        if (saltLen < 0) {
            throw new IllegalArgumentException("negative saltLen value: " + saltLen);
        }
        this.saltLen = saltLen;
    }

    public int getSaltLength() {
        return this.saltLen;
    }

    public HashAlgType getDigest() {
        return this.digest;
    }
}

