/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.math.ec.endo;

import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.math.ec.ECPointMap;
import cn.com.infosec.math.ec.ScaleYNegateXPointMap;
import cn.com.infosec.math.ec.endo.EndoUtil;
import cn.com.infosec.math.ec.endo.GLVEndomorphism;
import cn.com.infosec.math.ec.endo.GLVTypeAParameters;
import java.math.BigInteger;

public class GLVTypeAEndomorphism
implements GLVEndomorphism {
    protected final GLVTypeAParameters parameters;
    protected final ECPointMap pointMap;

    public GLVTypeAEndomorphism(ECCurve curve, GLVTypeAParameters parameters) {
        this.parameters = parameters;
        this.pointMap = new ScaleYNegateXPointMap(curve.fromBigInteger(parameters.getI()));
    }

    @Override
    public BigInteger[] decomposeScalar(BigInteger k) {
        return EndoUtil.decomposeScalar(this.parameters.getSplitParams(), k);
    }

    @Override
    public ECPointMap getPointMap() {
        return this.pointMap;
    }

    @Override
    public boolean hasEfficientPointMap() {
        return true;
    }
}

