/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.operator.infosec;

import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.crypto.CryptoException;
import cn.com.infosec.crypto.Signer;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.operator.ContentSigner;
import cn.com.infosec.operator.OperatorCreationException;
import cn.com.infosec.operator.RuntimeOperatorException;
import cn.com.infosec.operator.infosec.InfosecDefaultDigestProvider;
import cn.com.infosec.operator.infosec.InfosecDigestProvider;
import cn.com.infosec.operator.infosec.InfosecSignerOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public abstract class InfosecContentSignerBuilder {
    private SecureRandom random;
    private AlgorithmIdentifier sigAlgId;
    private AlgorithmIdentifier digAlgId;
    protected InfosecDigestProvider digestProvider;

    public InfosecContentSignerBuilder(AlgorithmIdentifier sigAlgId, AlgorithmIdentifier digAlgId) {
        this.sigAlgId = sigAlgId;
        this.digAlgId = digAlgId;
        this.digestProvider = InfosecDefaultDigestProvider.INSTANCE;
    }

    public InfosecContentSignerBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public ContentSigner build(AsymmetricKeyParameter privateKey) throws OperatorCreationException {
        final Signer sig = this.createSigner(this.sigAlgId, this.digAlgId);
        if (this.random != null) {
            sig.init(true, new ParametersWithRandom(privateKey, this.random));
        } else {
            sig.init(true, privateKey);
        }
        return new ContentSigner(){
            private InfosecSignerOutputStream stream;
            {
                this.stream = new InfosecSignerOutputStream(sig);
            }

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return InfosecContentSignerBuilder.this.sigAlgId;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.stream;
            }

            @Override
            public byte[] getSignature() {
                try {
                    return this.stream.getSignature();
                }
                catch (CryptoException e) {
                    throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
                }
            }
        };
    }

    protected abstract Signer createSigner(AlgorithmIdentifier var1, AlgorithmIdentifier var2) throws OperatorCreationException;
}

