/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.operator.infosec;

import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.cert.X509CertificateHolder;
import cn.com.infosec.crypto.Signer;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.operator.ContentVerifier;
import cn.com.infosec.operator.ContentVerifierProvider;
import cn.com.infosec.operator.OperatorCreationException;
import cn.com.infosec.operator.infosec.InfosecDefaultDigestProvider;
import cn.com.infosec.operator.infosec.InfosecDigestProvider;
import cn.com.infosec.operator.infosec.InfosecSignerOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class InfosecContentVerifierProviderBuilder {
    protected InfosecDigestProvider digestProvider = InfosecDefaultDigestProvider.INSTANCE;

    public ContentVerifierProvider build(final X509CertificateHolder certHolder) throws OperatorCreationException {
        return new ContentVerifierProvider(){

            @Override
            public boolean hasAssociatedCertificate() {
                return true;
            }

            @Override
            public X509CertificateHolder getAssociatedCertificate() {
                return certHolder;
            }

            @Override
            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                try {
                    AsymmetricKeyParameter publicKey = InfosecContentVerifierProviderBuilder.this.extractKeyParameters(certHolder.getSubjectPublicKeyInfo());
                    InfosecSignerOutputStream stream = InfosecContentVerifierProviderBuilder.this.createSignatureStream(algorithm, publicKey);
                    return new SigVerifier(algorithm, stream);
                }
                catch (IOException e) {
                    throw new OperatorCreationException("exception on setup: " + e, e);
                }
            }
        };
    }

    public ContentVerifierProvider build(final AsymmetricKeyParameter publicKey) throws OperatorCreationException {
        return new ContentVerifierProvider(){

            @Override
            public boolean hasAssociatedCertificate() {
                return false;
            }

            @Override
            public X509CertificateHolder getAssociatedCertificate() {
                return null;
            }

            @Override
            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                InfosecSignerOutputStream stream = InfosecContentVerifierProviderBuilder.this.createSignatureStream(algorithm, publicKey);
                return new SigVerifier(algorithm, stream);
            }
        };
    }

    private InfosecSignerOutputStream createSignatureStream(AlgorithmIdentifier algorithm, AsymmetricKeyParameter publicKey) throws OperatorCreationException {
        Signer sig = this.createSigner(algorithm);
        sig.init(false, publicKey);
        return new InfosecSignerOutputStream(sig);
    }

    protected abstract AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo var1) throws IOException;

    protected abstract Signer createSigner(AlgorithmIdentifier var1) throws OperatorCreationException;

    private class SigVerifier
    implements ContentVerifier {
        private InfosecSignerOutputStream stream;
        private AlgorithmIdentifier algorithm;

        SigVerifier(AlgorithmIdentifier algorithm, InfosecSignerOutputStream stream) {
            this.algorithm = algorithm;
            this.stream = stream;
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithm;
        }

        @Override
        public OutputStream getOutputStream() {
            if (this.stream == null) {
                throw new IllegalStateException("verifier not initialised");
            }
            return this.stream;
        }

        @Override
        public boolean verify(byte[] expected) {
            return this.stream.verify(expected);
        }
    }
}

