/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.operator.infosec;

import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.crypto.Digest;
import cn.com.infosec.crypto.ExtendedDigest;
import cn.com.infosec.operator.DigestCalculator;
import cn.com.infosec.operator.DigestCalculatorProvider;
import cn.com.infosec.operator.OperatorCreationException;
import cn.com.infosec.operator.infosec.InfosecDefaultDigestProvider;
import cn.com.infosec.operator.infosec.InfosecDigestProvider;
import java.io.IOException;
import java.io.OutputStream;

public class InfosecDigestCalculatorProvider
implements DigestCalculatorProvider {
    private InfosecDigestProvider digestProvider = InfosecDefaultDigestProvider.INSTANCE;

    @Override
    public DigestCalculator get(final AlgorithmIdentifier algorithm) throws OperatorCreationException {
        ExtendedDigest dig = this.digestProvider.get(algorithm);
        final DigestOutputStream stream = new DigestOutputStream(dig);
        return new DigestCalculator(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithm;
            }

            @Override
            public OutputStream getOutputStream() {
                return stream;
            }

            @Override
            public byte[] getDigest() {
                return stream.getDigest();
            }
        };
    }

    private class DigestOutputStream
    extends OutputStream {
        private Digest dig;

        DigestOutputStream(Digest dig) {
            this.dig = dig;
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.dig.update(bytes, off, len);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.dig.update(bytes, 0, bytes.length);
        }

        @Override
        public void write(int b) throws IOException {
            this.dig.update((byte)b);
        }

        byte[] getDigest() {
            byte[] d = new byte[this.dig.getDigestSize()];
            this.dig.doFinal(d, 0);
            return d;
        }
    }
}

