/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.operator.infosec;

import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.crypto.ExtendedDigest;
import cn.com.infosec.crypto.Signer;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.signers.RSADigestSigner;
import cn.com.infosec.crypto.util.PublicKeyFactory;
import cn.com.infosec.operator.DigestAlgorithmIdentifierFinder;
import cn.com.infosec.operator.OperatorCreationException;
import cn.com.infosec.operator.infosec.InfosecContentVerifierProviderBuilder;
import java.io.IOException;

public class InfosecRSAContentVerifierProviderBuilder
extends InfosecContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public InfosecRSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmFinder) {
        this.digestAlgorithmFinder = digestAlgorithmFinder;
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
        ExtendedDigest dig = this.digestProvider.get(digAlg);
        return new RSADigestSigner(dig);
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(publicKeyInfo);
    }
}

