/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.operator.infosec;

import cn.com.infosec.crypto.CryptoException;
import cn.com.infosec.crypto.Signer;
import java.io.IOException;
import java.io.OutputStream;

public class InfosecSignerOutputStream
extends OutputStream {
    private Signer sig;

    InfosecSignerOutputStream(Signer sig) {
        this.sig = sig;
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.sig.update(bytes, off, len);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.sig.update(bytes, 0, bytes.length);
    }

    @Override
    public void write(int b) throws IOException {
        this.sig.update((byte)b);
    }

    byte[] getSignature() throws CryptoException {
        return this.sig.generateSignature();
    }

    boolean verify(byte[] expected) {
        return this.sig.verifySignature(expected);
    }
}

