/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.operator.jcajce;

import cn.com.infosec.asn1.cms.GenericHybridParameters;
import cn.com.infosec.asn1.cms.RsaKemParameters;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.crypto.util.DEROtherInfo;
import cn.com.infosec.jcajce.spec.KTSParameterSpec;
import cn.com.infosec.jcajce.util.DefaultJcaJceHelper;
import cn.com.infosec.jcajce.util.NamedJcaJceHelper;
import cn.com.infosec.jcajce.util.ProviderJcaJceHelper;
import cn.com.infosec.operator.AsymmetricKeyUnwrapper;
import cn.com.infosec.operator.GenericKey;
import cn.com.infosec.operator.OperatorException;
import cn.com.infosec.operator.jcajce.JceGenericKey;
import cn.com.infosec.operator.jcajce.OperatorHelper;
import cn.com.infosec.util.Arrays;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class JceKTSKeyUnwrapper
extends AsymmetricKeyUnwrapper {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private Map extraMappings = new HashMap();
    private PrivateKey privKey;
    private byte[] partyUInfo;
    private byte[] partyVInfo;

    public JceKTSKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privKey, byte[] partyUInfo, byte[] partyVInfo) {
        super(algorithmIdentifier);
        this.privKey = privKey;
        this.partyUInfo = Arrays.clone(partyUInfo);
        this.partyVInfo = Arrays.clone(partyVInfo);
    }

    public JceKTSKeyUnwrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceKTSKeyUnwrapper setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    @Override
    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        Key sKey;
        GenericHybridParameters params = GenericHybridParameters.getInstance(this.getAlgorithmIdentifier().getParameters());
        Cipher keyCipher = this.helper.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm(), this.extraMappings);
        String symmetricWrappingAlg = this.helper.getWrappingAlgorithmName(params.getDem().getAlgorithm());
        RsaKemParameters kemParameters = RsaKemParameters.getInstance(params.getKem().getParameters());
        int keySizeInBits = kemParameters.getKeyLength().intValue() * 8;
        try {
            DEROtherInfo otherInfo = new DEROtherInfo.Builder(params.getDem(), this.partyUInfo, this.partyVInfo).build();
            KTSParameterSpec ktsSpec = new KTSParameterSpec.Builder(symmetricWrappingAlg, keySizeInBits, otherInfo.getEncoded()).withKdfAlgorithm(kemParameters.getKeyDerivationFunction()).build();
            keyCipher.init(4, (Key)this.privKey, ktsSpec);
            sKey = keyCipher.unwrap(encryptedKey, this.helper.getKeyAlgorithmName(encryptedKeyAlgorithm.getAlgorithm()), 3);
        }
        catch (Exception e) {
            throw new OperatorException("Unable to unwrap contents key: " + e.getMessage(), e);
        }
        return new JceGenericKey(encryptedKeyAlgorithm, sKey);
    }
}

