/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.pkcs.infosec;

import cn.com.infosec.asn1.DERNull;
import cn.com.infosec.asn1.oiw.OIWObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.PKCS12PBEParams;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.crypto.ExtendedDigest;
import cn.com.infosec.crypto.digests.SHA1Digest;
import cn.com.infosec.operator.MacCalculator;
import cn.com.infosec.pkcs.PKCS12MacCalculatorBuilder;
import cn.com.infosec.pkcs.infosec.PKCS12PBEUtils;
import java.security.SecureRandom;

public class InfosecPKCS12MacCalculatorBuilder
implements PKCS12MacCalculatorBuilder {
    private ExtendedDigest digest;
    private AlgorithmIdentifier algorithmIdentifier;
    private SecureRandom random;
    private int saltLength;
    private int iterationCount = 1024;

    public InfosecPKCS12MacCalculatorBuilder() {
        this(new SHA1Digest(), new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE));
    }

    public InfosecPKCS12MacCalculatorBuilder(ExtendedDigest digest, AlgorithmIdentifier algorithmIdentifier) {
        this.digest = digest;
        this.algorithmIdentifier = algorithmIdentifier;
        this.saltLength = digest.getDigestSize();
    }

    public InfosecPKCS12MacCalculatorBuilder setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
        return this;
    }

    @Override
    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public MacCalculator build(char[] password) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] salt = new byte[this.saltLength];
        this.random.nextBytes(salt);
        return PKCS12PBEUtils.createMacCalculator(this.algorithmIdentifier.getAlgorithm(), this.digest, new PKCS12PBEParams(salt, this.iterationCount), password);
    }
}

