/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.pkcs.infosec;

import cn.com.infosec.asn1.DERNull;
import cn.com.infosec.asn1.pkcs.PKCS12PBEParams;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.operator.MacCalculator;
import cn.com.infosec.operator.OperatorCreationException;
import cn.com.infosec.operator.infosec.InfosecDigestProvider;
import cn.com.infosec.pkcs.PKCS12MacCalculatorBuilder;
import cn.com.infosec.pkcs.PKCS12MacCalculatorBuilderProvider;
import cn.com.infosec.pkcs.infosec.PKCS12PBEUtils;

public class InfosecPKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private InfosecDigestProvider digestProvider;

    public InfosecPKCS12MacCalculatorBuilderProvider(InfosecDigestProvider digestProvider) {
        this.digestProvider = digestProvider;
    }

    @Override
    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            @Override
            public MacCalculator build(char[] password) throws OperatorCreationException {
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                return PKCS12PBEUtils.createMacCalculator(algorithmIdentifier.getAlgorithm(), InfosecPKCS12MacCalculatorBuilderProvider.this.digestProvider.get(algorithmIdentifier), pbeParams, password);
            }

            @Override
            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

