/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.pkcs.infosec;

import cn.com.infosec.asn1.pkcs.PKCS12PBEParams;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.ExtendedDigest;
import cn.com.infosec.crypto.digests.SHA1Digest;
import cn.com.infosec.crypto.generators.PKCS12ParametersGenerator;
import cn.com.infosec.crypto.io.CipherInputStream;
import cn.com.infosec.crypto.paddings.PaddedBufferedBlockCipher;
import cn.com.infosec.operator.GenericKey;
import cn.com.infosec.operator.InputDecryptor;
import cn.com.infosec.operator.InputDecryptorProvider;
import cn.com.infosec.pkcs.infosec.PKCS12PBEUtils;
import java.io.InputStream;

public class InfosecPKCS12PBEInputDecryptorProviderBuilder {
    private ExtendedDigest digest;

    public InfosecPKCS12PBEInputDecryptorProviderBuilder() {
        this(new SHA1Digest());
    }

    public InfosecPKCS12PBEInputDecryptorProviderBuilder(ExtendedDigest digest) {
        this.digest = digest;
    }

    public InputDecryptorProvider build(final char[] password) {
        return new InputDecryptorProvider(){

            @Override
            public InputDecryptor get(final AlgorithmIdentifier algorithmIdentifier) {
                final PaddedBufferedBlockCipher engine = PKCS12PBEUtils.getEngine(algorithmIdentifier.getAlgorithm());
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                CipherParameters params = PKCS12PBEUtils.createCipherParameters(algorithmIdentifier.getAlgorithm(), InfosecPKCS12PBEInputDecryptorProviderBuilder.this.digest, engine.getBlockSize(), pbeParams, password);
                engine.init(false, params);
                return new InputDecryptor(){

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return algorithmIdentifier;
                    }

                    @Override
                    public InputStream getInputStream(InputStream input) {
                        return new CipherInputStream(input, engine);
                    }

                    public GenericKey getKey() {
                        return new GenericKey(PKCS12ParametersGenerator.PKCS12PasswordToBytes(password));
                    }
                };
            }
        };
    }
}

