/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.der.util;

import cn.com.infosec.netsign.der.util.DERSegment;
import cn.com.infosec.netsign.der.util.DERUtil;
import cn.com.infosec.netsign.der.util.PKCS7SignedData;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public class PKCS7SignedDataParser {
    public static PKCS7SignedData parse(byte[] p7, String provider) throws NoSuchProviderException, CertificateException {
        PKCS7SignedData p7sd = new PKCS7SignedData();
        DERSegment dseg = new DERSegment(p7);
        dseg = dseg.getInnerDERSegment();
        dseg = dseg.getDERSegment(1);
        dseg = dseg.getInnerDERSegment().getInnerDERSegment();
        dseg = dseg.subDERSegment(2);
        block6: while (dseg.hasMoreDERSegment()) {
            DERSegment tmpseg = dseg.nextDERSegment();
            switch (tmpseg.getType() & 0xFF) {
                case 48: {
                    tmpseg = tmpseg.getInnerDERSegment();
                    while (tmpseg.hasMoreDERSegment()) {
                        DERSegment content = tmpseg.nextDERSegment();
                        if ((0xFF & content.getType()) != 160) continue;
                        content = content.getInnerDERSegment();
                        p7sd.setContent(content.getInnerData());
                    }
                    continue block6;
                }
                case 160: {
                    tmpseg = tmpseg.getInnerDERSegment();
                    CertificateFactory cf = null;
                    if (provider == null) {
                        cf = CertificateFactory.getInstance("X.509");
                    } else {
                        String alg = provider.equals("INFOSEC") ? "X.509FX" : "X.509";
                        cf = CertificateFactory.getInstance(alg, provider);
                    }
                    while (tmpseg.hasMoreDERSegment()) {
                        DERSegment cert = tmpseg.nextDERSegment();
                        p7sd.addCert(cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded())));
                    }
                    continue block6;
                }
                case 161: {
                    break;
                }
                case 49: {
                    tmpseg = tmpseg.getInnerDERSegment();
                    tmpseg = tmpseg.getDERSegment(0);
                    PKCS7SignedDataParser.parseSignerInfo(p7sd, tmpseg);
                }
            }
        }
        return p7sd;
    }

    private static void parseSignerInfo(PKCS7SignedData p7sd, DERSegment seg) {
        seg = seg.getInnerDERSegment();
        seg = seg.subDERSegment(1);
        int i = 0;
        while (seg.hasMoreDERSegment()) {
            DERSegment tmpseg = seg.nextDERSegment();
            switch (tmpseg.getType() & 0xFF) {
                case 48: {
                    switch (i) {
                        case 0: {
                            tmpseg = tmpseg.getInnerDERSegment();
                            DERSegment issuer = tmpseg.nextDERSegment();
                            p7sd.setSignCertIssuerSubjectDer(issuer.getEncoded());
                            DERSegment num = tmpseg.nextDERSegment();
                            p7sd.setSignCertSN(new BigInteger(num.getInnerData()));
                            break;
                        }
                        case 1: {
                            tmpseg = tmpseg.getInnerDERSegment().getDERSegment(0);
                            p7sd.setDigestAlgOid(DERUtil.ASN12OID(tmpseg.getInnerData()));
                            break;
                        }
                        case 2: {
                            tmpseg = tmpseg.getInnerDERSegment().getDERSegment(0);
                            p7sd.setDigestEncryptionAlgOid(DERUtil.ASN12OID(tmpseg.getInnerData()));
                        }
                    }
                    ++i;
                    break;
                }
                case 4: {
                    p7sd.setSignature(tmpseg.getInnerData());
                    break;
                }
                case 160: {
                    break;
                }
            }
        }
    }
}

