/*
 * Decompiled with CFR 0.152.
 */
package com.czb.sap.sdk.service.impl;

import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import com.czb.commons.cfca.SM2CertUtils;
import com.czb.commons.cfca.SignVerUtils;
import com.czb.commons.security.cipher.sm.SM3Digest;
import com.czb.commons.security.cipher.sm.SM4Utils;
import com.czb.sap.sdk.exception.SdkException;
import com.czb.sap.sdk.tools.StringUtils;
import com.czb.sap.sdk.type.ErrorCode;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vot4java.runtime.Frame;
import vot4java.runtime.GenericObject;
import vot4java.runtime.StubObject;

public class OpenApiSecurityService {
    private static final Logger log;
    private Session session;

    static {
        Frame frame = new Frame(1, 0);
        int[] nArray = new int[]{1205203619, -631425561, -2091113401, 936303395};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 1205203619: {
                    GenericObject genericObject = new GenericObject();
                    genericObject.setObject(OpenApiSecurityService.class);
                    frame.push(genericObject);
                    ++n;
                    break;
                }
                case -631425561: {
                    Class clazz = (Class)frame.pop().getObject();
                    Logger logger = LoggerFactory.getLogger((Class)clazz);
                    GenericObject genericObject = new GenericObject();
                    genericObject.setObject(logger);
                    frame.push(genericObject);
                    ++n;
                    break;
                }
                case -2091113401: {
                    GenericObject genericObject = frame.pop();
                    log = (Logger)genericObject.getObject();
                    ++n;
                    break;
                }
                case 936303395: {
                    return;
                }
            }
        }
    }

    private Session getSession() throws Exception {
        if (this.session != null) {
            return this.session;
        }
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        this.session = JCrypto.getInstance().openSession("JSOFT_LIB");
        return this.session;
    }

    public String signature(String data, String appcode) {
        try {
            StringBuilder sb = new StringBuilder(data);
            sb.append(appcode);
            String src = sb.toString();
            byte[] md = new byte[32];
            byte[] msg1 = src.getBytes("UTF-8");
            SM3Digest sm3 = new SM3Digest();
            sm3.update(msg1, 0, msg1.length);
            sm3.doFinal(md, 0);
            String sign = new String(Hex.encode((byte[])md));
            return sign;
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u8be5\u8fd0\u884c\u73af\u5883\u4e0d\u652f\u6301UTF-8\u7f16\u7801,\u8bf7\u68c0\u67e5", (Throwable)e);
            throw new SdkException(ErrorCode.E0001, (Throwable)e);
        }
    }

    public String fileAbstract(byte[] data) {
        byte[] md = new byte[32];
        SM3Digest sm3 = new SM3Digest();
        sm3.update(data, 0, data.length);
        sm3.doFinal(md, 0);
        String sign = new String(Hex.encode((byte[])md));
        return sign;
    }

    public String encrypt(String data, String appcode) {
        String secretKey = this.secretKey(appcode);
        SM4Utils sm4 = new SM4Utils(secretKey, null, false);
        return sm4.encryptData_ECB(data);
    }

    public String decrypt(String data, String appcode) {
        String secretKey = this.secretKey(appcode);
        SM4Utils sm4 = new SM4Utils(secretKey, null, false);
        return sm4.decryptData_ECB(data);
    }

    private String secretKey(String string) {
        Frame frame = new Frame(3, 5);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject(this);
        frame.setLocal(0, genericObject);
        GenericObject genericObject2 = new GenericObject();
        genericObject2.setObject(string);
        frame.setLocal(1, genericObject2);
        int[] nArray = new int[]{-1150516162, 1, 240415267, -595695182, 1255369729, 13, -1150516162, 1, -1186553065, -1079116859, 675163646, 579156962, 1, 645643528, 940056871, -464485748, -1390330897, 618245714, 2, -998130484, -1822734825, 3, 338845170, 44, 1132532235, 3, -1915229427, 1286320851, -998130484, 1582169005, 218306960, 4, -1752478355, 2, -1150516162, 1, -1935885003, 4, -1364774384, -535184534, 1573483462, 1174063018, 3, 1, 1132532235, 3, 2092250134, -459595183, 24, -1752478355, 2, -1425591212, -577618964};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case -1150516162: {
                    GenericObject genericObject3 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject3);
                    n += 2;
                    break;
                }
                case 240415267: {
                    Object object = frame.pop().getObject();
                    int n2 = ((String)object).length();
                    GenericObject genericObject4 = new GenericObject();
                    genericObject4.setInt(n2);
                    frame.push(genericObject4);
                    ++n;
                    break;
                }
                case -595695182: {
                    GenericObject genericObject5 = new GenericObject();
                    genericObject5.setInt(32);
                    frame.push(genericObject5);
                    ++n;
                    break;
                }
                case 1255369729: {
                    int n3 = frame.pop().toInt();
                    int n4 = frame.pop().toInt();
                    if (n4 >= n3) {
                        n = nArray[n + 1];
                        break;
                    }
                    n += 2;
                    break;
                }
                case -1186553065: {
                    GenericObject genericObject6 = new GenericObject();
                    genericObject6.setInt(32);
                    frame.push(genericObject6);
                    ++n;
                    break;
                }
                case -1079116859: {
                    GenericObject genericObject7 = new GenericObject();
                    genericObject7.setString("MA==");
                    frame.push(genericObject7);
                    ++n;
                    break;
                }
                case 675163646: {
                    String string2 = (String)frame.pop().getObject();
                    int n5 = frame.pop().getInt();
                    String string3 = (String)frame.pop().getObject();
                    String string4 = StringUtils.leftPad(string3, n5, string2);
                    GenericObject genericObject8 = new GenericObject();
                    genericObject8.setObject(string4);
                    frame.push(genericObject8);
                    ++n;
                    break;
                }
                case 579156962: {
                    GenericObject genericObject9 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject9);
                    n += 2;
                    break;
                }
                case 645643528: {
                    StubObject stubObject = new StubObject("java.lang.StringBuilder");
                    GenericObject genericObject10 = new GenericObject();
                    genericObject10.setObject(stubObject);
                    frame.push(genericObject10);
                    ++n;
                    break;
                }
                case 940056871: {
                    GenericObject genericObject11 = frame.peek();
                    frame.push(genericObject11);
                    ++n;
                    break;
                }
                case -464485748: {
                    GenericObject genericObject12 = new GenericObject();
                    genericObject12.setInt(16);
                    frame.push(genericObject12);
                    ++n;
                    break;
                }
                case -1390330897: {
                    int n6 = frame.pop().getInt();
                    StringBuilder stringBuilder = new StringBuilder(n6);
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject13 = new GenericObject();
                    genericObject13.setObject(stringBuilder);
                    frame.push(genericObject13);
                    ++n;
                    break;
                }
                case 618245714: {
                    GenericObject genericObject14 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject14);
                    n += 2;
                    break;
                }
                case -998130484: {
                    GenericObject genericObject15 = new GenericObject();
                    genericObject15.setInt(1);
                    frame.push(genericObject15);
                    ++n;
                    break;
                }
                case -1822734825: {
                    int n7 = frame.pop().toInt();
                    GenericObject genericObject16 = new GenericObject();
                    genericObject16.setInt(n7);
                    frame.setLocal(nArray[n + 1], genericObject16);
                    n += 2;
                    break;
                }
                case 338845170: {
                    n = nArray[n + 1];
                    break;
                }
                case 1132532235: {
                    GenericObject genericObject17 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject17);
                    n += 2;
                    break;
                }
                case -1915229427: {
                    GenericObject genericObject18 = new GenericObject();
                    genericObject18.setInt(2);
                    frame.push(genericObject18);
                    ++n;
                    break;
                }
                case 1286320851: {
                    GenericObject genericObject19 = frame.pop();
                    GenericObject genericObject20 = frame.pop();
                    GenericObject genericObject21 = new GenericObject();
                    genericObject21.setInt(genericObject20.getInt() * genericObject19.getInt());
                    frame.push(genericObject21);
                    ++n;
                    break;
                }
                case 1582169005: {
                    GenericObject genericObject22 = frame.pop();
                    GenericObject genericObject23 = frame.pop();
                    GenericObject genericObject24 = new GenericObject();
                    genericObject24.setInt(genericObject23.getInt() - genericObject22.getInt());
                    frame.push(genericObject24);
                    ++n;
                    break;
                }
                case 218306960: {
                    int n8 = frame.pop().toInt();
                    GenericObject genericObject25 = new GenericObject();
                    genericObject25.setInt(n8);
                    frame.setLocal(nArray[n + 1], genericObject25);
                    n += 2;
                    break;
                }
                case -1752478355: {
                    GenericObject genericObject26 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject26);
                    n += 2;
                    break;
                }
                case -1935885003: {
                    GenericObject genericObject27 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject27);
                    n += 2;
                    break;
                }
                case -1364774384: {
                    int n9 = frame.pop().getInt();
                    Object object = frame.pop().getObject();
                    char c = ((String)object).charAt(n9);
                    GenericObject genericObject28 = new GenericObject();
                    genericObject28.setChar(c);
                    frame.push(genericObject28);
                    ++n;
                    break;
                }
                case -535184534: {
                    char c = frame.pop().getChar();
                    Object object = frame.pop().getObject();
                    Object object2 = ((StringBuilder)object).append(c);
                    GenericObject genericObject29 = new GenericObject();
                    genericObject29.setObject(object2);
                    frame.push(genericObject29);
                    ++n;
                    break;
                }
                case 1573483462: {
                    frame.pop();
                    ++n;
                    break;
                }
                case 1174063018: {
                    int n10 = nArray[n + 1];
                    int n11 = nArray[n + 2];
                    frame.iinc(n10, n11);
                    n += 3;
                    break;
                }
                case 2092250134: {
                    GenericObject genericObject30 = new GenericObject();
                    genericObject30.setInt(16);
                    frame.push(genericObject30);
                    ++n;
                    break;
                }
                case -459595183: {
                    int n12 = frame.pop().toInt();
                    int n13 = frame.pop().toInt();
                    if (n13 <= n12) {
                        n = nArray[n + 1];
                        break;
                    }
                    n += 2;
                    break;
                }
                case -1425591212: {
                    Object object = frame.pop().getObject();
                    Object object3 = ((StringBuilder)object).toString();
                    GenericObject genericObject31 = new GenericObject();
                    genericObject31.setObject(object3);
                    frame.push(genericObject31);
                    ++n;
                    break;
                }
                case -577618964: {
                    return (String)frame.pop().getObject();
                }
            }
        }
    }

    public String cfcaSignature(String data, String sm2password, byte[] sm2Cert) {
        try {
            byte[] signedData = SignVerUtils.signature((byte[])sm2Cert, (String)sm2password, (byte[])data.getBytes(Charset.forName("UTF-8")), (Session)this.getSession());
            return new String(signedData, "UTF-8");
        }
        catch (Exception e) {
            log.error("\u7ec4\u88c5\u8bc1\u4e66\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            throw new SdkException(ErrorCode.E0002, (Throwable)e);
        }
    }

    public boolean verify(String signData, String signResource) {
        try {
            return SignVerUtils.verify((byte[])signResource.getBytes(Charset.forName("UTF-8")), (byte[])signData.getBytes(Charset.forName("UTF-8")), (Session)this.getSession());
        }
        catch (Exception e) {
            log.error("\u8bc1\u4e66\u9a8c\u7b7e\u5f02\u5e38", (Throwable)e);
            throw new SdkException(ErrorCode.E0003, (Throwable)e);
        }
    }

    public boolean verifyDn(String signData, byte[] cerResource) {
        String cerDn;
        String signDn;
        block3: {
            try {
                signDn = SM2CertUtils.getDNFromSignData((byte[])signData.getBytes(Charset.forName("UTF-8")));
                signDn = signDn.replace("CN=", "cn=").replace(", OU=", ",ou=").replace(", O=", ",o=").replace(", C=", ",c=");
                X509Certificate certs = SM2CertUtils.getX509CertFromCer((byte[])cerResource);
                String dn = certs.getSubjectDN().getName();
                String[] s = dn.split(",");
                String[] ss0 = s[0].split("=");
                String ret0 = ss0[1].trim();
                String[] ss1 = s[1].split("=");
                String ret1 = ss1[1].trim();
                String[] ss2 = s[2].split("=");
                String ret2 = ss2[1].trim();
                String[] ss3 = s[3].split("=");
                String ret3 = ss3[1].trim();
                String[] ss4 = s[4].split("=");
                String ret4 = ss4[1].trim();
                cerDn = "cn=" + ret4 + ",ou=" + ret3 + ",ou=" + ret2 + ",o=" + ret1 + ",c=" + ret0;
                if (!StringUtils.equals(signDn, cerDn)) break block3;
                return true;
            }
            catch (Exception e) {
                log.error("\u8bc1\u4e66\u8bc1\u4e66dn\u5f02\u5e38", (Throwable)e);
                throw new SdkException(ErrorCode.E0004, (Throwable)e);
            }
        }
        log.warn("\u8bc1\u4e66\u5173\u7cfb\u4e0d\u6b63\u786e \u62a5\u6587dn[{}],\u8bc1\u4e66dn [{}]", (Object)signDn, (Object)cerDn);
        return false;
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame(3, 3);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject(stringArray);
        frame.setLocal(0, genericObject);
        int[] nArray = new int[]{-555355805, -725100089, -1430130735, 398063656, 1, -37928829, 1, 41843001, -196082891, -1485529600, -394149957, 2, -417816254, 2126121219, 2, -1860679172, 112391517};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case -555355805: {
                    StubObject stubObject = new StubObject("com.czb.sap.sdk.service.impl.OpenApiSecurityService");
                    GenericObject genericObject2 = new GenericObject();
                    genericObject2.setObject(stubObject);
                    frame.push(genericObject2);
                    ++n;
                    break;
                }
                case -725100089: {
                    GenericObject genericObject3 = frame.peek();
                    frame.push(genericObject3);
                    ++n;
                    break;
                }
                case -1430130735: {
                    OpenApiSecurityService openApiSecurityService = new OpenApiSecurityService();
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject4 = new GenericObject();
                    genericObject4.setObject(openApiSecurityService);
                    frame.push(genericObject4);
                    ++n;
                    break;
                }
                case 398063656: {
                    GenericObject genericObject5 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject5);
                    n += 2;
                    break;
                }
                case -37928829: {
                    GenericObject genericObject6 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject6);
                    n += 2;
                    break;
                }
                case 41843001: {
                    GenericObject genericObject7 = new GenericObject();
                    genericObject7.setString("WjAwMDAwNDQwMVowMDAwMDQ0MjAyMS0wMS0yMiAxNjoxNDo1MC41NTYxMTE2MTEzMDMyOTA1NTY=");
                    frame.push(genericObject7);
                    ++n;
                    break;
                }
                case -196082891: {
                    GenericObject genericObject8 = new GenericObject();
                    genericObject8.setString("MzZBNkJCMkVGMDgyMzVCNDRCRjlDM0I0ODJEQzExMjQ=");
                    frame.push(genericObject8);
                    ++n;
                    break;
                }
                case -1485529600: {
                    Object object = frame.pop().getObject();
                    Object object2 = frame.pop().getObject();
                    Object object3 = frame.pop().getObject();
                    Object object4 = ((OpenApiSecurityService)object3).signature((String)object2, (String)object);
                    GenericObject genericObject9 = new GenericObject();
                    genericObject9.setObject(object4);
                    frame.push(genericObject9);
                    ++n;
                    break;
                }
                case -394149957: {
                    GenericObject genericObject10 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject10);
                    n += 2;
                    break;
                }
                case -417816254: {
                    GenericObject genericObject11 = new GenericObject();
                    genericObject11.setObject(System.out);
                    frame.push(genericObject11);
                    ++n;
                    break;
                }
                case 2126121219: {
                    GenericObject genericObject12 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject12);
                    n += 2;
                    break;
                }
                case -1860679172: {
                    Object object = frame.pop().getObject();
                    Object object5 = frame.pop().getObject();
                    ((PrintStream)object5).println((String)object);
                    ++n;
                    break;
                }
                case 112391517: {
                    return;
                }
            }
        }
    }
}

