/*
 * Decompiled with CFR 0.152.
 */
package com.czb.sap.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.czb.sap.sdk.config.EntAppConfig;
import com.czb.sap.sdk.exception.SdkException;
import com.czb.sap.sdk.inf.ApiHeader;
import com.czb.sap.sdk.inf.ApiRspData;
import com.czb.sap.sdk.inf.DownloadFileIn;
import com.czb.sap.sdk.inf.DownloadFileOut;
import com.czb.sap.sdk.inf.DownloadReqeust;
import com.czb.sap.sdk.inf.GetTokenIn;
import com.czb.sap.sdk.inf.GetTokenOut;
import com.czb.sap.sdk.inf.MakeH5GetOut;
import com.czb.sap.sdk.inf.OpenApiRequest;
import com.czb.sap.sdk.inf.OpenApiResponse;
import com.czb.sap.sdk.inf.RegisterTokenRequest;
import com.czb.sap.sdk.inf.RegisterTokenResponse;
import com.czb.sap.sdk.inf.UploadFileIn;
import com.czb.sap.sdk.inf.UploadFileOut;
import com.czb.sap.sdk.inf.UploadRequest;
import com.czb.sap.sdk.service.OpenApiService;
import com.czb.sap.sdk.service.impl.OpenApiSecurityService;
import com.czb.sap.sdk.tools.DateUtil;
import com.czb.sap.sdk.tools.HttpClientUtil;
import com.czb.sap.sdk.tools.SdkCache;
import com.czb.sap.sdk.tools.StringUtils;
import com.czb.sap.sdk.type.ErrorCode;
import com.czb.sap.sdk.type.TermianaType;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vot4java.runtime.Exp;
import vot4java.runtime.Frame;
import vot4java.runtime.GenericObject;
import vot4java.runtime.StubObject;

public class OpenApiServiceImpl
implements OpenApiService {
    private static final Logger log;
    private String appName;
    private EntAppConfig config;
    private OpenApiSecurityService securityService;
    private Lock lock = new ReentrantLock();

    static {
        Frame frame = new Frame(1, 0);
        int[] nArray = new int[]{-623924259, 1845211746, 1090154836, -937753953};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case -623924259: {
                    GenericObject genericObject = new GenericObject();
                    genericObject.setObject(OpenApiServiceImpl.class);
                    frame.push(genericObject);
                    ++n;
                    break;
                }
                case 1845211746: {
                    Class clazz = (Class)frame.pop().getObject();
                    Logger logger = LoggerFactory.getLogger((Class)clazz);
                    GenericObject genericObject = new GenericObject();
                    genericObject.setObject(logger);
                    frame.push(genericObject);
                    ++n;
                    break;
                }
                case 1090154836: {
                    GenericObject genericObject = frame.pop();
                    log = (Logger)genericObject.getObject();
                    ++n;
                    break;
                }
                case -937753953: {
                    return;
                }
            }
        }
    }

    public OpenApiServiceImpl() {
        this.securityService = new OpenApiSecurityService();
    }

    @Override
    public GetTokenOut getToken(GetTokenIn in) throws SdkException {
        this.lock.lock();
        try {
            String outtimeout;
            String token;
            OpenApiRequest reqeust = new OpenApiRequest();
            reqeust.setAppid(this.config.getAppid());
            reqeust.setOpenid(this.config.getOpenid());
            if (StringUtils.isBlank(in.getSendtime())) {
                reqeust.setSendtime(DateUtil.getSendTime());
            } else {
                reqeust.setSendtime(in.getSendtime());
            }
            reqeust.setTermianatype(TermianaType.SDK.getCode());
            reqeust.setTraceno(in.getTraceno());
            String signResource = reqeust.signResource();
            String sign = this.securityService.signature(signResource, this.config.getAppkey());
            reqeust.setSign(sign);
            if (this.config.getCfcafile() != null && this.config.getCfcafile().length > 1) {
                String cfcaSign = this.securityService.cfcaSignature(signResource, this.config.getCfcapwd(), this.config.getCfcafile());
                reqeust.setCfcasign(cfcaSign);
            }
            URI url = this.config.createURI("token");
            String postJson = JSON.toJSONString((Object)reqeust);
            log.debug("\u83b7\u53d6token\u8bf7\u6c42:[{}]", (Object)postJson);
            String response = HttpClientUtil.post(url, postJson, this.config);
            log.debug("\u83b7\u53d6token\u5e94\u7b54:[{}]", (Object)response);
            OpenApiResponse out = (OpenApiResponse)JSON.parseObject((String)response, OpenApiResponse.class);
            GetTokenOut res = new GetTokenOut();
            res.setOrgtraceno(out.getOrgtraceno());
            res.setResultcode(out.getResultcode());
            res.setSenttime(out.getSendtime());
            res.setResultdesc(out.getResultdesc());
            if ("000000".equals(out.getResultcode())) {
                String body = this.securityService.decrypt(out.getBody(), this.config.getAppkey());
                JSONObject tokenBody = JSON.parseObject((String)body);
                token = tokenBody.getString("token");
                outtimeout = "19";
                if (tokenBody.containsKey((Object)"timeout")) {
                    outtimeout = tokenBody.getString("timeout");
                }
            } else {
                log.error("\u83b7\u53d6token\u5931\u8d25\uff0c\u5e94\u7b54\u7ed3\u679c[{}],\u53c2\u6570\u914d\u7f6e[{}}", (Object)JSON.toJSONString((Object)out), (Object)JSON.toJSONString((Object)this.config));
                throw new SdkException(ErrorCode.E0006);
            }
            res.setTimeout(outtimeout);
            res.setToken(token);
            SdkCache.getInstance().putValue(String.valueOf(this.appName) + "token", token);
            long timeout = Long.parseLong(outtimeout) * 1000L;
            long times = System.currentTimeMillis() + timeout;
            SdkCache.getInstance().putValue(String.valueOf(this.appName) + "tokentimeout", String.valueOf(times));
            GetTokenOut getTokenOut = res;
            return getTokenOut;
        }
        catch (SdkException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6token\u5931\u8d25,\u8bf7\u6c42\u6570\u636e[{}]", (Object)JSON.toJSONString((Object)in), (Object)e);
            throw new SdkException(ErrorCode.E0007, (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ApiRspData invoke(ApiHeader header, Map<String, Object> reqData) throws SdkException {
        try {
            OpenApiRequest reqeust = new OpenApiRequest();
            reqeust.setAppid(this.config.getAppid());
            reqeust.setOpenid(this.config.getOpenid());
            reqeust.setTermianatype(TermianaType.SDK.getCode());
            if (StringUtils.isNotBlank(header.getToken())) {
                reqeust.setToken(header.getToken());
            } else {
                reqeust.setToken(this.getCacheToken());
            }
            if (StringUtils.isBlank(header.getSendtime())) {
                reqeust.setSendtime(DateUtil.getSendTime());
            } else {
                reqeust.setSendtime(header.getSendtime());
            }
            reqeust.setTraceno(header.getTraceno());
            if (reqData != null && reqData.size() > 0) {
                String jsonBody = JSON.toJSONString(reqData);
                log.info("\u6e90\u62a5\u6587[{}]", (Object)jsonBody);
                String body = this.securityService.encrypt(jsonBody, this.config.getAppkey());
                reqeust.setBody(body);
            }
            String signResource = reqeust.signResource();
            String sign = this.securityService.signature(signResource, this.config.getAppkey());
            reqeust.setSign(sign);
            if (this.config.getCfcafile() != null && this.config.getCfcafile().length > 1) {
                String cfcaSign = this.securityService.cfcaSignature(signResource, this.config.getCfcapwd(), this.config.getCfcafile());
                reqeust.setCfcasign(cfcaSign);
            }
            URI url = this.config.createURI(header.getMsgtype());
            String postJson = JSON.toJSONString((Object)reqeust);
            log.info("\u8bf7\u6c42\u5730\u5740:[{}],\u62a5\u6587[{}]", (Object)url.toASCIIString(), (Object)postJson);
            String response = HttpClientUtil.post(url, postJson, this.config);
            log.info("\u5e94\u7b54:[{}]", (Object)response);
            OpenApiResponse out = (OpenApiResponse)JSON.parseObject((String)response, OpenApiResponse.class);
            if (out != null && out.getResultcode() != null && !out.getResultcode().startsWith("820")) {
                this.checkApiSign(out);
            }
            ApiRspData rsp = new ApiRspData();
            if (out != null) {
                rsp.setOrgtraceno(out.getOrgtraceno());
                rsp.setOrgmsgtype(out.getOrgtracetype());
                rsp.setResultcode(out.getResultcode());
                rsp.setResultdesc(out.getResultdesc());
                rsp.setSenttime(out.getSendtime());
                if (StringUtils.isNotBlank(out.getBody())) {
                    String jsonBody = this.securityService.decrypt(out.getBody(), this.config.getAppkey());
                    JSONObject outMap = JSON.parseObject((String)jsonBody);
                    rsp.setBody((Map<String, Object>)outMap);
                }
            }
            return rsp;
        }
        catch (SdkException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("\u53c2\u6570\u914d\u7f6e", (Object)JSON.toJSONString((Object)this.config), (Object)e);
            throw new SdkException(ErrorCode.E0008, (Throwable)e);
        }
    }

    @Override
    public String getCacheToken() throws SdkException {
        Frame frame = new Frame(5, 5);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject(this);
        frame.setLocal(0, genericObject);
        int[] nArray = new int[]{-1369576310, 508791573, -1876643674, -182278784, 0, 1389167959, -1082702225, -798750015, -1870743592, 842367508, -1380128268, 175762846, -588034971, 1, -769238463, 508791573, -1876643674, -182278784, 0, 1641629612, -874505386, -903276608, -2065246351, 309561012, 1647607509, -1002191073, 1652584522, 2, 1463257351, 1, -747638712, 50, -1203685741, 2, -747638712, 50, -1603244227, -1353088124, 3, -1203685741, 2, -754128469, 2116108676, 3, 600210440, -988691070, 50, 1463257351, 1, 1124472553, 508791573, -1876643674, -822189751, 1738790617, 3, 597850643, 3, 508791573, -1876643674, -822579944, -837541538, 6218464, -604180380, -1158087989, -182278784, 0, 597850643, 3, -1857530995, -1987296835, 4, -1935109581, 4, -512798040, -313725838};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case -1369576310: {
                    SdkCache sdkCache = SdkCache.getInstance();
                    GenericObject genericObject2 = new GenericObject();
                    genericObject2.setObject(sdkCache);
                    frame.push(genericObject2);
                    ++n;
                    break;
                }
                case 508791573: {
                    StubObject stubObject = new StubObject("java.lang.StringBuilder");
                    GenericObject genericObject3 = new GenericObject();
                    genericObject3.setObject(stubObject);
                    frame.push(genericObject3);
                    ++n;
                    break;
                }
                case -1876643674: {
                    GenericObject genericObject4 = frame.peek();
                    frame.push(genericObject4);
                    ++n;
                    break;
                }
                case -182278784: {
                    GenericObject genericObject5 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject5);
                    n += 2;
                    break;
                }
                case 1389167959: {
                    GenericObject genericObject6 = frame.pop();
                    GenericObject genericObject7 = new GenericObject();
                    genericObject7.setObject(((OpenApiServiceImpl)genericObject6.getObject()).appName);
                    frame.push(genericObject7);
                    ++n;
                    break;
                }
                case -1082702225: {
                    Object object = frame.pop().getObject();
                    String string = String.valueOf(object);
                    GenericObject genericObject8 = new GenericObject();
                    genericObject8.setObject(string);
                    frame.push(genericObject8);
                    ++n;
                    break;
                }
                case -798750015: {
                    Object object = frame.pop().getObject();
                    StringBuilder stringBuilder = new StringBuilder((String)object);
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject9 = new GenericObject();
                    genericObject9.setObject(stringBuilder);
                    frame.push(genericObject9);
                    ++n;
                    break;
                }
                case -1870743592: {
                    GenericObject genericObject10 = new GenericObject();
                    genericObject10.setString("dG9rZW4=");
                    frame.push(genericObject10);
                    ++n;
                    break;
                }
                case 842367508: {
                    Object object = frame.pop().getObject();
                    Object object2 = frame.pop().getObject();
                    Object object3 = ((StringBuilder)object2).append((String)object);
                    GenericObject genericObject11 = new GenericObject();
                    genericObject11.setObject(object3);
                    frame.push(genericObject11);
                    ++n;
                    break;
                }
                case -1380128268: {
                    Object object = frame.pop().getObject();
                    Object object4 = ((StringBuilder)object).toString();
                    GenericObject genericObject12 = new GenericObject();
                    genericObject12.setObject(object4);
                    frame.push(genericObject12);
                    ++n;
                    break;
                }
                case 175762846: {
                    Object object = frame.pop().getObject();
                    Object object5 = frame.pop().getObject();
                    Object object6 = ((SdkCache)object5).getValue((String)object);
                    GenericObject genericObject13 = new GenericObject();
                    genericObject13.setObject(object6);
                    frame.push(genericObject13);
                    ++n;
                    break;
                }
                case -588034971: {
                    GenericObject genericObject14 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject14);
                    n += 2;
                    break;
                }
                case -769238463: {
                    SdkCache sdkCache = SdkCache.getInstance();
                    GenericObject genericObject15 = new GenericObject();
                    genericObject15.setObject(sdkCache);
                    frame.push(genericObject15);
                    ++n;
                    break;
                }
                case 1641629612: {
                    GenericObject genericObject16 = frame.pop();
                    GenericObject genericObject17 = new GenericObject();
                    genericObject17.setObject(((OpenApiServiceImpl)genericObject16.getObject()).appName);
                    frame.push(genericObject17);
                    ++n;
                    break;
                }
                case -874505386: {
                    Object object = frame.pop().getObject();
                    String string = String.valueOf(object);
                    GenericObject genericObject18 = new GenericObject();
                    genericObject18.setObject(string);
                    frame.push(genericObject18);
                    ++n;
                    break;
                }
                case -903276608: {
                    Object object = frame.pop().getObject();
                    StringBuilder stringBuilder = new StringBuilder((String)object);
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject19 = new GenericObject();
                    genericObject19.setObject(stringBuilder);
                    frame.push(genericObject19);
                    ++n;
                    break;
                }
                case -2065246351: {
                    GenericObject genericObject20 = new GenericObject();
                    genericObject20.setString("dG9rZW50aW1lb3V0");
                    frame.push(genericObject20);
                    ++n;
                    break;
                }
                case 309561012: {
                    Object object = frame.pop().getObject();
                    Object object7 = frame.pop().getObject();
                    Object object8 = ((StringBuilder)object7).append((String)object);
                    GenericObject genericObject21 = new GenericObject();
                    genericObject21.setObject(object8);
                    frame.push(genericObject21);
                    ++n;
                    break;
                }
                case 1647607509: {
                    Object object = frame.pop().getObject();
                    Object object9 = ((StringBuilder)object).toString();
                    GenericObject genericObject22 = new GenericObject();
                    genericObject22.setObject(object9);
                    frame.push(genericObject22);
                    ++n;
                    break;
                }
                case -1002191073: {
                    Object object = frame.pop().getObject();
                    Object object10 = frame.pop().getObject();
                    Object object11 = ((SdkCache)object10).getValue((String)object);
                    GenericObject genericObject23 = new GenericObject();
                    genericObject23.setObject(object11);
                    frame.push(genericObject23);
                    ++n;
                    break;
                }
                case 1652584522: {
                    GenericObject genericObject24 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject24);
                    n += 2;
                    break;
                }
                case 1463257351: {
                    GenericObject genericObject25 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject25);
                    n += 2;
                    break;
                }
                case -747638712: {
                    GenericObject genericObject26 = frame.pop();
                    if (genericObject26.getObject() == null) {
                        n = nArray[n + 1];
                        break;
                    }
                    n += 2;
                    break;
                }
                case -1203685741: {
                    GenericObject genericObject27 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject27);
                    n += 2;
                    break;
                }
                case -1603244227: {
                    long l = System.currentTimeMillis();
                    GenericObject genericObject28 = new GenericObject();
                    genericObject28.setLong(l);
                    frame.push(genericObject28);
                    ++n;
                    break;
                }
                case -1353088124: {
                    long l = frame.pop().toLong();
                    GenericObject genericObject29 = new GenericObject();
                    genericObject29.setLong(l);
                    frame.setLocal(nArray[n + 1], genericObject29);
                    n += 2;
                    break;
                }
                case -754128469: {
                    String string = (String)frame.pop().getObject();
                    long l = Long.parseLong(string);
                    GenericObject genericObject30 = new GenericObject();
                    genericObject30.setLong(l);
                    frame.push(genericObject30);
                    ++n;
                    break;
                }
                case 2116108676: {
                    GenericObject genericObject31 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject31);
                    n += 2;
                    break;
                }
                case 600210440: {
                    long l = frame.pop().getLong();
                    long l2 = frame.pop().getLong();
                    GenericObject genericObject32 = new GenericObject();
                    int n2 = l2 == l ? 0 : (l2 > l ? 1 : -1);
                    genericObject32.setInt(n2);
                    frame.push(genericObject32);
                    ++n;
                    break;
                }
                case -988691070: {
                    GenericObject genericObject33 = frame.pop();
                    int n3 = genericObject33.toInt();
                    if (n3 <= 0) {
                        n = nArray[n + 1];
                        break;
                    }
                    n += 2;
                    break;
                }
                case 1124472553: {
                    return (String)frame.pop().getObject();
                }
                case -822189751: {
                    GetTokenIn getTokenIn = new GetTokenIn();
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject34 = new GenericObject();
                    genericObject34.setObject(getTokenIn);
                    frame.push(genericObject34);
                    ++n;
                    break;
                }
                case 1738790617: {
                    GenericObject genericObject35 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject35);
                    n += 2;
                    break;
                }
                case 597850643: {
                    GenericObject genericObject36 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject36);
                    n += 2;
                    break;
                }
                case -822579944: {
                    long l = System.currentTimeMillis();
                    GenericObject genericObject37 = new GenericObject();
                    genericObject37.setLong(l);
                    frame.push(genericObject37);
                    ++n;
                    break;
                }
                case -837541538: {
                    long l = frame.pop().getLong();
                    String string = String.valueOf(l);
                    GenericObject genericObject38 = new GenericObject();
                    genericObject38.setObject(string);
                    frame.push(genericObject38);
                    ++n;
                    break;
                }
                case 6218464: {
                    Object object = frame.pop().getObject();
                    StringBuilder stringBuilder = new StringBuilder((String)object);
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject39 = new GenericObject();
                    genericObject39.setObject(stringBuilder);
                    frame.push(genericObject39);
                    ++n;
                    break;
                }
                case -604180380: {
                    Object object = frame.pop().getObject();
                    Object object12 = ((StringBuilder)object).toString();
                    GenericObject genericObject40 = new GenericObject();
                    genericObject40.setObject(object12);
                    frame.push(genericObject40);
                    ++n;
                    break;
                }
                case -1158087989: {
                    Object object = frame.pop().getObject();
                    Object object13 = frame.pop().getObject();
                    ((GetTokenIn)object13).setTraceno((String)object);
                    ++n;
                    break;
                }
                case -1857530995: {
                    Object object = frame.pop().getObject();
                    Object object14 = frame.pop().getObject();
                    Object object15 = ((OpenApiServiceImpl)object14).getToken((GetTokenIn)object);
                    GenericObject genericObject41 = new GenericObject();
                    genericObject41.setObject(object15);
                    frame.push(genericObject41);
                    ++n;
                    break;
                }
                case -1987296835: {
                    GenericObject genericObject42 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject42);
                    n += 2;
                    break;
                }
                case -1935109581: {
                    GenericObject genericObject43 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject43);
                    n += 2;
                    break;
                }
                case -512798040: {
                    Object object = frame.pop().getObject();
                    Object object16 = ((GetTokenOut)object).getToken();
                    GenericObject genericObject44 = new GenericObject();
                    genericObject44.setObject(object16);
                    frame.push(genericObject44);
                    ++n;
                    break;
                }
                case -313725838: {
                    return (String)frame.pop().getObject();
                }
            }
        }
    }

    private void checkApiSign(OpenApiResponse out) {
        String hsign = this.securityService.signature(out.signResource(), this.config.getAppkey());
        if (!StringUtils.equals(hsign, out.getSign())) {
            log.error("\u672c\u5730\u7b7e\u540d[{}],\u8fd4\u56de\u7b7e\u540d[{}]\uff0c\u8fd4\u56de\u62a5\u6587[{}]", new Object[]{hsign, out.getSign(), JSON.toJSONString((Object)out)});
            throw new SdkException(ErrorCode.E0010);
        }
        if (this.config.getCerfile() != null) {
            if (!this.securityService.verify(out.getCfcasign(), out.signResource())) {
                throw new SdkException(ErrorCode.E0011);
            }
            if (!this.securityService.verifyDn(out.getCfcasign(), this.config.getCerfile())) {
                throw new SdkException(ErrorCode.E0011);
            }
        }
    }

    /*
     * Opcode count of 13273 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    @Override
    public UploadFileOut uploadFile(UploadFileIn uploadFileIn) throws SdkException {
        Frame frame = new Frame(5, 9);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject(this);
        frame.setLocal(0, genericObject);
        GenericObject genericObject2 = new GenericObject();
        genericObject2.setObject(uploadFileIn);
        frame.setLocal(1, genericObject2);
        int[] nArray = new int[]{1860616386, 163326662, 432961299, -1776490250, 2, 1214373518, 1, 962030741, -383391607, 3, 1147658731, 1, 263577932, -735352972, -157856736, 31, 961287975, -254552370, 324623719, 3, 203227428, 200622391, -153925247, 1726283895, -1829724809, 1, -897100766, 322110966, 1265443820, -162326348, 3, -582273606, 2, -249416546, 3, -1507734341, -1593178730, 2, 381682996, 1, -1483027499, -265923267, -1540588133, 2, 1203816443, 1, -769483231, 1380292642, -1839160604, 1, 1368887232, -375879494, 633951908, 62, 827645023, 2, 1272212949, 1, -1463318963, 782585342, 1380855847, 68, -1437612101, 2, -1546540548, 0, 288993311, 207052842, -165355271, 169952937, 4, -1174932581, 1, 1026731275, 1273671215, 1622066804, 232, -1838141727, 1, 1273652042, 1732134250, 843970177, 5, -721653069, -1225091422, 6, 554926008, -1784820994, 7, 698537938, 226, -1294946382, 2, 1349885951, -1738416284, -81906696, 6, -1711034401, 1839928074, 1052587772, -578246134, -378384520, 6, -78865180, 110, -1237712476, 2, -1608349299, 7, 362961434, -250509463, -1996330798, 8, -1671220902, 5, 1989078357, 0, 1712825881, 829073625, -584521331, 2043248015, -846773457, 168, 422378091, 0, 1555556547, 179029288, -572503567, 1186730078, 8, -695732093, 8, -610860578, 1, -499170743, 907619763, 6, 904097020, 8, -1004592013, -1027739243, 0, 1441208275, 726754288, 1959188109, -1627605829, -1656526566, 5, -1007649040, 0, 735804124, -786503809, -1350301799, 1317440713, 508464001, 5, -1722421992, 0, 277791767, 1834800702, -849610066, 1606135295, 6, 1398629721, -515374602, 6, 1285781897, 188, 1425448714, 5, -1130323037, 8, -1934244936, 8, 1985268053, 1, 2133763513, 563665022, 6, 76139221, 8, -2106754349, -1048875568, 5, 1868785338, 322348004, 1560854501, 5, -848690139, 2, 493362870, 8, 538345908, 1151873909, 0, -373241157, 2, 914498270, -187489922, 4, -1503216748, 4, 478550542, 219, -1003220876, -873775526, 963963365, 4, 834610096, 1710190739, -1856550924, 219, 122715708, 4, -1046353388, 678671729, 7, 1614172287, 226, 1092546433, 4, 1229873577, 226, 919160804, 4, 1502045672, -2035474726, 5, 2110787370, 91, 1939958055, 257, 797100623, 2, 118790409, 1, -1419069644, 657190109, 577355698, 2, -1205269998, 1, 2018112280, -1358950571, -1780819221, 2, -1093220576, 1, 450150130, 63302670, -198962724, 0, 566596264, 2, -1369221894, 924997758, 4, -689243929, 4, 2132868814, 281, 237431321, 205465359, -1525226588, 4, -526773752, -1829232705, 174462569, 281, 1013963981, 4, -204729856, 1, 1723481843, -205197066, 1025550717, 4, 191404223, 1, 1414434987, 919969954, 91835289, 4, -315795449, 519333725, 2, -1756546334, 2, -265111666, -1008193793, 2, 1688710613, 136399096, 2118889788, -1443596779, 2, -707195063, 593678452, 2057438257};
        int n = 0;
        block761: while (true) {
            switch (nArray[n]) {
                case 1860616386: {
                    try {
                        StubObject stubObject = new StubObject("com.czb.sap.sdk.inf.UploadRequest");
                        GenericObject genericObject3 = new GenericObject();
                        genericObject3.setObject(stubObject);
                        frame.push(genericObject3);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject4 = new GenericObject();
                        genericObject4.setObject(exception);
                        frame.push(genericObject4);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject5 = new GenericObject();
                        genericObject5.setObject(error);
                        frame.push(genericObject5);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 163326662: {
                    try {
                        GenericObject genericObject6 = frame.peek();
                        frame.push(genericObject6);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject7 = new GenericObject();
                        genericObject7.setObject(exception);
                        frame.push(genericObject7);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject8 = new GenericObject();
                        genericObject8.setObject(error);
                        frame.push(genericObject8);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 432961299: {
                    try {
                        UploadRequest uploadRequest = new UploadRequest();
                        frame.pop();
                        frame.pop();
                        GenericObject genericObject9 = new GenericObject();
                        genericObject9.setObject(uploadRequest);
                        frame.push(genericObject9);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject10 = new GenericObject();
                        genericObject10.setObject(exception);
                        frame.push(genericObject10);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject11 = new GenericObject();
                        genericObject11.setObject(error);
                        frame.push(genericObject11);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1776490250: {
                    try {
                        GenericObject genericObject12 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject12);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject13 = new GenericObject();
                        genericObject13.setObject(exception);
                        frame.push(genericObject13);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject14 = new GenericObject();
                        genericObject14.setObject(error);
                        frame.push(genericObject14);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1214373518: {
                    try {
                        GenericObject genericObject15 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject15);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject16 = new GenericObject();
                        genericObject16.setObject(exception);
                        frame.push(genericObject16);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject17 = new GenericObject();
                        genericObject17.setObject(error);
                        frame.push(genericObject17);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 962030741: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object2 = ((UploadFileIn)object).getFilename();
                        GenericObject genericObject18 = new GenericObject();
                        genericObject18.setObject(object2);
                        frame.push(genericObject18);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject19 = new GenericObject();
                        genericObject19.setObject(exception);
                        frame.push(genericObject19);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject20 = new GenericObject();
                        genericObject20.setObject(error);
                        frame.push(genericObject20);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -383391607: {
                    try {
                        GenericObject genericObject21 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject21);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject22 = new GenericObject();
                        genericObject22.setObject(exception);
                        frame.push(genericObject22);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject23 = new GenericObject();
                        genericObject23.setObject(error);
                        frame.push(genericObject23);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1147658731: {
                    try {
                        GenericObject genericObject24 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject24);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject25 = new GenericObject();
                        genericObject25.setObject(exception);
                        frame.push(genericObject25);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject26 = new GenericObject();
                        genericObject26.setObject(error);
                        frame.push(genericObject26);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 263577932: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object3 = ((UploadFileIn)object).getType();
                        GenericObject genericObject27 = new GenericObject();
                        genericObject27.setObject(object3);
                        frame.push(genericObject27);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject28 = new GenericObject();
                        genericObject28.setObject(exception);
                        frame.push(genericObject28);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject29 = new GenericObject();
                        genericObject29.setObject(error);
                        frame.push(genericObject29);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -735352972: {
                    try {
                        CharSequence charSequence = (CharSequence)frame.pop().getObject();
                        boolean bl = StringUtils.isNotBlank(charSequence);
                        GenericObject genericObject30 = new GenericObject();
                        genericObject30.setBoolean(bl);
                        frame.push(genericObject30);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject31 = new GenericObject();
                        genericObject31.setObject(exception);
                        frame.push(genericObject31);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject32 = new GenericObject();
                        genericObject32.setObject(error);
                        frame.push(genericObject32);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -157856736: {
                    try {
                        GenericObject genericObject33 = frame.pop();
                        int n2 = genericObject33.toInt();
                        if (n2 == 0) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject34 = new GenericObject();
                        genericObject34.setObject(exception);
                        frame.push(genericObject34);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject35 = new GenericObject();
                        genericObject35.setObject(error);
                        frame.push(genericObject35);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 961287975: {
                    try {
                        StubObject stubObject = new StubObject("java.lang.StringBuilder");
                        GenericObject genericObject36 = new GenericObject();
                        genericObject36.setObject(stubObject);
                        frame.push(genericObject36);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject37 = new GenericObject();
                        genericObject37.setObject(exception);
                        frame.push(genericObject37);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject38 = new GenericObject();
                        genericObject38.setObject(error);
                        frame.push(genericObject38);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -254552370: {
                    try {
                        GenericObject genericObject39 = frame.peek();
                        frame.push(genericObject39);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject40 = new GenericObject();
                        genericObject40.setObject(exception);
                        frame.push(genericObject40);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject41 = new GenericObject();
                        genericObject41.setObject(error);
                        frame.push(genericObject41);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 324623719: {
                    try {
                        GenericObject genericObject42 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject42);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject43 = new GenericObject();
                        genericObject43.setObject(exception);
                        frame.push(genericObject43);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject44 = new GenericObject();
                        genericObject44.setObject(error);
                        frame.push(genericObject44);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 203227428: {
                    try {
                        Object object = frame.pop().getObject();
                        String string = String.valueOf(object);
                        GenericObject genericObject45 = new GenericObject();
                        genericObject45.setObject(string);
                        frame.push(genericObject45);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject46 = new GenericObject();
                        genericObject46.setObject(exception);
                        frame.push(genericObject46);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject47 = new GenericObject();
                        genericObject47.setObject(error);
                        frame.push(genericObject47);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 200622391: {
                    try {
                        Object object = frame.pop().getObject();
                        StringBuilder stringBuilder = new StringBuilder((String)object);
                        frame.pop();
                        frame.pop();
                        GenericObject genericObject48 = new GenericObject();
                        genericObject48.setObject(stringBuilder);
                        frame.push(genericObject48);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject49 = new GenericObject();
                        genericObject49.setObject(exception);
                        frame.push(genericObject49);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject50 = new GenericObject();
                        genericObject50.setObject(error);
                        frame.push(genericObject50);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -153925247: {
                    try {
                        GenericObject genericObject51 = new GenericObject();
                        genericObject51.setString("Lg==");
                        frame.push(genericObject51);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject52 = new GenericObject();
                        genericObject52.setObject(exception);
                        frame.push(genericObject52);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject53 = new GenericObject();
                        genericObject53.setObject(error);
                        frame.push(genericObject53);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1726283895: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object4 = frame.pop().getObject();
                        Object object5 = ((StringBuilder)object4).append((String)object);
                        GenericObject genericObject54 = new GenericObject();
                        genericObject54.setObject(object5);
                        frame.push(genericObject54);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject55 = new GenericObject();
                        genericObject55.setObject(exception);
                        frame.push(genericObject55);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject56 = new GenericObject();
                        genericObject56.setObject(error);
                        frame.push(genericObject56);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1829724809: {
                    try {
                        GenericObject genericObject57 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject57);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject58 = new GenericObject();
                        genericObject58.setObject(exception);
                        frame.push(genericObject58);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject59 = new GenericObject();
                        genericObject59.setObject(error);
                        frame.push(genericObject59);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -897100766: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object6 = ((UploadFileIn)object).getType();
                        GenericObject genericObject60 = new GenericObject();
                        genericObject60.setObject(object6);
                        frame.push(genericObject60);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject61 = new GenericObject();
                        genericObject61.setObject(exception);
                        frame.push(genericObject61);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject62 = new GenericObject();
                        genericObject62.setObject(error);
                        frame.push(genericObject62);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 322110966: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object7 = frame.pop().getObject();
                        Object object8 = ((StringBuilder)object7).append((String)object);
                        GenericObject genericObject63 = new GenericObject();
                        genericObject63.setObject(object8);
                        frame.push(genericObject63);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject64 = new GenericObject();
                        genericObject64.setObject(exception);
                        frame.push(genericObject64);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject65 = new GenericObject();
                        genericObject65.setObject(error);
                        frame.push(genericObject65);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1265443820: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object9 = ((StringBuilder)object).toString();
                        GenericObject genericObject66 = new GenericObject();
                        genericObject66.setObject(object9);
                        frame.push(genericObject66);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject67 = new GenericObject();
                        genericObject67.setObject(exception);
                        frame.push(genericObject67);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject68 = new GenericObject();
                        genericObject68.setObject(error);
                        frame.push(genericObject68);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -162326348: {
                    try {
                        GenericObject genericObject69 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject69);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject70 = new GenericObject();
                        genericObject70.setObject(exception);
                        frame.push(genericObject70);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject71 = new GenericObject();
                        genericObject71.setObject(error);
                        frame.push(genericObject71);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -582273606: {
                    try {
                        GenericObject genericObject72 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject72);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject73 = new GenericObject();
                        genericObject73.setObject(exception);
                        frame.push(genericObject73);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject74 = new GenericObject();
                        genericObject74.setObject(error);
                        frame.push(genericObject74);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -249416546: {
                    try {
                        GenericObject genericObject75 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject75);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject76 = new GenericObject();
                        genericObject76.setObject(exception);
                        frame.push(genericObject76);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject77 = new GenericObject();
                        genericObject77.setObject(error);
                        frame.push(genericObject77);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1507734341: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object10 = frame.pop().getObject();
                        ((UploadRequest)object10).setFilename((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject78 = new GenericObject();
                        genericObject78.setObject(exception);
                        frame.push(genericObject78);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject79 = new GenericObject();
                        genericObject79.setObject(error);
                        frame.push(genericObject79);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1593178730: {
                    try {
                        GenericObject genericObject80 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject80);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject81 = new GenericObject();
                        genericObject81.setObject(exception);
                        frame.push(genericObject81);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject82 = new GenericObject();
                        genericObject82.setObject(error);
                        frame.push(genericObject82);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 381682996: {
                    try {
                        GenericObject genericObject83 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject83);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject84 = new GenericObject();
                        genericObject84.setObject(exception);
                        frame.push(genericObject84);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject85 = new GenericObject();
                        genericObject85.setObject(error);
                        frame.push(genericObject85);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1483027499: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object11 = ((UploadFileIn)object).getTraceno();
                        GenericObject genericObject86 = new GenericObject();
                        genericObject86.setObject(object11);
                        frame.push(genericObject86);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject87 = new GenericObject();
                        genericObject87.setObject(exception);
                        frame.push(genericObject87);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject88 = new GenericObject();
                        genericObject88.setObject(error);
                        frame.push(genericObject88);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -265923267: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object12 = frame.pop().getObject();
                        ((UploadRequest)object12).setTraceno((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject89 = new GenericObject();
                        genericObject89.setObject(exception);
                        frame.push(genericObject89);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject90 = new GenericObject();
                        genericObject90.setObject(error);
                        frame.push(genericObject90);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1540588133: {
                    try {
                        GenericObject genericObject91 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject91);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject92 = new GenericObject();
                        genericObject92.setObject(exception);
                        frame.push(genericObject92);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject93 = new GenericObject();
                        genericObject93.setObject(error);
                        frame.push(genericObject93);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1203816443: {
                    try {
                        GenericObject genericObject94 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject94);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject95 = new GenericObject();
                        genericObject95.setObject(exception);
                        frame.push(genericObject95);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject96 = new GenericObject();
                        genericObject96.setObject(error);
                        frame.push(genericObject96);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -769483231: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object13 = ((UploadFileIn)object).getFilegroup();
                        GenericObject genericObject97 = new GenericObject();
                        genericObject97.setObject(object13);
                        frame.push(genericObject97);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject98 = new GenericObject();
                        genericObject98.setObject(exception);
                        frame.push(genericObject98);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject99 = new GenericObject();
                        genericObject99.setObject(error);
                        frame.push(genericObject99);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1380292642: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object14 = frame.pop().getObject();
                        ((UploadRequest)object14).setGroup((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject100 = new GenericObject();
                        genericObject100.setObject(exception);
                        frame.push(genericObject100);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject101 = new GenericObject();
                        genericObject101.setObject(error);
                        frame.push(genericObject101);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1839160604: {
                    try {
                        GenericObject genericObject102 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject102);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject103 = new GenericObject();
                        genericObject103.setObject(exception);
                        frame.push(genericObject103);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject104 = new GenericObject();
                        genericObject104.setObject(error);
                        frame.push(genericObject104);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1368887232: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object15 = ((UploadFileIn)object).getToken();
                        GenericObject genericObject105 = new GenericObject();
                        genericObject105.setObject(object15);
                        frame.push(genericObject105);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject106 = new GenericObject();
                        genericObject106.setObject(exception);
                        frame.push(genericObject106);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject107 = new GenericObject();
                        genericObject107.setObject(error);
                        frame.push(genericObject107);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -375879494: {
                    try {
                        CharSequence charSequence = (CharSequence)frame.pop().getObject();
                        boolean bl = StringUtils.isNotBlank(charSequence);
                        GenericObject genericObject108 = new GenericObject();
                        genericObject108.setBoolean(bl);
                        frame.push(genericObject108);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject109 = new GenericObject();
                        genericObject109.setObject(exception);
                        frame.push(genericObject109);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject110 = new GenericObject();
                        genericObject110.setObject(error);
                        frame.push(genericObject110);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 633951908: {
                    try {
                        GenericObject genericObject111 = frame.pop();
                        int n3 = genericObject111.toInt();
                        if (n3 == 0) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject112 = new GenericObject();
                        genericObject112.setObject(exception);
                        frame.push(genericObject112);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject113 = new GenericObject();
                        genericObject113.setObject(error);
                        frame.push(genericObject113);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 827645023: {
                    try {
                        GenericObject genericObject114 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject114);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject115 = new GenericObject();
                        genericObject115.setObject(exception);
                        frame.push(genericObject115);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject116 = new GenericObject();
                        genericObject116.setObject(error);
                        frame.push(genericObject116);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1272212949: {
                    try {
                        GenericObject genericObject117 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject117);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject118 = new GenericObject();
                        genericObject118.setObject(exception);
                        frame.push(genericObject118);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject119 = new GenericObject();
                        genericObject119.setObject(error);
                        frame.push(genericObject119);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1463318963: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object16 = ((UploadFileIn)object).getToken();
                        GenericObject genericObject120 = new GenericObject();
                        genericObject120.setObject(object16);
                        frame.push(genericObject120);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject121 = new GenericObject();
                        genericObject121.setObject(exception);
                        frame.push(genericObject121);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject122 = new GenericObject();
                        genericObject122.setObject(error);
                        frame.push(genericObject122);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 782585342: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object17 = frame.pop().getObject();
                        ((UploadRequest)object17).setToken((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject123 = new GenericObject();
                        genericObject123.setObject(exception);
                        frame.push(genericObject123);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject124 = new GenericObject();
                        genericObject124.setObject(error);
                        frame.push(genericObject124);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1380855847: {
                    try {
                        n = nArray[n + 1];
                    }
                    catch (Exception exception) {
                        GenericObject genericObject125 = new GenericObject();
                        genericObject125.setObject(exception);
                        frame.push(genericObject125);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject126 = new GenericObject();
                        genericObject126.setObject(error);
                        frame.push(genericObject126);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1437612101: {
                    try {
                        GenericObject genericObject127 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject127);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject128 = new GenericObject();
                        genericObject128.setObject(exception);
                        frame.push(genericObject128);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject129 = new GenericObject();
                        genericObject129.setObject(error);
                        frame.push(genericObject129);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1546540548: {
                    try {
                        GenericObject genericObject130 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject130);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject131 = new GenericObject();
                        genericObject131.setObject(exception);
                        frame.push(genericObject131);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject132 = new GenericObject();
                        genericObject132.setObject(error);
                        frame.push(genericObject132);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 288993311: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object18 = ((OpenApiServiceImpl)object).getCacheToken();
                        GenericObject genericObject133 = new GenericObject();
                        genericObject133.setObject(object18);
                        frame.push(genericObject133);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject134 = new GenericObject();
                        genericObject134.setObject(exception);
                        frame.push(genericObject134);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject135 = new GenericObject();
                        genericObject135.setObject(error);
                        frame.push(genericObject135);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 207052842: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object19 = frame.pop().getObject();
                        ((UploadRequest)object19).setToken((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject136 = new GenericObject();
                        genericObject136.setObject(exception);
                        frame.push(genericObject136);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject137 = new GenericObject();
                        genericObject137.setObject(error);
                        frame.push(genericObject137);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -165355271: {
                    try {
                        GenericObject genericObject138 = new GenericObject();
                        genericObject138.setObject(null);
                        frame.push(genericObject138);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject139 = new GenericObject();
                        genericObject139.setObject(exception);
                        frame.push(genericObject139);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject140 = new GenericObject();
                        genericObject140.setObject(error);
                        frame.push(genericObject140);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 169952937: {
                    try {
                        GenericObject genericObject141 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject141);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject142 = new GenericObject();
                        genericObject142.setObject(exception);
                        frame.push(genericObject142);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject143 = new GenericObject();
                        genericObject143.setObject(error);
                        frame.push(genericObject143);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1174932581: {
                    try {
                        GenericObject genericObject144 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject144);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject145 = new GenericObject();
                        genericObject145.setObject(exception);
                        frame.push(genericObject145);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject146 = new GenericObject();
                        genericObject146.setObject(error);
                        frame.push(genericObject146);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1026731275: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object20 = ((UploadFileIn)object).getFileid();
                        GenericObject genericObject147 = new GenericObject();
                        genericObject147.setObject(object20);
                        frame.push(genericObject147);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject148 = new GenericObject();
                        genericObject148.setObject(exception);
                        frame.push(genericObject148);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject149 = new GenericObject();
                        genericObject149.setObject(error);
                        frame.push(genericObject149);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1273671215: {
                    try {
                        CharSequence charSequence = (CharSequence)frame.pop().getObject();
                        boolean bl = StringUtils.isBlank(charSequence);
                        GenericObject genericObject150 = new GenericObject();
                        genericObject150.setBoolean(bl);
                        frame.push(genericObject150);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject151 = new GenericObject();
                        genericObject151.setObject(exception);
                        frame.push(genericObject151);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject152 = new GenericObject();
                        genericObject152.setObject(error);
                        frame.push(genericObject152);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1622066804: {
                    try {
                        GenericObject genericObject153 = frame.pop();
                        int n4 = genericObject153.toInt();
                        if (n4 == 0) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject154 = new GenericObject();
                        genericObject154.setObject(exception);
                        frame.push(genericObject154);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject155 = new GenericObject();
                        genericObject155.setObject(error);
                        frame.push(genericObject155);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1838141727: {
                    try {
                        GenericObject genericObject156 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject156);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject157 = new GenericObject();
                        genericObject157.setObject(exception);
                        frame.push(genericObject157);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject158 = new GenericObject();
                        genericObject158.setObject(error);
                        frame.push(genericObject158);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1273652042: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object21 = ((UploadFileIn)object).getFile();
                        GenericObject genericObject159 = new GenericObject();
                        genericObject159.setObject(object21);
                        frame.push(genericObject159);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject160 = new GenericObject();
                        genericObject160.setObject(exception);
                        frame.push(genericObject160);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject161 = new GenericObject();
                        genericObject161.setObject(error);
                        frame.push(genericObject161);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1732134250: {
                    try {
                        GenericObject genericObject162 = frame.pop();
                        int n5 = genericObject162.arrayLength();
                        GenericObject genericObject163 = new GenericObject();
                        genericObject163.setInt(n5);
                        frame.push(genericObject163);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject164 = new GenericObject();
                        genericObject164.setObject(exception);
                        frame.push(genericObject164);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject165 = new GenericObject();
                        genericObject165.setObject(error);
                        frame.push(genericObject165);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 843970177: {
                    try {
                        int n6 = frame.pop().toInt();
                        GenericObject genericObject166 = new GenericObject();
                        genericObject166.setInt(n6);
                        frame.setLocal(nArray[n + 1], genericObject166);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject167 = new GenericObject();
                        genericObject167.setObject(exception);
                        frame.push(genericObject167);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject168 = new GenericObject();
                        genericObject168.setObject(error);
                        frame.push(genericObject168);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -721653069: {
                    try {
                        GenericObject genericObject169 = new GenericObject();
                        genericObject169.setInt(0);
                        frame.push(genericObject169);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject170 = new GenericObject();
                        genericObject170.setObject(exception);
                        frame.push(genericObject170);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject171 = new GenericObject();
                        genericObject171.setObject(error);
                        frame.push(genericObject171);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1225091422: {
                    try {
                        int n7 = frame.pop().toInt();
                        GenericObject genericObject172 = new GenericObject();
                        genericObject172.setInt(n7);
                        frame.setLocal(nArray[n + 1], genericObject172);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject173 = new GenericObject();
                        genericObject173.setObject(exception);
                        frame.push(genericObject173);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject174 = new GenericObject();
                        genericObject174.setObject(error);
                        frame.push(genericObject174);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 554926008: {
                    try {
                        GenericObject genericObject175 = new GenericObject();
                        genericObject175.setString("");
                        frame.push(genericObject175);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject176 = new GenericObject();
                        genericObject176.setObject(exception);
                        frame.push(genericObject176);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject177 = new GenericObject();
                        genericObject177.setObject(error);
                        frame.push(genericObject177);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1784820994: {
                    try {
                        GenericObject genericObject178 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject178);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject179 = new GenericObject();
                        genericObject179.setObject(exception);
                        frame.push(genericObject179);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject180 = new GenericObject();
                        genericObject180.setObject(error);
                        frame.push(genericObject180);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 698537938: {
                    try {
                        n = nArray[n + 1];
                    }
                    catch (Exception exception) {
                        GenericObject genericObject181 = new GenericObject();
                        genericObject181.setObject(exception);
                        frame.push(genericObject181);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject182 = new GenericObject();
                        genericObject182.setObject(error);
                        frame.push(genericObject182);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1294946382: {
                    try {
                        GenericObject genericObject183 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject183);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject184 = new GenericObject();
                        genericObject184.setObject(exception);
                        frame.push(genericObject184);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject185 = new GenericObject();
                        genericObject185.setObject(error);
                        frame.push(genericObject185);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1349885951: {
                    try {
                        StubObject stubObject = new StubObject("java.lang.StringBuilder");
                        GenericObject genericObject186 = new GenericObject();
                        genericObject186.setObject(stubObject);
                        frame.push(genericObject186);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject187 = new GenericObject();
                        genericObject187.setObject(exception);
                        frame.push(genericObject187);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject188 = new GenericObject();
                        genericObject188.setObject(error);
                        frame.push(genericObject188);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1738416284: {
                    try {
                        GenericObject genericObject189 = frame.peek();
                        frame.push(genericObject189);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject190 = new GenericObject();
                        genericObject190.setObject(exception);
                        frame.push(genericObject190);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject191 = new GenericObject();
                        genericObject191.setObject(error);
                        frame.push(genericObject191);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -81906696: {
                    try {
                        GenericObject genericObject192 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject192);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject193 = new GenericObject();
                        genericObject193.setObject(exception);
                        frame.push(genericObject193);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject194 = new GenericObject();
                        genericObject194.setObject(error);
                        frame.push(genericObject194);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1711034401: {
                    try {
                        int n8 = frame.pop().getInt();
                        String string = String.valueOf(n8);
                        GenericObject genericObject195 = new GenericObject();
                        genericObject195.setObject(string);
                        frame.push(genericObject195);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject196 = new GenericObject();
                        genericObject196.setObject(exception);
                        frame.push(genericObject196);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject197 = new GenericObject();
                        genericObject197.setObject(error);
                        frame.push(genericObject197);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1839928074: {
                    try {
                        Object object = frame.pop().getObject();
                        StringBuilder stringBuilder = new StringBuilder((String)object);
                        frame.pop();
                        frame.pop();
                        GenericObject genericObject198 = new GenericObject();
                        genericObject198.setObject(stringBuilder);
                        frame.push(genericObject198);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject199 = new GenericObject();
                        genericObject199.setObject(exception);
                        frame.push(genericObject199);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject200 = new GenericObject();
                        genericObject200.setObject(error);
                        frame.push(genericObject200);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1052587772: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object22 = ((StringBuilder)object).toString();
                        GenericObject genericObject201 = new GenericObject();
                        genericObject201.setObject(object22);
                        frame.push(genericObject201);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject202 = new GenericObject();
                        genericObject202.setObject(exception);
                        frame.push(genericObject202);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject203 = new GenericObject();
                        genericObject203.setObject(error);
                        frame.push(genericObject203);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -578246134: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object23 = frame.pop().getObject();
                        ((UploadRequest)object23).setOffset((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject204 = new GenericObject();
                        genericObject204.setObject(exception);
                        frame.push(genericObject204);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject205 = new GenericObject();
                        genericObject205.setObject(error);
                        frame.push(genericObject205);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -378384520: {
                    try {
                        GenericObject genericObject206 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject206);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject207 = new GenericObject();
                        genericObject207.setObject(exception);
                        frame.push(genericObject207);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject208 = new GenericObject();
                        genericObject208.setObject(error);
                        frame.push(genericObject208);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -78865180: {
                    try {
                        GenericObject genericObject209 = frame.pop();
                        int n9 = genericObject209.toInt();
                        if (n9 == 0) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject210 = new GenericObject();
                        genericObject210.setObject(exception);
                        frame.push(genericObject210);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject211 = new GenericObject();
                        genericObject211.setObject(error);
                        frame.push(genericObject211);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1237712476: {
                    try {
                        GenericObject genericObject212 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject212);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject213 = new GenericObject();
                        genericObject213.setObject(exception);
                        frame.push(genericObject213);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject214 = new GenericObject();
                        genericObject214.setObject(error);
                        frame.push(genericObject214);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1608349299: {
                    try {
                        GenericObject genericObject215 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject215);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject216 = new GenericObject();
                        genericObject216.setObject(exception);
                        frame.push(genericObject216);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject217 = new GenericObject();
                        genericObject217.setObject(error);
                        frame.push(genericObject217);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 362961434: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object24 = frame.pop().getObject();
                        ((UploadRequest)object24).setFileid((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject218 = new GenericObject();
                        genericObject218.setObject(exception);
                        frame.push(genericObject218);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject219 = new GenericObject();
                        genericObject219.setObject(error);
                        frame.push(genericObject219);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -250509463: {
                    try {
                        GenericObject genericObject220 = new GenericObject();
                        genericObject220.setObject(null);
                        frame.push(genericObject220);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject221 = new GenericObject();
                        genericObject221.setObject(exception);
                        frame.push(genericObject221);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject222 = new GenericObject();
                        genericObject222.setObject(error);
                        frame.push(genericObject222);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1996330798: {
                    try {
                        GenericObject genericObject223 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject223);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject224 = new GenericObject();
                        genericObject224.setObject(exception);
                        frame.push(genericObject224);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject225 = new GenericObject();
                        genericObject225.setObject(error);
                        frame.push(genericObject225);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1671220902: {
                    try {
                        GenericObject genericObject226 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject226);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject227 = new GenericObject();
                        genericObject227.setObject(exception);
                        frame.push(genericObject227);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject228 = new GenericObject();
                        genericObject228.setObject(error);
                        frame.push(genericObject228);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1989078357: {
                    try {
                        GenericObject genericObject229 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject229);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject230 = new GenericObject();
                        genericObject230.setObject(exception);
                        frame.push(genericObject230);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject231 = new GenericObject();
                        genericObject231.setObject(error);
                        frame.push(genericObject231);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1712825881: {
                    try {
                        GenericObject genericObject232 = frame.pop();
                        GenericObject genericObject233 = new GenericObject();
                        genericObject233.setObject(((OpenApiServiceImpl)genericObject232.getObject()).config);
                        frame.push(genericObject233);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject234 = new GenericObject();
                        genericObject234.setObject(exception);
                        frame.push(genericObject234);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject235 = new GenericObject();
                        genericObject235.setObject(error);
                        frame.push(genericObject235);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 829073625: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object25 = ((EntAppConfig)object).getUpdatasize();
                        GenericObject genericObject236 = new GenericObject();
                        genericObject236.setObject(object25);
                        frame.push(genericObject236);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject237 = new GenericObject();
                        genericObject237.setObject(exception);
                        frame.push(genericObject237);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject238 = new GenericObject();
                        genericObject238.setObject(error);
                        frame.push(genericObject238);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -584521331: {
                    try {
                        Object object = frame.pop().getObject();
                        int n10 = (Integer)object;
                        GenericObject genericObject239 = new GenericObject();
                        genericObject239.setInt(n10);
                        frame.push(genericObject239);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject240 = new GenericObject();
                        genericObject240.setObject(exception);
                        frame.push(genericObject240);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject241 = new GenericObject();
                        genericObject241.setObject(error);
                        frame.push(genericObject241);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 2043248015: {
                    try {
                        GenericObject genericObject242 = frame.pop();
                        GenericObject genericObject243 = frame.pop();
                        GenericObject genericObject244 = new GenericObject();
                        genericObject244.setInt(genericObject243.getInt() - genericObject242.getInt());
                        frame.push(genericObject244);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject245 = new GenericObject();
                        genericObject245.setObject(exception);
                        frame.push(genericObject245);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject246 = new GenericObject();
                        genericObject246.setObject(error);
                        frame.push(genericObject246);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -846773457: {
                    try {
                        GenericObject genericObject247 = frame.pop();
                        int n11 = genericObject247.toInt();
                        if (n11 <= 0) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject248 = new GenericObject();
                        genericObject248.setObject(exception);
                        frame.push(genericObject248);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject249 = new GenericObject();
                        genericObject249.setObject(error);
                        frame.push(genericObject249);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 422378091: {
                    try {
                        GenericObject genericObject250 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject250);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject251 = new GenericObject();
                        genericObject251.setObject(exception);
                        frame.push(genericObject251);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject252 = new GenericObject();
                        genericObject252.setObject(error);
                        frame.push(genericObject252);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1555556547: {
                    try {
                        GenericObject genericObject253 = frame.pop();
                        GenericObject genericObject254 = new GenericObject();
                        genericObject254.setObject(((OpenApiServiceImpl)genericObject253.getObject()).config);
                        frame.push(genericObject254);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject255 = new GenericObject();
                        genericObject255.setObject(exception);
                        frame.push(genericObject255);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject256 = new GenericObject();
                        genericObject256.setObject(error);
                        frame.push(genericObject256);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 179029288: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object26 = ((EntAppConfig)object).getUpdatasize();
                        GenericObject genericObject257 = new GenericObject();
                        genericObject257.setObject(object26);
                        frame.push(genericObject257);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject258 = new GenericObject();
                        genericObject258.setObject(exception);
                        frame.push(genericObject258);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject259 = new GenericObject();
                        genericObject259.setObject(error);
                        frame.push(genericObject259);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -572503567: {
                    try {
                        Object object = frame.pop().getObject();
                        int n12 = (Integer)object;
                        GenericObject genericObject260 = new GenericObject();
                        genericObject260.setInt(n12);
                        frame.push(genericObject260);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject261 = new GenericObject();
                        genericObject261.setObject(exception);
                        frame.push(genericObject261);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject262 = new GenericObject();
                        genericObject262.setObject(error);
                        frame.push(genericObject262);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1186730078: {
                    try {
                        int n13 = frame.pop().getInt();
                        int n14 = nArray[n + 1];
                        GenericObject genericObject263 = new GenericObject();
                        genericObject263.newarray(n13, n14);
                        frame.push(genericObject263);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject264 = new GenericObject();
                        genericObject264.setObject(exception);
                        frame.push(genericObject264);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject265 = new GenericObject();
                        genericObject265.setObject(error);
                        frame.push(genericObject265);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -695732093: {
                    try {
                        GenericObject genericObject266 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject266);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject267 = new GenericObject();
                        genericObject267.setObject(exception);
                        frame.push(genericObject267);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject268 = new GenericObject();
                        genericObject268.setObject(error);
                        frame.push(genericObject268);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -610860578: {
                    try {
                        GenericObject genericObject269 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject269);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject270 = new GenericObject();
                        genericObject270.setObject(exception);
                        frame.push(genericObject270);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject271 = new GenericObject();
                        genericObject271.setObject(error);
                        frame.push(genericObject271);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -499170743: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object27 = ((UploadFileIn)object).getFile();
                        GenericObject genericObject272 = new GenericObject();
                        genericObject272.setObject(object27);
                        frame.push(genericObject272);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject273 = new GenericObject();
                        genericObject273.setObject(exception);
                        frame.push(genericObject273);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject274 = new GenericObject();
                        genericObject274.setObject(error);
                        frame.push(genericObject274);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 907619763: {
                    try {
                        GenericObject genericObject275 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject275);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject276 = new GenericObject();
                        genericObject276.setObject(exception);
                        frame.push(genericObject276);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject277 = new GenericObject();
                        genericObject277.setObject(error);
                        frame.push(genericObject277);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 904097020: {
                    try {
                        GenericObject genericObject278 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject278);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject279 = new GenericObject();
                        genericObject279.setObject(exception);
                        frame.push(genericObject279);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject280 = new GenericObject();
                        genericObject280.setObject(error);
                        frame.push(genericObject280);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1004592013: {
                    try {
                        GenericObject genericObject281 = new GenericObject();
                        genericObject281.setInt(0);
                        frame.push(genericObject281);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject282 = new GenericObject();
                        genericObject282.setObject(exception);
                        frame.push(genericObject282);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject283 = new GenericObject();
                        genericObject283.setObject(error);
                        frame.push(genericObject283);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1027739243: {
                    try {
                        GenericObject genericObject284 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject284);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject285 = new GenericObject();
                        genericObject285.setObject(exception);
                        frame.push(genericObject285);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject286 = new GenericObject();
                        genericObject286.setObject(error);
                        frame.push(genericObject286);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1441208275: {
                    try {
                        GenericObject genericObject287 = frame.pop();
                        GenericObject genericObject288 = new GenericObject();
                        genericObject288.setObject(((OpenApiServiceImpl)genericObject287.getObject()).config);
                        frame.push(genericObject288);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject289 = new GenericObject();
                        genericObject289.setObject(exception);
                        frame.push(genericObject289);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject290 = new GenericObject();
                        genericObject290.setObject(error);
                        frame.push(genericObject290);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 726754288: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object28 = ((EntAppConfig)object).getUpdatasize();
                        GenericObject genericObject291 = new GenericObject();
                        genericObject291.setObject(object28);
                        frame.push(genericObject291);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject292 = new GenericObject();
                        genericObject292.setObject(exception);
                        frame.push(genericObject292);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject293 = new GenericObject();
                        genericObject293.setObject(error);
                        frame.push(genericObject293);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1959188109: {
                    try {
                        Object object = frame.pop().getObject();
                        int n15 = (Integer)object;
                        GenericObject genericObject294 = new GenericObject();
                        genericObject294.setInt(n15);
                        frame.push(genericObject294);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject295 = new GenericObject();
                        genericObject295.setObject(exception);
                        frame.push(genericObject295);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject296 = new GenericObject();
                        genericObject296.setObject(error);
                        frame.push(genericObject296);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1627605829: {
                    try {
                        int n16 = frame.pop().getInt();
                        int n17 = frame.pop().getInt();
                        Object object = frame.pop().getObject();
                        int n18 = frame.pop().getInt();
                        Object object29 = frame.pop().getObject();
                        System.arraycopy(object29, n18, object, n17, n16);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject297 = new GenericObject();
                        genericObject297.setObject(exception);
                        frame.push(genericObject297);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject298 = new GenericObject();
                        genericObject298.setObject(error);
                        frame.push(genericObject298);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1656526566: {
                    try {
                        GenericObject genericObject299 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject299);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject300 = new GenericObject();
                        genericObject300.setObject(exception);
                        frame.push(genericObject300);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject301 = new GenericObject();
                        genericObject301.setObject(error);
                        frame.push(genericObject301);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1007649040: {
                    try {
                        GenericObject genericObject302 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject302);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject303 = new GenericObject();
                        genericObject303.setObject(exception);
                        frame.push(genericObject303);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject304 = new GenericObject();
                        genericObject304.setObject(error);
                        frame.push(genericObject304);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 735804124: {
                    try {
                        GenericObject genericObject305 = frame.pop();
                        GenericObject genericObject306 = new GenericObject();
                        genericObject306.setObject(((OpenApiServiceImpl)genericObject305.getObject()).config);
                        frame.push(genericObject306);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject307 = new GenericObject();
                        genericObject307.setObject(exception);
                        frame.push(genericObject307);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject308 = new GenericObject();
                        genericObject308.setObject(error);
                        frame.push(genericObject308);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -786503809: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object30 = ((EntAppConfig)object).getUpdatasize();
                        GenericObject genericObject309 = new GenericObject();
                        genericObject309.setObject(object30);
                        frame.push(genericObject309);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject310 = new GenericObject();
                        genericObject310.setObject(exception);
                        frame.push(genericObject310);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject311 = new GenericObject();
                        genericObject311.setObject(error);
                        frame.push(genericObject311);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1350301799: {
                    try {
                        Object object = frame.pop().getObject();
                        int n19 = (Integer)object;
                        GenericObject genericObject312 = new GenericObject();
                        genericObject312.setInt(n19);
                        frame.push(genericObject312);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject313 = new GenericObject();
                        genericObject313.setObject(exception);
                        frame.push(genericObject313);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject314 = new GenericObject();
                        genericObject314.setObject(error);
                        frame.push(genericObject314);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1317440713: {
                    try {
                        GenericObject genericObject315 = frame.pop();
                        GenericObject genericObject316 = frame.pop();
                        GenericObject genericObject317 = new GenericObject();
                        genericObject317.setInt(genericObject316.getInt() - genericObject315.getInt());
                        frame.push(genericObject317);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject318 = new GenericObject();
                        genericObject318.setObject(exception);
                        frame.push(genericObject318);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject319 = new GenericObject();
                        genericObject319.setObject(error);
                        frame.push(genericObject319);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 508464001: {
                    try {
                        int n20 = frame.pop().toInt();
                        GenericObject genericObject320 = new GenericObject();
                        genericObject320.setInt(n20);
                        frame.setLocal(nArray[n + 1], genericObject320);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject321 = new GenericObject();
                        genericObject321.setObject(exception);
                        frame.push(genericObject321);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject322 = new GenericObject();
                        genericObject322.setObject(error);
                        frame.push(genericObject322);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1722421992: {
                    try {
                        GenericObject genericObject323 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject323);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject324 = new GenericObject();
                        genericObject324.setObject(exception);
                        frame.push(genericObject324);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject325 = new GenericObject();
                        genericObject325.setObject(error);
                        frame.push(genericObject325);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 277791767: {
                    try {
                        GenericObject genericObject326 = frame.pop();
                        GenericObject genericObject327 = new GenericObject();
                        genericObject327.setObject(((OpenApiServiceImpl)genericObject326.getObject()).config);
                        frame.push(genericObject327);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject328 = new GenericObject();
                        genericObject328.setObject(exception);
                        frame.push(genericObject328);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject329 = new GenericObject();
                        genericObject329.setObject(error);
                        frame.push(genericObject329);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1834800702: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object31 = ((EntAppConfig)object).getUpdatasize();
                        GenericObject genericObject330 = new GenericObject();
                        genericObject330.setObject(object31);
                        frame.push(genericObject330);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject331 = new GenericObject();
                        genericObject331.setObject(exception);
                        frame.push(genericObject331);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject332 = new GenericObject();
                        genericObject332.setObject(error);
                        frame.push(genericObject332);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -849610066: {
                    try {
                        Object object = frame.pop().getObject();
                        int n21 = (Integer)object;
                        GenericObject genericObject333 = new GenericObject();
                        genericObject333.setInt(n21);
                        frame.push(genericObject333);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject334 = new GenericObject();
                        genericObject334.setObject(exception);
                        frame.push(genericObject334);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject335 = new GenericObject();
                        genericObject335.setObject(error);
                        frame.push(genericObject335);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1606135295: {
                    try {
                        GenericObject genericObject336 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject336);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject337 = new GenericObject();
                        genericObject337.setObject(exception);
                        frame.push(genericObject337);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject338 = new GenericObject();
                        genericObject338.setObject(error);
                        frame.push(genericObject338);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1398629721: {
                    try {
                        GenericObject genericObject339 = frame.pop();
                        GenericObject genericObject340 = frame.pop();
                        GenericObject genericObject341 = new GenericObject();
                        genericObject341.setInt(genericObject340.getInt() + genericObject339.getInt());
                        frame.push(genericObject341);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject342 = new GenericObject();
                        genericObject342.setObject(exception);
                        frame.push(genericObject342);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject343 = new GenericObject();
                        genericObject343.setObject(error);
                        frame.push(genericObject343);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -515374602: {
                    try {
                        int n22 = frame.pop().toInt();
                        GenericObject genericObject344 = new GenericObject();
                        genericObject344.setInt(n22);
                        frame.setLocal(nArray[n + 1], genericObject344);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject345 = new GenericObject();
                        genericObject345.setObject(exception);
                        frame.push(genericObject345);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject346 = new GenericObject();
                        genericObject346.setObject(error);
                        frame.push(genericObject346);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1285781897: {
                    try {
                        n = nArray[n + 1];
                    }
                    catch (Exception exception) {
                        GenericObject genericObject347 = new GenericObject();
                        genericObject347.setObject(exception);
                        frame.push(genericObject347);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject348 = new GenericObject();
                        genericObject348.setObject(error);
                        frame.push(genericObject348);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1425448714: {
                    try {
                        GenericObject genericObject349 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject349);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject350 = new GenericObject();
                        genericObject350.setObject(exception);
                        frame.push(genericObject350);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject351 = new GenericObject();
                        genericObject351.setObject(error);
                        frame.push(genericObject351);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1130323037: {
                    try {
                        int n23 = frame.pop().getInt();
                        int n24 = nArray[n + 1];
                        GenericObject genericObject352 = new GenericObject();
                        genericObject352.newarray(n23, n24);
                        frame.push(genericObject352);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject353 = new GenericObject();
                        genericObject353.setObject(exception);
                        frame.push(genericObject353);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject354 = new GenericObject();
                        genericObject354.setObject(error);
                        frame.push(genericObject354);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1934244936: {
                    try {
                        GenericObject genericObject355 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject355);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject356 = new GenericObject();
                        genericObject356.setObject(exception);
                        frame.push(genericObject356);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject357 = new GenericObject();
                        genericObject357.setObject(error);
                        frame.push(genericObject357);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1985268053: {
                    try {
                        GenericObject genericObject358 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject358);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject359 = new GenericObject();
                        genericObject359.setObject(exception);
                        frame.push(genericObject359);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject360 = new GenericObject();
                        genericObject360.setObject(error);
                        frame.push(genericObject360);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 2133763513: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object32 = ((UploadFileIn)object).getFile();
                        GenericObject genericObject361 = new GenericObject();
                        genericObject361.setObject(object32);
                        frame.push(genericObject361);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject362 = new GenericObject();
                        genericObject362.setObject(exception);
                        frame.push(genericObject362);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject363 = new GenericObject();
                        genericObject363.setObject(error);
                        frame.push(genericObject363);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 563665022: {
                    try {
                        GenericObject genericObject364 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject364);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject365 = new GenericObject();
                        genericObject365.setObject(exception);
                        frame.push(genericObject365);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject366 = new GenericObject();
                        genericObject366.setObject(error);
                        frame.push(genericObject366);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 76139221: {
                    try {
                        GenericObject genericObject367 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject367);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject368 = new GenericObject();
                        genericObject368.setObject(exception);
                        frame.push(genericObject368);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject369 = new GenericObject();
                        genericObject369.setObject(error);
                        frame.push(genericObject369);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -2106754349: {
                    try {
                        GenericObject genericObject370 = new GenericObject();
                        genericObject370.setInt(0);
                        frame.push(genericObject370);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject371 = new GenericObject();
                        genericObject371.setObject(exception);
                        frame.push(genericObject371);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject372 = new GenericObject();
                        genericObject372.setObject(error);
                        frame.push(genericObject372);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1048875568: {
                    try {
                        GenericObject genericObject373 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject373);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject374 = new GenericObject();
                        genericObject374.setObject(exception);
                        frame.push(genericObject374);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject375 = new GenericObject();
                        genericObject375.setObject(error);
                        frame.push(genericObject375);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1868785338: {
                    try {
                        int n25 = frame.pop().getInt();
                        int n26 = frame.pop().getInt();
                        Object object = frame.pop().getObject();
                        int n27 = frame.pop().getInt();
                        Object object33 = frame.pop().getObject();
                        System.arraycopy(object33, n27, object, n26, n25);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject376 = new GenericObject();
                        genericObject376.setObject(exception);
                        frame.push(genericObject376);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject377 = new GenericObject();
                        genericObject377.setObject(error);
                        frame.push(genericObject377);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 322348004: {
                    try {
                        GenericObject genericObject378 = new GenericObject();
                        genericObject378.setInt(-1);
                        frame.push(genericObject378);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject379 = new GenericObject();
                        genericObject379.setObject(exception);
                        frame.push(genericObject379);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject380 = new GenericObject();
                        genericObject380.setObject(error);
                        frame.push(genericObject380);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1560854501: {
                    try {
                        int n28 = frame.pop().toInt();
                        GenericObject genericObject381 = new GenericObject();
                        genericObject381.setInt(n28);
                        frame.setLocal(nArray[n + 1], genericObject381);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject382 = new GenericObject();
                        genericObject382.setObject(exception);
                        frame.push(genericObject382);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject383 = new GenericObject();
                        genericObject383.setObject(error);
                        frame.push(genericObject383);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -848690139: {
                    try {
                        GenericObject genericObject384 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject384);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject385 = new GenericObject();
                        genericObject385.setObject(exception);
                        frame.push(genericObject385);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject386 = new GenericObject();
                        genericObject386.setObject(error);
                        frame.push(genericObject386);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 493362870: {
                    try {
                        GenericObject genericObject387 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject387);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject388 = new GenericObject();
                        genericObject388.setObject(exception);
                        frame.push(genericObject388);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject389 = new GenericObject();
                        genericObject389.setObject(error);
                        frame.push(genericObject389);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 538345908: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object34 = frame.pop().getObject();
                        ((UploadRequest)object34).setFile((byte[])object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject390 = new GenericObject();
                        genericObject390.setObject(exception);
                        frame.push(genericObject390);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject391 = new GenericObject();
                        genericObject391.setObject(error);
                        frame.push(genericObject391);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1151873909: {
                    try {
                        GenericObject genericObject392 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject392);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject393 = new GenericObject();
                        genericObject393.setObject(exception);
                        frame.push(genericObject393);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject394 = new GenericObject();
                        genericObject394.setObject(error);
                        frame.push(genericObject394);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -373241157: {
                    try {
                        GenericObject genericObject395 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject395);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject396 = new GenericObject();
                        genericObject396.setObject(exception);
                        frame.push(genericObject396);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject397 = new GenericObject();
                        genericObject397.setObject(error);
                        frame.push(genericObject397);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 914498270: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object35 = frame.pop().getObject();
                        Object object36 = ((OpenApiServiceImpl)object35).fileUpload((UploadRequest)object);
                        GenericObject genericObject398 = new GenericObject();
                        genericObject398.setObject(object36);
                        frame.push(genericObject398);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject399 = new GenericObject();
                        genericObject399.setObject(exception);
                        frame.push(genericObject399);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject400 = new GenericObject();
                        genericObject400.setObject(error);
                        frame.push(genericObject400);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -187489922: {
                    try {
                        GenericObject genericObject401 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject401);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject402 = new GenericObject();
                        genericObject402.setObject(exception);
                        frame.push(genericObject402);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject403 = new GenericObject();
                        genericObject403.setObject(error);
                        frame.push(genericObject403);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1503216748: {
                    try {
                        GenericObject genericObject404 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject404);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject405 = new GenericObject();
                        genericObject405.setObject(exception);
                        frame.push(genericObject405);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject406 = new GenericObject();
                        genericObject406.setObject(error);
                        frame.push(genericObject406);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 478550542: {
                    try {
                        GenericObject genericObject407 = frame.pop();
                        if (genericObject407.getObject() == null) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject408 = new GenericObject();
                        genericObject408.setObject(exception);
                        frame.push(genericObject408);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject409 = new GenericObject();
                        genericObject409.setObject(error);
                        frame.push(genericObject409);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1003220876: {
                    try {
                        GenericObject genericObject410 = new GenericObject();
                        genericObject410.setObject((Object)ErrorCode.E0000);
                        frame.push(genericObject410);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject411 = new GenericObject();
                        genericObject411.setObject(exception);
                        frame.push(genericObject411);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject412 = new GenericObject();
                        genericObject412.setObject(error);
                        frame.push(genericObject412);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -873775526: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object37 = ((ErrorCode)((Object)object)).getCode();
                        GenericObject genericObject413 = new GenericObject();
                        genericObject413.setObject(object37);
                        frame.push(genericObject413);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject414 = new GenericObject();
                        genericObject414.setObject(exception);
                        frame.push(genericObject414);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject415 = new GenericObject();
                        genericObject415.setObject(error);
                        frame.push(genericObject415);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 963963365: {
                    try {
                        GenericObject genericObject416 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject416);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject417 = new GenericObject();
                        genericObject417.setObject(exception);
                        frame.push(genericObject417);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject418 = new GenericObject();
                        genericObject418.setObject(error);
                        frame.push(genericObject418);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 834610096: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object38 = ((UploadFileOut)object).getResultcode();
                        GenericObject genericObject419 = new GenericObject();
                        genericObject419.setObject(object38);
                        frame.push(genericObject419);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject420 = new GenericObject();
                        genericObject420.setObject(exception);
                        frame.push(genericObject420);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject421 = new GenericObject();
                        genericObject421.setObject(error);
                        frame.push(genericObject421);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1710190739: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object39 = frame.pop().getObject();
                        boolean bl = ((String)object39).equals(object);
                        GenericObject genericObject422 = new GenericObject();
                        genericObject422.setBoolean(bl);
                        frame.push(genericObject422);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject423 = new GenericObject();
                        genericObject423.setObject(exception);
                        frame.push(genericObject423);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject424 = new GenericObject();
                        genericObject424.setObject(error);
                        frame.push(genericObject424);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1856550924: {
                    try {
                        GenericObject genericObject425 = frame.pop();
                        int n29 = genericObject425.toInt();
                        if (n29 == 0) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject426 = new GenericObject();
                        genericObject426.setObject(exception);
                        frame.push(genericObject426);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject427 = new GenericObject();
                        genericObject427.setObject(error);
                        frame.push(genericObject427);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 122715708: {
                    try {
                        GenericObject genericObject428 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject428);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject429 = new GenericObject();
                        genericObject429.setObject(exception);
                        frame.push(genericObject429);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject430 = new GenericObject();
                        genericObject430.setObject(error);
                        frame.push(genericObject430);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1046353388: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object40 = ((UploadFileOut)object).getFileid();
                        GenericObject genericObject431 = new GenericObject();
                        genericObject431.setObject(object40);
                        frame.push(genericObject431);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject432 = new GenericObject();
                        genericObject432.setObject(exception);
                        frame.push(genericObject432);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject433 = new GenericObject();
                        genericObject433.setObject(error);
                        frame.push(genericObject433);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 678671729: {
                    try {
                        GenericObject genericObject434 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject434);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject435 = new GenericObject();
                        genericObject435.setObject(exception);
                        frame.push(genericObject435);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject436 = new GenericObject();
                        genericObject436.setObject(error);
                        frame.push(genericObject436);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1614172287: {
                    try {
                        n = nArray[n + 1];
                    }
                    catch (Exception exception) {
                        GenericObject genericObject437 = new GenericObject();
                        genericObject437.setObject(exception);
                        frame.push(genericObject437);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject438 = new GenericObject();
                        genericObject438.setObject(error);
                        frame.push(genericObject438);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1092546433: {
                    try {
                        GenericObject genericObject439 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject439);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject440 = new GenericObject();
                        genericObject440.setObject(exception);
                        frame.push(genericObject440);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject441 = new GenericObject();
                        genericObject441.setObject(error);
                        frame.push(genericObject441);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1229873577: {
                    try {
                        GenericObject genericObject442 = frame.pop();
                        if (genericObject442.getObject() == null) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject443 = new GenericObject();
                        genericObject443.setObject(exception);
                        frame.push(genericObject443);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject444 = new GenericObject();
                        genericObject444.setObject(error);
                        frame.push(genericObject444);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 919160804: {
                    try {
                        GenericObject genericObject445 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject445);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject446 = new GenericObject();
                        genericObject446.setObject(exception);
                        frame.push(genericObject446);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject447 = new GenericObject();
                        genericObject447.setObject(error);
                        frame.push(genericObject447);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1502045672: {
                    try {
                        return (UploadFileOut)frame.pop().getObject();
                    }
                    catch (Exception exception) {
                        GenericObject genericObject448 = new GenericObject();
                        genericObject448.setObject(exception);
                        frame.push(genericObject448);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject449 = new GenericObject();
                        genericObject449.setObject(error);
                        frame.push(genericObject449);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                }
                case -2035474726: {
                    try {
                        GenericObject genericObject450 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject450);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject451 = new GenericObject();
                        genericObject451.setObject(exception);
                        frame.push(genericObject451);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject452 = new GenericObject();
                        genericObject452.setObject(error);
                        frame.push(genericObject452);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 2110787370: {
                    try {
                        GenericObject genericObject453 = frame.pop();
                        int n30 = genericObject453.toInt();
                        if (n30 > 0) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject454 = new GenericObject();
                        genericObject454.setObject(exception);
                        frame.push(genericObject454);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject455 = new GenericObject();
                        genericObject455.setObject(error);
                        frame.push(genericObject455);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1939958055: {
                    try {
                        n = nArray[n + 1];
                    }
                    catch (Exception exception) {
                        GenericObject genericObject456 = new GenericObject();
                        genericObject456.setObject(exception);
                        frame.push(genericObject456);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject457 = new GenericObject();
                        genericObject457.setObject(error);
                        frame.push(genericObject457);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 797100623: {
                    try {
                        GenericObject genericObject458 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject458);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject459 = new GenericObject();
                        genericObject459.setObject(exception);
                        frame.push(genericObject459);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject460 = new GenericObject();
                        genericObject460.setObject(error);
                        frame.push(genericObject460);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 118790409: {
                    try {
                        GenericObject genericObject461 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject461);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject462 = new GenericObject();
                        genericObject462.setObject(exception);
                        frame.push(genericObject462);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject463 = new GenericObject();
                        genericObject463.setObject(error);
                        frame.push(genericObject463);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1419069644: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object41 = ((UploadFileIn)object).getFileid();
                        GenericObject genericObject464 = new GenericObject();
                        genericObject464.setObject(object41);
                        frame.push(genericObject464);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject465 = new GenericObject();
                        genericObject465.setObject(exception);
                        frame.push(genericObject465);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject466 = new GenericObject();
                        genericObject466.setObject(error);
                        frame.push(genericObject466);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 657190109: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object42 = frame.pop().getObject();
                        ((UploadRequest)object42).setFileid((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject467 = new GenericObject();
                        genericObject467.setObject(exception);
                        frame.push(genericObject467);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject468 = new GenericObject();
                        genericObject468.setObject(error);
                        frame.push(genericObject468);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 577355698: {
                    try {
                        GenericObject genericObject469 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject469);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject470 = new GenericObject();
                        genericObject470.setObject(exception);
                        frame.push(genericObject470);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject471 = new GenericObject();
                        genericObject471.setObject(error);
                        frame.push(genericObject471);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1205269998: {
                    try {
                        GenericObject genericObject472 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject472);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject473 = new GenericObject();
                        genericObject473.setObject(exception);
                        frame.push(genericObject473);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject474 = new GenericObject();
                        genericObject474.setObject(error);
                        frame.push(genericObject474);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 2018112280: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object43 = ((UploadFileIn)object).getOffSett();
                        GenericObject genericObject475 = new GenericObject();
                        genericObject475.setObject(object43);
                        frame.push(genericObject475);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject476 = new GenericObject();
                        genericObject476.setObject(exception);
                        frame.push(genericObject476);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject477 = new GenericObject();
                        genericObject477.setObject(error);
                        frame.push(genericObject477);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1358950571: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object44 = frame.pop().getObject();
                        ((UploadRequest)object44).setOffset((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject478 = new GenericObject();
                        genericObject478.setObject(exception);
                        frame.push(genericObject478);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject479 = new GenericObject();
                        genericObject479.setObject(error);
                        frame.push(genericObject479);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1780819221: {
                    try {
                        GenericObject genericObject480 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject480);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject481 = new GenericObject();
                        genericObject481.setObject(exception);
                        frame.push(genericObject481);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject482 = new GenericObject();
                        genericObject482.setObject(error);
                        frame.push(genericObject482);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1093220576: {
                    try {
                        GenericObject genericObject483 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject483);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject484 = new GenericObject();
                        genericObject484.setObject(exception);
                        frame.push(genericObject484);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject485 = new GenericObject();
                        genericObject485.setObject(error);
                        frame.push(genericObject485);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 450150130: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object45 = ((UploadFileIn)object).getFile();
                        GenericObject genericObject486 = new GenericObject();
                        genericObject486.setObject(object45);
                        frame.push(genericObject486);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject487 = new GenericObject();
                        genericObject487.setObject(exception);
                        frame.push(genericObject487);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject488 = new GenericObject();
                        genericObject488.setObject(error);
                        frame.push(genericObject488);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 63302670: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object46 = frame.pop().getObject();
                        ((UploadRequest)object46).setFile((byte[])object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject489 = new GenericObject();
                        genericObject489.setObject(exception);
                        frame.push(genericObject489);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject490 = new GenericObject();
                        genericObject490.setObject(error);
                        frame.push(genericObject490);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -198962724: {
                    try {
                        GenericObject genericObject491 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject491);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject492 = new GenericObject();
                        genericObject492.setObject(exception);
                        frame.push(genericObject492);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject493 = new GenericObject();
                        genericObject493.setObject(error);
                        frame.push(genericObject493);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 566596264: {
                    try {
                        GenericObject genericObject494 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject494);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject495 = new GenericObject();
                        genericObject495.setObject(exception);
                        frame.push(genericObject495);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject496 = new GenericObject();
                        genericObject496.setObject(error);
                        frame.push(genericObject496);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1369221894: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object47 = frame.pop().getObject();
                        Object object48 = ((OpenApiServiceImpl)object47).fileUpload((UploadRequest)object);
                        GenericObject genericObject497 = new GenericObject();
                        genericObject497.setObject(object48);
                        frame.push(genericObject497);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject498 = new GenericObject();
                        genericObject498.setObject(exception);
                        frame.push(genericObject498);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject499 = new GenericObject();
                        genericObject499.setObject(error);
                        frame.push(genericObject499);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 924997758: {
                    try {
                        GenericObject genericObject500 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject500);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject501 = new GenericObject();
                        genericObject501.setObject(exception);
                        frame.push(genericObject501);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject502 = new GenericObject();
                        genericObject502.setObject(error);
                        frame.push(genericObject502);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -689243929: {
                    try {
                        GenericObject genericObject503 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject503);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject504 = new GenericObject();
                        genericObject504.setObject(exception);
                        frame.push(genericObject504);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject505 = new GenericObject();
                        genericObject505.setObject(error);
                        frame.push(genericObject505);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 2132868814: {
                    try {
                        GenericObject genericObject506 = frame.pop();
                        if (genericObject506.getObject() == null) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject507 = new GenericObject();
                        genericObject507.setObject(exception);
                        frame.push(genericObject507);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject508 = new GenericObject();
                        genericObject508.setObject(error);
                        frame.push(genericObject508);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 237431321: {
                    try {
                        GenericObject genericObject509 = new GenericObject();
                        genericObject509.setObject((Object)ErrorCode.E0000);
                        frame.push(genericObject509);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject510 = new GenericObject();
                        genericObject510.setObject(exception);
                        frame.push(genericObject510);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject511 = new GenericObject();
                        genericObject511.setObject(error);
                        frame.push(genericObject511);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 205465359: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object49 = ((ErrorCode)((Object)object)).getCode();
                        GenericObject genericObject512 = new GenericObject();
                        genericObject512.setObject(object49);
                        frame.push(genericObject512);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject513 = new GenericObject();
                        genericObject513.setObject(exception);
                        frame.push(genericObject513);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject514 = new GenericObject();
                        genericObject514.setObject(error);
                        frame.push(genericObject514);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1525226588: {
                    try {
                        GenericObject genericObject515 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject515);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject516 = new GenericObject();
                        genericObject516.setObject(exception);
                        frame.push(genericObject516);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject517 = new GenericObject();
                        genericObject517.setObject(error);
                        frame.push(genericObject517);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -526773752: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object50 = ((UploadFileOut)object).getResultcode();
                        GenericObject genericObject518 = new GenericObject();
                        genericObject518.setObject(object50);
                        frame.push(genericObject518);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject519 = new GenericObject();
                        genericObject519.setObject(exception);
                        frame.push(genericObject519);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject520 = new GenericObject();
                        genericObject520.setObject(error);
                        frame.push(genericObject520);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1829232705: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object51 = frame.pop().getObject();
                        boolean bl = ((String)object51).equals(object);
                        GenericObject genericObject521 = new GenericObject();
                        genericObject521.setBoolean(bl);
                        frame.push(genericObject521);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject522 = new GenericObject();
                        genericObject522.setObject(exception);
                        frame.push(genericObject522);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject523 = new GenericObject();
                        genericObject523.setObject(error);
                        frame.push(genericObject523);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 174462569: {
                    try {
                        GenericObject genericObject524 = frame.pop();
                        int n31 = genericObject524.toInt();
                        if (n31 == 0) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject525 = new GenericObject();
                        genericObject525.setObject(exception);
                        frame.push(genericObject525);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject526 = new GenericObject();
                        genericObject526.setObject(error);
                        frame.push(genericObject526);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1013963981: {
                    try {
                        GenericObject genericObject527 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject527);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject528 = new GenericObject();
                        genericObject528.setObject(exception);
                        frame.push(genericObject528);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject529 = new GenericObject();
                        genericObject529.setObject(error);
                        frame.push(genericObject529);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -204729856: {
                    try {
                        GenericObject genericObject530 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject530);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject531 = new GenericObject();
                        genericObject531.setObject(exception);
                        frame.push(genericObject531);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject532 = new GenericObject();
                        genericObject532.setObject(error);
                        frame.push(genericObject532);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1723481843: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object52 = ((UploadFileIn)object).getFilename();
                        GenericObject genericObject533 = new GenericObject();
                        genericObject533.setObject(object52);
                        frame.push(genericObject533);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject534 = new GenericObject();
                        genericObject534.setObject(exception);
                        frame.push(genericObject534);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject535 = new GenericObject();
                        genericObject535.setObject(error);
                        frame.push(genericObject535);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -205197066: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object53 = frame.pop().getObject();
                        ((UploadFileOut)object53).setFilename((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject536 = new GenericObject();
                        genericObject536.setObject(exception);
                        frame.push(genericObject536);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject537 = new GenericObject();
                        genericObject537.setObject(error);
                        frame.push(genericObject537);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1025550717: {
                    try {
                        GenericObject genericObject538 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject538);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject539 = new GenericObject();
                        genericObject539.setObject(exception);
                        frame.push(genericObject539);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject540 = new GenericObject();
                        genericObject540.setObject(error);
                        frame.push(genericObject540);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 191404223: {
                    try {
                        GenericObject genericObject541 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject541);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject542 = new GenericObject();
                        genericObject542.setObject(exception);
                        frame.push(genericObject542);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject543 = new GenericObject();
                        genericObject543.setObject(error);
                        frame.push(genericObject543);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1414434987: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object54 = ((UploadFileIn)object).getTraceno();
                        GenericObject genericObject544 = new GenericObject();
                        genericObject544.setObject(object54);
                        frame.push(genericObject544);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject545 = new GenericObject();
                        genericObject545.setObject(exception);
                        frame.push(genericObject545);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject546 = new GenericObject();
                        genericObject546.setObject(error);
                        frame.push(genericObject546);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 919969954: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object55 = frame.pop().getObject();
                        ((UploadFileOut)object55).setResourceId((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject547 = new GenericObject();
                        genericObject547.setObject(exception);
                        frame.push(genericObject547);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject548 = new GenericObject();
                        genericObject548.setObject(error);
                        frame.push(genericObject548);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 91835289: {
                    try {
                        GenericObject genericObject549 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject549);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject550 = new GenericObject();
                        genericObject550.setObject(exception);
                        frame.push(genericObject550);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject551 = new GenericObject();
                        genericObject551.setObject(error);
                        frame.push(genericObject551);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -315795449: {
                    try {
                        return (UploadFileOut)frame.pop().getObject();
                    }
                    catch (Exception exception) {
                        GenericObject genericObject552 = new GenericObject();
                        genericObject552.setObject(exception);
                        frame.push(genericObject552);
                        frame.setExpPc(n);
                        frame.setEx(exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject553 = new GenericObject();
                        genericObject553.setObject(error);
                        frame.push(genericObject553);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                }
                case 519333725: {
                    GenericObject genericObject554 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject554);
                    n += 2;
                    break;
                }
                case -1756546334: {
                    GenericObject genericObject555 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject555);
                    n += 2;
                    break;
                }
                case -265111666: {
                    GenericObject genericObject556 = frame.pop();
                    frame.empty();
                    frame.push(genericObject556);
                    genericObject556.throwException();
                    ++n;
                    break;
                }
                case -1008193793: {
                    GenericObject genericObject557 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject557);
                    n += 2;
                    break;
                }
                case 1688710613: {
                    StubObject stubObject = new StubObject("com.czb.sap.sdk.exception.SdkException");
                    GenericObject genericObject558 = new GenericObject();
                    genericObject558.setObject(stubObject);
                    frame.push(genericObject558);
                    ++n;
                    break;
                }
                case 136399096: {
                    GenericObject genericObject559 = frame.peek();
                    frame.push(genericObject559);
                    ++n;
                    break;
                }
                case 2118889788: {
                    GenericObject genericObject560 = new GenericObject();
                    genericObject560.setObject((Object)ErrorCode.E0014);
                    frame.push(genericObject560);
                    ++n;
                    break;
                }
                case -1443596779: {
                    GenericObject genericObject561 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject561);
                    n += 2;
                    break;
                }
                case -707195063: {
                    Object object = frame.pop().getObject();
                    Object object56 = frame.pop().getObject();
                    SdkException sdkException = new SdkException((ErrorCode)((Object)object56), (Throwable)object);
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject562 = new GenericObject();
                    genericObject562.setObject(sdkException);
                    frame.push(genericObject562);
                    ++n;
                    break;
                }
                case 593678452: {
                    GenericObject genericObject563 = frame.pop();
                    frame.empty();
                    frame.push(genericObject563);
                    genericObject563.throwException();
                    ++n;
                    break;
                }
                case 2057438257: {
                    int n32;
                    Exp[] expArray = new Exp[]{new Exp(0, 225, 284), new Exp(226, 283, 284), new Exp(0, 225, 289), new Exp(226, 283, 289)};
                    Throwable throwable = frame.getEx();
                    int[] nArray2 = new int[4];
                    for (int i = 0; i < 4; ++i) {
                        nArray2[i] = 0;
                    }
                    if (throwable instanceof SdkException) {
                        nArray2[0] = 1;
                    }
                    if (throwable instanceof SdkException) {
                        nArray2[1] = 1;
                    }
                    if (throwable instanceof Exception) {
                        nArray2[2] = 1;
                    }
                    if (throwable instanceof Exception) {
                        nArray2[3] = 1;
                    }
                    if ((n32 = frame.findCatchBlock(expArray, nArray2)) != -1) {
                        n = expArray[n32].handlerPc;
                        break;
                    }
                    if (throwable instanceof Exception) {
                        frame.throwException();
                        break;
                    }
                    frame.throwError();
                    break;
                }
            }
        }
    }

    private UploadFileOut fileUpload(UploadRequest request) {
        request.setAppid(this.config.getAppid());
        request.setOpenid(this.config.getOpenid());
        request.setSendtime(DateUtil.getSendTime());
        request.setTermianatype(TermianaType.SDK.getCode());
        request.setFileabstract("fileabstract");
        String signResource = request.signResource();
        String sign = this.securityService.signature(signResource, this.config.getAppkey());
        request.setSign(sign);
        if (this.config.getCfcafile() != null && this.config.getCfcafile().length > 1) {
            String cfcaSign = this.securityService.cfcaSignature(signResource, this.config.getCfcapwd(), this.config.getCfcafile());
            request.setCfcasign(cfcaSign);
        }
        URI url = URI.create(String.valueOf(this.config.getFileurl()) + "filev2/upload");
        log.debug("\u8bf7\u6c42\u5730\u5740:[{}],\u62a5\u6587[{}]", (Object)url.toASCIIString(), (Object)JSON.toJSONString((Object)request));
        String response = HttpClientUtil.sendPostFile(request, url, this.config);
        UploadFileOut out = (UploadFileOut)JSON.parseObject((String)response, UploadFileOut.class);
        if (out != null && ErrorCode.E0000.getCode().equals(out.getResultcode())) {
            this.checkUploadSign(out);
        }
        return out;
    }

    private void checkUploadSign(UploadFileOut out) {
        String hsign = this.securityService.signature(out.signResource(), this.config.getAppkey());
        if (!StringUtils.equals(hsign, out.getSign())) {
            log.error("\u672c\u5730\u7b7e\u540d[{}],\u8fd4\u56de\u7b7e\u540d[{}]\uff0c\u8fd4\u56de\u62a5\u6587[{}]", new Object[]{hsign, out.getSign(), JSON.toJSONString((Object)out)});
            throw new SdkException(ErrorCode.E0010);
        }
    }

    @Override
    public DownloadFileOut downloadFile(DownloadFileIn in) throws SdkException {
        DownloadReqeust request = new DownloadReqeust();
        request.setAppid(this.config.getAppid());
        request.setOpenid(this.config.getOpenid());
        request.setSendtime(DateUtil.getSendTime());
        request.setTermianatype(TermianaType.SDK.getCode());
        request.setFileid(in.getFileid());
        if (StringUtils.isNotBlank(in.getToken())) {
            request.setToken(in.getToken());
        } else {
            request.setToken(this.getCacheToken());
        }
        request.setTraceno(in.getTraceno());
        String signResource = request.signResource();
        log.debug("\u5f3a\u6c42\u7b7e\u540d\u539f\u7a9c[{}]", (Object)signResource);
        String sign = this.securityService.signature(signResource, this.config.getAppkey());
        request.setSign(sign);
        if (this.config.getCfcafile() != null && this.config.getCfcafile().length > 1) {
            String cfcaSign = this.securityService.cfcaSignature(signResource, this.config.getCfcapwd(), this.config.getCfcafile());
            request.setCfcasign(cfcaSign);
        }
        URI url = URI.create(String.valueOf(this.config.getFileurl()) + "filev2/download");
        String body = JSON.toJSONString((Object)request);
        log.debug("\u8bf7\u6c42\u5730\u5740:[{}],\u62a5\u6587[{}]", (Object)url.toASCIIString(), (Object)body);
        return HttpClientUtil.downloadFile(url, body, this.config);
    }

    @Override
    public MakeH5GetOut makeGetH5Url(String h5group, String traceno, Map<String, String> request) throws SdkException {
        MakeH5GetOut out = new MakeH5GetOut();
        RegisterTokenRequest in = new RegisterTokenRequest();
        in.setAppid(this.config.getAppid());
        if (request != null && request.size() > 0) {
            String jsonBody = JSON.toJSONString(request);
            String body = this.securityService.encrypt(jsonBody, this.config.getAppkey());
            in.setBody(body);
        }
        in.setH5group(h5group);
        in.setOpenid(this.config.getOpenid());
        in.setSendtime(DateUtil.getSendTime());
        in.setTraceno(traceno);
        String signResource = in.signResource();
        String sign = this.securityService.signature(signResource, this.config.getAppkey());
        in.setSign(sign);
        if (this.config.getCfcafile() != null && this.config.getCfcafile().length > 1) {
            String cfcaSign = this.securityService.cfcaSignature(signResource, this.config.getCfcapwd(), this.config.getCfcafile());
            in.setCfcasign(cfcaSign);
        }
        URI url = URI.create(String.valueOf(this.config.getHgtwurl()) + "commv2/token");
        String postJson = JSON.toJSONString((Object)in);
        log.debug("\u8bf7\u6c42\u5730\u5740:[{}],\u62a5\u6587[{}]", (Object)url.toASCIIString(), (Object)postJson);
        String response = HttpClientUtil.post(url, postJson, this.config);
        log.debug("\u5e94\u7b54:[{}]", (Object)response);
        RegisterTokenResponse registerTokenResponse = (RegisterTokenResponse)JSON.parseObject((String)response, RegisterTokenResponse.class);
        out.setResultcode(registerTokenResponse.getResultcode());
        out.setResultdesc(registerTokenResponse.getResultdesc());
        if (out != null && ErrorCode.E0000.getCode().equals(registerTokenResponse.getResultcode())) {
            String tmpToken = registerTokenResponse.getH5token();
            String h5sgin = this.securityService.signature(tmpToken, this.config.getAppkey());
            String params = "h5token=" + tmpToken + "&sgin=" + h5sgin;
            out.setParams(params);
            out.setH5url(String.valueOf(this.config.getHgtwurl()) + "commv2/registerrouter");
        }
        return out;
    }

    @Override
    public void checkSign(String string, String string2, String string3) throws SdkException {
        Frame frame = new Frame(6, 5);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject(this);
        frame.setLocal(0, genericObject);
        GenericObject genericObject2 = new GenericObject();
        genericObject2.setObject(string);
        frame.setLocal(1, genericObject2);
        GenericObject genericObject3 = new GenericObject();
        genericObject3.setObject(string2);
        frame.setLocal(2, genericObject3);
        GenericObject genericObject4 = new GenericObject();
        genericObject4.setObject(string3);
        frame.setLocal(3, genericObject4);
        int[] nArray = new int[]{1965008188, 0, -115596630, 1893858348, 3, 1965008188, 0, 70771379, -1422472027, -926198270, 1637435071, 4, 835306875, 4, 1427025781, 2, 2010738973, 1077352900, 44, 1701902840, -1551084357, 1118397253, -745050362, 1821192347, 1935762178, 835306875, 4, -78066962, 1821192347, -606829676, 1427025781, 2, -78066962, 1821192347, 608860659, 1893858348, 3, -78066962, 1773565082, 1519556758, 1821192347, -849657228, 2053129793, -323145312, 1965008188, 0, -176127137, 100665161, -1234412432, 82, 1965008188, 0, -264448838, -211188706, 1, 1893858348, 3, 195646421, 1077352900, 65, 1519556758, 1821192347, -1328976083, -197414989, 1288578725, 1965008188, 0, -1798312115, -211188706, 1, 1965008188, 0, 1342533251, -2014395867, -909966386, 1077352900, 82, 1519556758, 1821192347, 1164325650, -1291721457, 630814130, -11549751};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 1965008188: {
                    GenericObject genericObject5 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject5);
                    n += 2;
                    break;
                }
                case -115596630: {
                    GenericObject genericObject6 = frame.pop();
                    GenericObject genericObject7 = new GenericObject();
                    genericObject7.setObject(((OpenApiServiceImpl)genericObject6.getObject()).securityService);
                    frame.push(genericObject7);
                    ++n;
                    break;
                }
                case 1893858348: {
                    GenericObject genericObject8 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject8);
                    n += 2;
                    break;
                }
                case 70771379: {
                    GenericObject genericObject9 = frame.pop();
                    GenericObject genericObject10 = new GenericObject();
                    genericObject10.setObject(((OpenApiServiceImpl)genericObject9.getObject()).config);
                    frame.push(genericObject10);
                    ++n;
                    break;
                }
                case -1422472027: {
                    Object object = frame.pop().getObject();
                    Object object2 = ((EntAppConfig)object).getAppkey();
                    GenericObject genericObject11 = new GenericObject();
                    genericObject11.setObject(object2);
                    frame.push(genericObject11);
                    ++n;
                    break;
                }
                case -926198270: {
                    Object object = frame.pop().getObject();
                    Object object3 = frame.pop().getObject();
                    Object object4 = frame.pop().getObject();
                    Object object5 = ((OpenApiSecurityService)object4).signature((String)object3, (String)object);
                    GenericObject genericObject12 = new GenericObject();
                    genericObject12.setObject(object5);
                    frame.push(genericObject12);
                    ++n;
                    break;
                }
                case 1637435071: {
                    GenericObject genericObject13 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject13);
                    n += 2;
                    break;
                }
                case 835306875: {
                    GenericObject genericObject14 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject14);
                    n += 2;
                    break;
                }
                case 1427025781: {
                    GenericObject genericObject15 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject15);
                    n += 2;
                    break;
                }
                case 2010738973: {
                    CharSequence charSequence = (CharSequence)frame.pop().getObject();
                    CharSequence charSequence2 = (CharSequence)frame.pop().getObject();
                    boolean bl = StringUtils.equals(charSequence2, charSequence);
                    GenericObject genericObject16 = new GenericObject();
                    genericObject16.setBoolean(bl);
                    frame.push(genericObject16);
                    ++n;
                    break;
                }
                case 1077352900: {
                    GenericObject genericObject17 = frame.pop();
                    int n2 = genericObject17.toInt();
                    if (n2 != 0) {
                        n = nArray[n + 1];
                        break;
                    }
                    n += 2;
                    break;
                }
                case 1701902840: {
                    GenericObject genericObject18 = new GenericObject();
                    genericObject18.setObject(log);
                    frame.push(genericObject18);
                    ++n;
                    break;
                }
                case -1551084357: {
                    GenericObject genericObject19 = new GenericObject();
                    genericObject19.setString("5pys5Zyw562+5ZCNW3t9XSzov5Tlm57nrb7lkI1be31d77yM6L+U5Zue5oql5paHW3t9XQ==");
                    frame.push(genericObject19);
                    ++n;
                    break;
                }
                case 1118397253: {
                    GenericObject genericObject20 = new GenericObject();
                    genericObject20.setInt(3);
                    frame.push(genericObject20);
                    ++n;
                    break;
                }
                case -745050362: {
                    int n3 = frame.pop().getInt();
                    Object[] objectArray = new Object[n3];
                    GenericObject genericObject21 = new GenericObject();
                    genericObject21.setObject(objectArray);
                    frame.push(genericObject21);
                    ++n;
                    break;
                }
                case 1821192347: {
                    GenericObject genericObject22 = frame.peek();
                    frame.push(genericObject22);
                    ++n;
                    break;
                }
                case 1935762178: {
                    GenericObject genericObject23 = new GenericObject();
                    genericObject23.setInt(0);
                    frame.push(genericObject23);
                    ++n;
                    break;
                }
                case -78066962: {
                    GenericObject genericObject24 = frame.pop();
                    int n4 = frame.pop().getInt();
                    GenericObject genericObject25 = frame.pop();
                    Object object = genericObject25.getObject();
                    Object[] objectArray = (Object[])object;
                    objectArray[n4] = genericObject24.getObject();
                    ++n;
                    break;
                }
                case -606829676: {
                    GenericObject genericObject26 = new GenericObject();
                    genericObject26.setInt(1);
                    frame.push(genericObject26);
                    ++n;
                    break;
                }
                case 608860659: {
                    GenericObject genericObject27 = new GenericObject();
                    genericObject27.setInt(2);
                    frame.push(genericObject27);
                    ++n;
                    break;
                }
                case 1773565082: {
                    Object object = frame.pop().getObject();
                    Object object6 = frame.pop().getObject();
                    Object object7 = frame.pop().getObject();
                    ((Logger)object7).error((String)object6, (Object[])object);
                    ++n;
                    break;
                }
                case 1519556758: {
                    StubObject stubObject = new StubObject("com.czb.sap.sdk.exception.SdkException");
                    GenericObject genericObject28 = new GenericObject();
                    genericObject28.setObject(stubObject);
                    frame.push(genericObject28);
                    ++n;
                    break;
                }
                case -849657228: {
                    GenericObject genericObject29 = new GenericObject();
                    genericObject29.setObject((Object)ErrorCode.E0010);
                    frame.push(genericObject29);
                    ++n;
                    break;
                }
                case 2053129793: {
                    Object object = frame.pop().getObject();
                    SdkException sdkException = new SdkException((ErrorCode)((Object)object));
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject30 = new GenericObject();
                    genericObject30.setObject(sdkException);
                    frame.push(genericObject30);
                    ++n;
                    break;
                }
                case -323145312: {
                    GenericObject genericObject31 = frame.pop();
                    frame.empty();
                    frame.push(genericObject31);
                    genericObject31.throwException();
                    ++n;
                    break;
                }
                case -176127137: {
                    GenericObject genericObject32 = frame.pop();
                    GenericObject genericObject33 = new GenericObject();
                    genericObject33.setObject(((OpenApiServiceImpl)genericObject32.getObject()).config);
                    frame.push(genericObject33);
                    ++n;
                    break;
                }
                case 100665161: {
                    Object object = frame.pop().getObject();
                    Object object8 = ((EntAppConfig)object).getCerfile();
                    GenericObject genericObject34 = new GenericObject();
                    genericObject34.setObject(object8);
                    frame.push(genericObject34);
                    ++n;
                    break;
                }
                case -1234412432: {
                    GenericObject genericObject35 = frame.pop();
                    if (genericObject35.getObject() == null) {
                        n = nArray[n + 1];
                        break;
                    }
                    n += 2;
                    break;
                }
                case -264448838: {
                    GenericObject genericObject36 = frame.pop();
                    GenericObject genericObject37 = new GenericObject();
                    genericObject37.setObject(((OpenApiServiceImpl)genericObject36.getObject()).securityService);
                    frame.push(genericObject37);
                    ++n;
                    break;
                }
                case -211188706: {
                    GenericObject genericObject38 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject38);
                    n += 2;
                    break;
                }
                case 195646421: {
                    Object object = frame.pop().getObject();
                    Object object9 = frame.pop().getObject();
                    Object object10 = frame.pop().getObject();
                    boolean bl = ((OpenApiSecurityService)object10).verify((String)object9, (String)object);
                    GenericObject genericObject39 = new GenericObject();
                    genericObject39.setBoolean(bl);
                    frame.push(genericObject39);
                    ++n;
                    break;
                }
                case -1328976083: {
                    GenericObject genericObject40 = new GenericObject();
                    genericObject40.setObject((Object)ErrorCode.E0011);
                    frame.push(genericObject40);
                    ++n;
                    break;
                }
                case -197414989: {
                    Object object = frame.pop().getObject();
                    SdkException sdkException = new SdkException((ErrorCode)((Object)object));
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject41 = new GenericObject();
                    genericObject41.setObject(sdkException);
                    frame.push(genericObject41);
                    ++n;
                    break;
                }
                case 1288578725: {
                    GenericObject genericObject42 = frame.pop();
                    frame.empty();
                    frame.push(genericObject42);
                    genericObject42.throwException();
                    ++n;
                    break;
                }
                case -1798312115: {
                    GenericObject genericObject43 = frame.pop();
                    GenericObject genericObject44 = new GenericObject();
                    genericObject44.setObject(((OpenApiServiceImpl)genericObject43.getObject()).securityService);
                    frame.push(genericObject44);
                    ++n;
                    break;
                }
                case 1342533251: {
                    GenericObject genericObject45 = frame.pop();
                    GenericObject genericObject46 = new GenericObject();
                    genericObject46.setObject(((OpenApiServiceImpl)genericObject45.getObject()).config);
                    frame.push(genericObject46);
                    ++n;
                    break;
                }
                case -2014395867: {
                    Object object = frame.pop().getObject();
                    Object object11 = ((EntAppConfig)object).getCerfile();
                    GenericObject genericObject47 = new GenericObject();
                    genericObject47.setObject(object11);
                    frame.push(genericObject47);
                    ++n;
                    break;
                }
                case -909966386: {
                    Object object = frame.pop().getObject();
                    Object object12 = frame.pop().getObject();
                    Object object13 = frame.pop().getObject();
                    boolean bl = ((OpenApiSecurityService)object13).verifyDn((String)object12, (byte[])object);
                    GenericObject genericObject48 = new GenericObject();
                    genericObject48.setBoolean(bl);
                    frame.push(genericObject48);
                    ++n;
                    break;
                }
                case 1164325650: {
                    GenericObject genericObject49 = new GenericObject();
                    genericObject49.setObject((Object)ErrorCode.E0016);
                    frame.push(genericObject49);
                    ++n;
                    break;
                }
                case -1291721457: {
                    Object object = frame.pop().getObject();
                    SdkException sdkException = new SdkException((ErrorCode)((Object)object));
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject50 = new GenericObject();
                    genericObject50.setObject(sdkException);
                    frame.push(genericObject50);
                    ++n;
                    break;
                }
                case 630814130: {
                    GenericObject genericObject51 = frame.pop();
                    frame.empty();
                    frame.push(genericObject51);
                    genericObject51.throwException();
                    ++n;
                    break;
                }
                case -11549751: {
                    return;
                }
            }
        }
    }

    @Override
    @Deprecated
    public UploadFileOut uploadBigFile(UploadFileIn uploadFileIn) throws SdkException {
        Frame frame = new Frame(2, 2);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject(this);
        frame.setLocal(0, genericObject);
        GenericObject genericObject2 = new GenericObject();
        genericObject2.setObject(uploadFileIn);
        frame.setLocal(1, genericObject2);
        int[] nArray = new int[]{1169888768, 0, -574100090, 1, 1997823530, -264275233};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 1169888768: {
                    GenericObject genericObject3 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject3);
                    n += 2;
                    break;
                }
                case -574100090: {
                    GenericObject genericObject4 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject4);
                    n += 2;
                    break;
                }
                case 1997823530: {
                    Object object = frame.pop().getObject();
                    Object object2 = frame.pop().getObject();
                    Object object3 = ((OpenApiServiceImpl)object2).uploadFile((UploadFileIn)object);
                    GenericObject genericObject5 = new GenericObject();
                    genericObject5.setObject(object3);
                    frame.push(genericObject5);
                    ++n;
                    break;
                }
                case -264275233: {
                    return (UploadFileOut)frame.pop().getObject();
                }
            }
        }
    }

    public String getAppName() {
        Frame frame = new Frame(1, 1);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject(this);
        frame.setLocal(0, genericObject);
        int[] nArray = new int[]{-893558015, 0, 547230624, 660712316};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case -893558015: {
                    GenericObject genericObject2 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject2);
                    n += 2;
                    break;
                }
                case 547230624: {
                    GenericObject genericObject3 = frame.pop();
                    GenericObject genericObject4 = new GenericObject();
                    genericObject4.setObject(((OpenApiServiceImpl)genericObject3.getObject()).appName);
                    frame.push(genericObject4);
                    ++n;
                    break;
                }
                case 660712316: {
                    return (String)frame.pop().getObject();
                }
            }
        }
    }

    public EntAppConfig getConfig() {
        Frame frame = new Frame(1, 1);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject(this);
        frame.setLocal(0, genericObject);
        int[] nArray = new int[]{-1196064227, 0, 1016176313, -287060015};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case -1196064227: {
                    GenericObject genericObject2 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject2);
                    n += 2;
                    break;
                }
                case 1016176313: {
                    GenericObject genericObject3 = frame.pop();
                    GenericObject genericObject4 = new GenericObject();
                    genericObject4.setObject(((OpenApiServiceImpl)genericObject3.getObject()).config);
                    frame.push(genericObject4);
                    ++n;
                    break;
                }
                case -287060015: {
                    return (EntAppConfig)frame.pop().getObject();
                }
            }
        }
    }

    public OpenApiSecurityService getSecurityService() {
        Frame frame = new Frame(1, 1);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject(this);
        frame.setLocal(0, genericObject);
        int[] nArray = new int[]{-1223022151, 0, -1322228626, 1009942686};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case -1223022151: {
                    GenericObject genericObject2 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject2);
                    n += 2;
                    break;
                }
                case -1322228626: {
                    GenericObject genericObject3 = frame.pop();
                    GenericObject genericObject4 = new GenericObject();
                    genericObject4.setObject(((OpenApiServiceImpl)genericObject3.getObject()).securityService);
                    frame.push(genericObject4);
                    ++n;
                    break;
                }
                case 1009942686: {
                    return (OpenApiSecurityService)frame.pop().getObject();
                }
            }
        }
    }

    public Lock getLock() {
        Frame frame = new Frame(1, 1);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject(this);
        frame.setLocal(0, genericObject);
        int[] nArray = new int[]{80215985, 0, 345199441, -1459475007};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 80215985: {
                    GenericObject genericObject2 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject2);
                    n += 2;
                    break;
                }
                case 345199441: {
                    GenericObject genericObject3 = frame.pop();
                    GenericObject genericObject4 = new GenericObject();
                    genericObject4.setObject(((OpenApiServiceImpl)genericObject3.getObject()).lock);
                    frame.push(genericObject4);
                    ++n;
                    break;
                }
                case -1459475007: {
                    return (Lock)frame.pop().getObject();
                }
            }
        }
    }

    public void setAppName(String string) {
        Frame frame = new Frame(2, 2);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject(this);
        frame.setLocal(0, genericObject);
        GenericObject genericObject2 = new GenericObject();
        genericObject2.setObject(string);
        frame.setLocal(1, genericObject2);
        int[] nArray = new int[]{1536969053, 0, -2135141592, 1, 186630536, -1603526467};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 1536969053: {
                    GenericObject genericObject3 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject3);
                    n += 2;
                    break;
                }
                case -2135141592: {
                    GenericObject genericObject4 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject4);
                    n += 2;
                    break;
                }
                case 186630536: {
                    GenericObject genericObject5 = frame.pop();
                    ((OpenApiServiceImpl)frame.pop().getObject()).appName = (String)genericObject5.getObject();
                    ++n;
                    break;
                }
                case -1603526467: {
                    return;
                }
            }
        }
    }

    public void setConfig(EntAppConfig entAppConfig) {
        Frame frame = new Frame(2, 2);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject(this);
        frame.setLocal(0, genericObject);
        GenericObject genericObject2 = new GenericObject();
        genericObject2.setObject(entAppConfig);
        frame.setLocal(1, genericObject2);
        int[] nArray = new int[]{1979480438, 0, 1797361437, 1, -189594575, -1658519522};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 1979480438: {
                    GenericObject genericObject3 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject3);
                    n += 2;
                    break;
                }
                case 1797361437: {
                    GenericObject genericObject4 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject4);
                    n += 2;
                    break;
                }
                case -189594575: {
                    GenericObject genericObject5 = frame.pop();
                    ((OpenApiServiceImpl)frame.pop().getObject()).config = (EntAppConfig)genericObject5.getObject();
                    ++n;
                    break;
                }
                case -1658519522: {
                    return;
                }
            }
        }
    }

    public void setSecurityService(OpenApiSecurityService openApiSecurityService) {
        Frame frame = new Frame(2, 2);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject(this);
        frame.setLocal(0, genericObject);
        GenericObject genericObject2 = new GenericObject();
        genericObject2.setObject(openApiSecurityService);
        frame.setLocal(1, genericObject2);
        int[] nArray = new int[]{-484168961, 0, 1556246094, 1, -28844407, 103907452};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case -484168961: {
                    GenericObject genericObject3 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject3);
                    n += 2;
                    break;
                }
                case 1556246094: {
                    GenericObject genericObject4 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject4);
                    n += 2;
                    break;
                }
                case -28844407: {
                    GenericObject genericObject5 = frame.pop();
                    ((OpenApiServiceImpl)frame.pop().getObject()).securityService = (OpenApiSecurityService)genericObject5.getObject();
                    ++n;
                    break;
                }
                case 103907452: {
                    return;
                }
            }
        }
    }

    public void setLock(Lock lock) {
        Frame frame = new Frame(2, 2);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject(this);
        frame.setLocal(0, genericObject);
        GenericObject genericObject2 = new GenericObject();
        genericObject2.setObject(lock);
        frame.setLocal(1, genericObject2);
        int[] nArray = new int[]{-649577213, 0, -991397664, 1, 87591838, 1487422497};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case -649577213: {
                    GenericObject genericObject3 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject3);
                    n += 2;
                    break;
                }
                case -991397664: {
                    GenericObject genericObject4 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject4);
                    n += 2;
                    break;
                }
                case 87591838: {
                    GenericObject genericObject5 = frame.pop();
                    ((OpenApiServiceImpl)frame.pop().getObject()).lock = (Lock)genericObject5.getObject();
                    ++n;
                    break;
                }
                case 1487422497: {
                    return;
                }
            }
        }
    }
}

