/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.agent.GenericCertificate;
import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignAgentRes;
import cn.com.infosec.netsign.agent.NetSignAgentUtil;
import cn.com.infosec.netsign.agent.PBCAgent2GUtil;
import cn.com.infosec.netsign.agent.PBCCRCAgentResult;
import cn.com.infosec.netsign.agent.digest.SHA256Digest;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.exception.ServerProcessException;
import cn.com.infosec.netsign.agent.newcommunitor.CommunitorManager;
import cn.com.infosec.netsign.agent.service.NSPSService;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.base.wanglian.WangLianUtil;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.crypto.util.NSRandom;
import cn.com.infosec.netsign.crypto.util.SM3;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.json.JsonObject;
import cn.com.infosec.netsign.json.JsonParser;
import cn.com.infosec.netsign.json.JsonValueObject;
import cn.com.infosec.netsign.json.JsonValueString;
import cn.com.infosec.netsign.pool.Poolable;
import cn.com.infosec.oscca.encryption.SM4ECB;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PBCAgent2G
implements Poolable {
    public boolean isDebug = false;
    private static Date now = null;
    private static SimpleDateFormat format = null;
    private byte[] pwd;
    private String ip;
    private int port;
    private Socket connection;
    private int timeout = 60000;
    private int returnCode;
    private String encoding = null;
    private CommunitorManager cm = null;
    static boolean checkIPAddress = true;
    public static final String CUPSTC_PINKEY = "cupstcpinkey";
    public static final String CUPSTC_TRANSKEY = "cupstctranskey";
    private String CUPSTCEncoding = "GBK";

    static {
        now = new Date();
        format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (Security.getProvider("INFOSEC") == null) {
            Security.addProvider((Provider)new InfosecProvider());
        }
    }

    public static void setConnectionMode(int mode) {
        NetSignAgentRes.setConnectionMode(mode);
    }

    public static void setIsAutoTestServices(boolean on) {
        NetSignAgentRes.setAutoTest(on);
    }

    public static void setServiceTestInterval(long interval) {
        NetSignAgentRes.setTestInterval(interval);
    }

    public static void setCheckIPAddress(boolean checkIPAddress) {
        PBCAgent2G.checkIPAddress = checkIPAddress;
    }

    public PBCAgent2G() {
        this.cm = new CommunitorManager(true);
    }

    public PBCAgent2G(boolean usingSingleServiceList) {
        this.cm = new CommunitorManager(usingSingleServiceList);
    }

    public boolean checkCertChain(String dn) {
        this.logString("checkCertChain{certdn:" + dn + "}");
        NSMessage req = NetSignAgentUtil.createMessage("VerifyCertChainProcessor");
        req.setSignCertDN(dn);
        NSMessageOpt res = this.sendMsg(req);
        if (res == null) {
            this.logString("checkCertCRL{connect to server failed}");
            return false;
        }
        this.returnCode = res.getResult();
        this.logString("checkCertChain{returnCode:" + this.returnCode + "}");
        return this.returnCode >= 0;
    }

    public boolean checkCertCRL(String dn) {
        this.logString("checkCertCRL{certdn:" + dn + "}");
        NSMessage req = NetSignAgentUtil.createMessage("IsCertRevokedProcessor");
        req.setSignCertDN(dn);
        NSMessageOpt res = this.sendMsg(req);
        if (res == null) {
            this.logString("checkCertCRL{connect to server failed}");
            return false;
        }
        this.returnCode = res.getResult();
        this.logString("checkCertCRL{returnCode:" + this.returnCode + "}");
        return this.returnCode >= 0;
    }

    public boolean closeSignServer() {
        this.logString("closeSignServer{}");
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cm.closeCommunitor();
        return true;
    }

    public boolean deleteCert(String dn) {
        this.logString("deleteCert{dn:" + dn + "}");
        NSMessage req = NetSignAgentUtil.createMessage("DeleteRAWCertProcessor");
        req.setSignCertDN(dn);
        req.setAPIPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("deleteCert{returnCode:" + this.returnCode + "}");
            return this.returnCode >= 0;
        }
        this.logString("deleteCert{connect to server failed}");
        return false;
    }

    public boolean deleteCert(String dn, X509Certificate x509) {
        this.logString("deleteCert{dn:" + dn + "}");
        NSMessage req = NetSignAgentUtil.createMessage("DeleteRAWCertProcessor");
        req.setSignCertDN(dn);
        req.setCert(x509);
        req.setAPIPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("deleteCert{returnCode:" + this.returnCode + "}");
            return this.returnCode >= 0;
        }
        this.logString("deleteCert{connect to server failed}");
        return false;
    }

    public int[] deleteCertFromAllServices(String dn) {
        this.logString("deleteCertFromAllServices{dn:" + dn + "}");
        NSMessage req = NetSignAgentUtil.createMessage("DeleteRAWCertProcessor");
        req.setSignCertDN(dn);
        NSMessageOpt[] resps = this.cm.sendAll(req);
        int[] results = new int[resps.length];
        int i = 0;
        while (i < results.length) {
            if (resps[i] != null) {
                results[i] = resps[i].getResult();
            }
            ++i;
        }
        return results;
    }

    public int[] deleteCertFromAllServices(String dn, X509Certificate x509) {
        this.logString("deleteCertFromAllServices{dn:" + dn + "}");
        NSMessage req = NetSignAgentUtil.createMessage("DeleteRAWCertProcessor");
        req.setSignCertDN(dn);
        req.setCert(x509);
        NSMessageOpt[] resps = this.cm.sendAll(req);
        int[] results = new int[resps.length];
        int i = 0;
        while (i < results.length) {
            if (resps[i] != null) {
                results[i] = resps[i].getResult();
            }
            ++i;
        }
        return results;
    }

    public String dettachedSign(byte[] origBytes, String dn) {
        this.logString("dettachedSign{origBytes:" + origBytes + ";dn:" + dn + "}");
        if (origBytes == null) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("DetachedSignProcessor");
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        req.setApiPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("dettachedSign{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return Base64.encode(res.getCryptoText());
            }
            return null;
        }
        this.logString("dettachedSign{connect to server failed}");
        return null;
    }

    public PBCCRCAgentResult PBCCRCDettachedSign(byte[] origBytes, String dn) {
        this.logString("dettachedSign{origBytes:" + origBytes + ";dn:" + dn + "}");
        if (origBytes == null) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("PBCCRCDetachedSignProcessor");
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        req.setApiPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            PBCCRCAgentResult result = new PBCCRCAgentResult();
            this.returnCode = res.getResult();
            result.setReturncode(this.returnCode);
            this.logString("dettachedSign{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                result.setCryptoData(Base64.encode(res.getCryptoText()));
            }
            return result;
        }
        this.logString("dettachedSign{connect to server failed}");
        return null;
    }

    public PBCCRCAgentResult PBCCRCDettachedVerify(byte[] origBytes, String signedStr) {
        this.logString("dettachedVerify{origBytes:" + origBytes + ";signedStr:" + signedStr + "}");
        if (origBytes == null || signedStr == null || "".equals(signedStr)) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("DetachedVerifyProcessor");
        req.setCryptoText(Base64.decode(signedStr));
        req.setPlainText(origBytes);
        req.setTransCert(true);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            PBCCRCAgentResult result = new PBCCRCAgentResult();
            this.returnCode = res.getResult();
            result.setReturncode(this.returnCode);
            this.logString("PBCCRCDettachedVerify{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                this.logString("PBCCRCDettachedVerify{signTime:" + res.getAuthAttrSignTime() + "}");
                X509Certificate cert = res.getCert();
                GenericCertificate certificate = new GenericCertificate(cert);
                result.setCertificate(certificate);
                if (res.getAuthAttrSignTime() != null) {
                    result.setSignTime(res.getAuthAttrSignTime());
                }
            }
            return result;
        }
        this.logString("PBCCRCDettachedVerify{connect to server failed}");
        return null;
    }

    public PBCCRCAgentResult PBCCRCAttachedSign(byte[] origBytes, String dn) {
        this.logString("dettachedSign{origBytes:" + origBytes + ";dn:" + dn + "}");
        if (origBytes == null) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("PBCCRCAttachedSignProcessor");
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        req.setApiPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            PBCCRCAgentResult result = new PBCCRCAgentResult();
            this.returnCode = res.getResult();
            result.setReturncode(this.returnCode);
            this.logString("dettachedSign{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                result.setCryptoData(Base64.encode(res.getCryptoText()));
            }
            return result;
        }
        this.logString("dettachedSign{connect to server failed}");
        return null;
    }

    public PBCCRCAgentResult PBCCRCAttachedVerify(String signedStr) {
        this.logString("dettachedVerify{signedStr:" + signedStr + "}");
        if (signedStr == null || "".equals(signedStr)) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("AttachedVerifyProcessor");
        req.setCryptoText(Base64.decode(signedStr));
        req.setTransCert(true);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            PBCCRCAgentResult result = new PBCCRCAgentResult();
            this.returnCode = res.getResult();
            result.setReturncode(this.returnCode);
            this.logString("PBCCRCAttachedVerify{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                this.logString("PBCCRCAttachedVerify{signTime:" + res.getAuthAttrSignTime() + "}");
                X509Certificate cert = res.getCert();
                GenericCertificate certificate = new GenericCertificate(cert);
                result.setCertificate(certificate);
                if (res.getAuthAttrSignTime() != null) {
                    result.setSignTime(res.getAuthAttrSignTime());
                }
                result.setPlaintext(res.getPlainText());
            }
            return result;
        }
        this.logString("PBCCRCAttachedVerify{connect to server failed}");
        return null;
    }

    public GenericCertificate dettachedVerify(byte[] origBytes, String signedStr) {
        this.logString("dettachedVerify{origBytes:" + origBytes + ";signedStr:" + signedStr + "}");
        if (origBytes == null || signedStr == null || "".equals(signedStr)) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("DetachedVerifyProcessor");
        req.setCryptoText(Base64.decode(signedStr));
        req.setPlainText(origBytes);
        req.setTransCert(true);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("dettachedVerify{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                X509Certificate cert = res.getCert();
                return new GenericCertificate(cert);
            }
            return null;
        }
        this.logString("dettachedVerify{connect to server failed}");
        return null;
    }

    public GenericCertificate dettachedVerifySimple(byte[] origBytes, String certStr) {
        this.logString("uploadCert{origBytes:" + origBytes + ";certStr:" + certStr + "}");
        NSMessage req = NetSignAgentUtil.createMessage("VerifyDetachedSignedValueProcessor");
        req.setPlainText(origBytes);
        req.setCryptoText(Base64.decode(certStr));
        req.setTransCert(true);
        NSMessageOpt res = this.sendMsg(req);
        if (res == null) {
            this.logString("checkCertCRL{connect to server failed}");
            return null;
        }
        this.returnCode = res.getResult();
        this.logString("dettachedVerifySimple{returnCode:" + this.returnCode + "}");
        if (this.returnCode < 0) {
            return null;
        }
        return new GenericCertificate(res.getCert());
    }

    public Map getGenericCertificate() {
        this.logString("getGenericCertificate{}");
        HashMap<String, GenericCertificate[]> map = new HashMap<String, GenericCertificate[]>();
        NSMessage req = NetSignAgentUtil.createMessage("GetRAWCertListProcessor");
        req.setSignCertDN("all");
        NSMessageOpt result = this.sendMsg(req);
        if (result != null) {
            this.returnCode = result.getResult();
            this.logString("getGenericCertificate.getCertDNList{returncode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                String dns = result.getSignCertDN();
                if (dns == null || dns.equals("")) {
                    this.logString("getGenericCertificate.getCertDNList{no cert found}");
                    return null;
                }
                String[] pieces = dns.split("\\|");
                int i = 0;
                int length = pieces.length;
                while (i < length) {
                    GenericCertificate[] certs = this.getGenericCertificate(pieces[i]);
                    if (certs != null) {
                        map.put(certs[0].getBankcode(), certs);
                    }
                    ++i;
                }
                return map;
            }
            return null;
        }
        this.logString("getGenericCertificate.getCertDNList{connect to server failed}");
        return null;
    }

    public GenericCertificate[] getGenericCertificate(String bankcode) {
        this.logString("getGenericCertificate{bankcode:" + bankcode + "}");
        NSMessage req = NetSignAgentUtil.createMessage("DownloadRAWCertProcessor");
        req.setSignCertDN(bankcode);
        NSMessageOpt result = this.sendMsg(req);
        if (result != null) {
            this.returnCode = result.getResult();
            this.logString("getGenericCertificate{returncode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                X509Certificate cert = result.getCert();
                if (cert != null) {
                    return new GenericCertificate[]{new GenericCertificate(cert)};
                }
                this.logString("getGenericCertificate{no certificate found}");
            }
        } else {
            this.logString("getGenericCertificate{connect to server failed}");
        }
        return null;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void isDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public void logException(Throwable e) {
        if (!this.isDebug) {
            return;
        }
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        System.out.println("---------------NetSign(" + time + ")----------------");
        System.out.println("An Exception catched:" + e.toString());
        System.out.println("Full stacktrace as below:");
        e.printStackTrace(System.out);
        System.out.flush();
        System.out.println("----------------------------------------------------------");
    }

    public void logString(String msg) {
        if (!this.isDebug) {
            return;
        }
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        StringBuffer buf = new StringBuffer();
        buf.append("---------------NetSign(").append(time).append(")----------------\n");
        buf.append(msg).append("\n");
        buf.append("----------------------------------------------------------\n");
        System.out.print(buf.toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean openConnection() {
        block9: {
            this.logString("openConnection{}");
            connectionok = true;
            if (PBCAgent2G.checkIPAddress) {
                try {
                    try {
                        ia = new InetSocketAddress(this.ip, this.port);
                        this.connection = new Socket();
                        this.connection.connect(ia, this.timeout);
                        this.connection.setTcpNoDelay(true);
                        this.connection.setSoTimeout(this.timeout);
                        this.connection.setSoLinger(true, 0);
                    }
                    catch (Exception e) {
                        this.logException(e);
                        connectionok = false;
                    }
                }
                catch (Throwable var4_4) {
                    var3_5 = null;
                    try {
                        this.connection.close();
                        throw var4_4;
                    }
                    catch (Exception var5_7) {
                        // empty catch block
                    }
                    throw var4_4;
                }
                {
                    var3_6 = null;
                }
                ** try [egrp 2[TRYBLOCK] [3 : 105->115)] { 
lbl28:
                // 1 sources

                this.connection.close();
                break block9;
lbl30:
                // 1 sources

                catch (Exception var5_8) {
                    // empty catch block
                }
            }
        }
        s = new NSPSService();
        s.setIp(this.ip);
        s.setPort(this.port);
        s.setTimeout(this.timeout);
        s.setApiPasswd(this.pwd);
        this.cm.addService(s);
        return connectionok;
    }

    public boolean openSignServer(String ip, int port, String password) {
        this.logString("openSignServer{ip:" + ip + ";port:" + port + "}");
        if (ip == null || "".equals(ip) || port < 0) {
            this.returnCode = -1025;
            return false;
        }
        this.ip = ip;
        this.port = port;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            this.pwd = md.digest(password.getBytes("GBK"));
        }
        catch (Exception e) {
            this.logException(e);
            return false;
        }
        return this.openConnection();
    }

    public boolean[] openSignServer(String ip, String port, String password) {
        this.logString("openSignServer{ip:" + ip + ";port:" + port + "}");
        if (ip == null || "".equals(ip) || port == null || "".equals(port)) {
            this.returnCode = -1025;
            return new boolean[1];
        }
        if (ip.indexOf(",") < 0) {
            boolean result = this.openSignServer(ip, Integer.parseInt(port), password);
            return new boolean[]{result};
        }
        String[] ips = ip.split(",");
        String[] ports = port.split(",");
        String[] passwords = password.split(",");
        boolean[] results = new boolean[ips.length];
        int i = 0;
        int length = ips.length;
        while (i < length) {
            boolean result;
            results[i] = result = this.openSignServer(ips[i], Integer.parseInt(ports[i]), passwords[i]);
            ++i;
        }
        return results;
    }

    public String rawSign(byte[] origBytes, String dn) {
        this.logString("rawSign{origBytes:" + origBytes + ";dn:" + dn + "}");
        if (origBytes == null) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("RAWSignProcessor");
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        req.setApiPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("rawSign{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                byte[] signed = res.getCryptoText();
                return Base64.encode(signed);
            }
            return null;
        }
        this.logString("rawSign{connect to server failed}");
        return null;
    }

    public boolean rawVerify(byte[] origBytes, String signedStr, String dn) {
        this.logString("rawVerify{origBytes:" + origBytes + ";signedStr:" + signedStr + ";dn:" + dn + "}");
        if (origBytes == null || signedStr == null || "".equals(signedStr) || dn == null || "".equals(dn)) {
            this.returnCode = -1026;
            return false;
        }
        NSMessage req = NetSignAgentUtil.createMessage("PBCRAWVerifyProcessor");
        req.setCryptoText(Base64.decode(signedStr));
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("rawVerify{returnCode:" + this.returnCode + "}");
            return this.returnCode >= 0;
        }
        this.logString("rawSign{connect to server failed}");
        return false;
    }

    public boolean rawVerifySimple(byte[] origBytes, String signedStr, String dn) {
        this.logString("rawVerify{origBytes:" + origBytes + ";signedStr:" + signedStr + ";dn:" + dn + "}");
        if (origBytes == null || signedStr == null || "".equals(signedStr) || dn == null || "".equals(dn)) {
            this.returnCode = -1026;
            return false;
        }
        NSMessage req = NetSignAgentUtil.createMessage("VerifyRawSignedValueProcessor");
        req.setCryptoText(Base64.decode(signedStr));
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("rawVerify{returnCode:" + this.returnCode + "}");
            return this.returnCode >= 0;
        }
        this.logString("rawSign{connect to server failed}");
        return false;
    }

    private NSMessageOpt sendMsg(NSMessage req) {
        try {
            return this.cm.sendMessageUsingLongConnection(req);
        }
        catch (NetSignAgentException e) {
            this.returnCode = e.getErrorCode();
            e.printStackTrace(System.out);
        }
        catch (Exception e) {
            this.returnCode = -9999;
            e.printStackTrace(System.out);
        }
        return null;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setOrderdn(int orderdn) {
        NetSignAgentRes.setOrderDN(orderdn);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String unstandardDettachedSign(byte[] origBytes, String dn, String standard) {
        this.logString("unstandardDettachedSign{origBytes:" + origBytes + ";dn:" + dn + "}");
        if (origBytes == null) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage(String.valueOf(standard) + "DetachedSignProcessor");
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        req.setApiPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("unstandardDettachedSign{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return Base64.encode(res.getCryptoText());
            }
            return null;
        }
        this.logString("unstandardDettachedSign{connect to server failed}");
        return null;
    }

    public GenericCertificate unstandardDettachedVerify(byte[] origBytes, String signedStr, String standard) {
        this.logString("unstandardDettachedVerify{origBytes:" + origBytes + ";certStr:" + signedStr + "}");
        if (origBytes == null || signedStr == null || "".equals(signedStr)) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage(String.valueOf(standard) + "DetachedVerifyProcessor");
        req.setCryptoText(Base64.decode(signedStr));
        req.setPlainText(origBytes);
        req.setTransCert(true);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("unstandardDettachedVerify{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                X509Certificate cert = res.getCert();
                return new GenericCertificate(cert);
            }
            return null;
        }
        this.logString("unstandardDettachedVerify{connect to server failed}");
        return null;
    }

    public boolean uploadCert(String bankcode, X509Certificate cert) {
        try {
            this.logString("uploadCert{bankcode:" + bankcode + ";cert:" + cert + "}");
        }
        catch (Exception e) {
            this.logString("uploadCert{bankcode:" + bankcode + ")");
        }
        if (cert == null) {
            return false;
        }
        NSMessage req = NetSignAgentUtil.createMessage("UploadRAWCertProcessor");
        req.setCert(cert);
        req.setBankID(bankcode);
        req.setApiPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("uploadCert{returnCode:" + this.returnCode + "}");
            return this.returnCode >= 0;
        }
        this.logString("uploadCert{connect to server failed}");
        return false;
    }

    public int[] uploadCert2AllServices(String bankcode, X509Certificate cert) {
        try {
            this.logString("uploadCert{bankcode:" + bankcode + ";cert:" + cert + "}");
        }
        catch (Exception e) {
            this.logString("uploadCert{bankcode:" + bankcode + ")");
        }
        if (cert == null) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("UploadRAWCertProcessor");
        req.setCert(cert);
        req.setBankID(bankcode);
        NSMessageOpt[] resps = this.cm.sendAll(req);
        int[] results = new int[resps.length];
        int i = 0;
        while (i < results.length) {
            if (resps[i] != null) {
                results[i] = resps[i].getResult();
            }
            ++i;
        }
        return results;
    }

    public String makeEnvelope(X509Certificate encCert, String sAlg, byte[] plainText) {
        NSMessage req = NetSignAgentUtil.createMessage("MakeEnvelopedMSGProcessor");
        req.setPlainText(plainText);
        req.setTransCert(true);
        try {
            req.setCert(NetSignAgentUtil.transcertificate(encCert));
        }
        catch (NetSignAgentException e) {
            req.setCert(encCert);
        }
        req.setSymmetricalAlg(sAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("makeEnvelope{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return Base64.encode(res.getCryptoText());
            }
            return null;
        }
        this.logString("makeEnvelope {connect to server failed}");
        return null;
    }

    public String makeEnvelope(byte[] plainText, String subject, String sAlg) {
        GenericCertificate[] certs = this.getGenericCertificate(subject);
        if (certs != null) {
            return this.makeEnvelope(certs[0].getCert(), sAlg, plainText);
        }
        return null;
    }

    public String makeMSEnvelope(String signSubject, X509Certificate encCert, String digestAlg, String sAlg, byte[] plainText) {
        NSMessage req = NetSignAgentUtil.createMessage("MakeMSEnvelopedMSGProcessor");
        byte[] plainBytes = plainText;
        req.setPlainText(plainBytes);
        req.setTransCert(true);
        try {
            req.setCert(NetSignAgentUtil.transcertificate(encCert));
        }
        catch (NetSignAgentException e) {
            req.setCert(encCert);
        }
        req.setSignCertDN(signSubject);
        req.setSymmetricalAlg(sAlg);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("makeMSEnvelope{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return Base64.encode(res.getCryptoText());
            }
            return null;
        }
        this.logString("makeMSEnvelope {connect to server failed}");
        return null;
    }

    public String makeMSEnvelope(byte[] plainText, String signSubject, String encSubject, String digestAlg, String sAlg) {
        GenericCertificate[] certs = this.getGenericCertificate(encSubject);
        if (certs != null) {
            return this.makeMSEnvelope(signSubject, certs[0].getCert(), digestAlg, sAlg, plainText);
        }
        return null;
    }

    public Object[] decryptEnvelope(String encText, String subject) {
        NSMessage req = NetSignAgentUtil.createMessage("DecryptoEnvelopedMSGProcessor");
        byte[] encBytes = null;
        encBytes = Base64.decode(encText);
        req.setCryptoText(encBytes);
        req.setEncCertDN(subject);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("decryptEnvelope{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                GenericCertificate genCert = new GenericCertificate();
                genCert.setSubject(res.getEncSubject());
                genCert.setSer_number(res.getEncSerNumber());
                genCert.setIssuer_subject(res.getEncIssuerSubject());
                genCert.setStart_time(res.getEncStartTime());
                genCert.setEnd_time(res.getEncEndtime());
                return new Object[]{Base64.encode(res.getPlainText()), genCert};
            }
            return null;
        }
        this.logString("decryptEnvelope {connect to server failed}");
        return null;
    }

    public Object[] decryptMSEnvelope(String encText, String subject) {
        return this.decryptMSEnvelope(encText, subject, null);
    }

    public Object[] decryptMSEnvelope(String encText, String subject, String digestAlg) {
        NSMessage req = NetSignAgentUtil.createMessage("DecryptoMSEnvelopedMSGProcessor");
        byte[] encBytes = Base64.decode(encText);
        req.setCryptoText(encBytes);
        req.setEncCertDN(subject);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("decryptMSEnvelope{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                GenericCertificate genCertEnc = new GenericCertificate();
                genCertEnc.setSubject(res.getEncSubject());
                genCertEnc.setSer_number(res.getEncSerNumber());
                genCertEnc.setIssuer_subject(res.getEncIssuerSubject());
                genCertEnc.setStart_time(res.getEncStartTime());
                genCertEnc.setEnd_time(res.getEncEndtime());
                GenericCertificate genCertSign = new GenericCertificate();
                genCertSign.setSubject(res.getSignSubject());
                genCertSign.setSer_number(res.getSignSerNumber());
                genCertSign.setIssuer_subject(res.getSignIssuerSubject());
                genCertSign.setStart_time(res.getSignStartTime());
                genCertSign.setEnd_time(res.getSignEndtime());
                return new Object[]{Base64.encode(res.getPlainText()), genCertEnc, genCertSign};
            }
            return null;
        }
        this.logString("decryptMSEnvelope {connect to server failed}");
        return null;
    }

    public String rawSign(byte[] origBytes, String dn, String digestAlg) {
        this.logString("rawSign{origBytes:" + origBytes + ";dn:" + dn + "}");
        if (origBytes == null) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("RAWSignProcessor");
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        req.setApiPasswd(this.pwd);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("rawSign{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                byte[] signed = res.getCryptoText();
                return Base64.encode(signed);
            }
            return null;
        }
        this.logString("rawSign{connect to server failed}");
        return null;
    }

    public boolean rawVerify(byte[] origBytes, String signedStr, String dn, String digestAlg) {
        this.logString("rawVerify{origBytes:" + origBytes + ";signedStr:" + signedStr + ";dn:" + dn + "}");
        if (origBytes == null || signedStr == null || "".equals(signedStr) || dn == null || "".equals(dn)) {
            this.returnCode = -1026;
            return false;
        }
        NSMessage req = NetSignAgentUtil.createMessage("PBCRAWVerifyProcessor");
        req.setCryptoText(Base64.decode(signedStr));
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("rawVerify{returnCode:" + this.returnCode + "}");
            return this.returnCode >= 0;
        }
        this.logString("rawSign{connect to server failed}");
        return false;
    }

    public String[] makeWangLianEnvelope(byte[][] plainText, String dn, String encAlg) {
        NSMessage req = NetSignAgentUtil.createMessage("MakeWangLianEnvelopedProcessor");
        String plainLength = "";
        byte[] allPlain = null;
        if (plainText == null || plainText.length == 0) {
            this.returnCode = -1027;
            return null;
        }
        int i = 0;
        while (i < plainText.length) {
            if (plainText[i] == null) {
                plainText[i] = new byte[0];
            }
            ++i;
        }
        if (plainText.length == 1) {
            allPlain = plainText[0];
            plainLength = String.valueOf(plainText[0].length);
        } else {
            i = 0;
            while (i < plainText.length) {
                if (allPlain == null) {
                    allPlain = new byte[plainText[0].length];
                    System.arraycopy(plainText[0], 0, allPlain, 0, plainText[0].length);
                } else {
                    byte[] tmp = allPlain;
                    allPlain = new byte[tmp.length + plainText[i].length];
                    System.arraycopy(tmp, 0, allPlain, 0, tmp.length);
                    System.arraycopy(plainText[i], 0, allPlain, tmp.length, plainText[i].length);
                }
                plainLength = String.valueOf(plainLength) + plainText[i].length + ",";
                ++i;
            }
        }
        req.setPlainText(allPlain);
        req.setBankName(plainLength);
        req.setEncCertDN(dn);
        req.setSymmetricalAlg(encAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("makeWangLianEnvelope{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                byte[][] cryptoText = NetSignAgentUtil.splitTextFromTransValue(res.getCryptoText());
                String[] ret = new String[cryptoText.length];
                int i2 = 0;
                while (i2 < ret.length) {
                    ret[i2] = Base64.encode(cryptoText[i2]);
                    ++i2;
                }
                return ret;
            }
            return null;
        }
        this.logString("makeWangLianEnvelope {connect to server failed}");
        return null;
    }

    public byte[][] decryptWangLianEnvelope(String[] cryptoText, String dn) {
        NSMessage req = NetSignAgentUtil.createMessage("DecryptWangLianEnvelopeProcessor");
        String cryptoLength = "";
        byte[] allCrypto = null;
        if (cryptoText == null || cryptoText.length < 2) {
            this.returnCode = -1022;
            return null;
        }
        int i = 0;
        while (i < cryptoText.length) {
            if (cryptoText[i] == null) {
                cryptoText[i] = "";
            }
            ++i;
        }
        if (cryptoText.length == 2) {
            allCrypto = Base64.decode(cryptoText[1]);
            cryptoLength = String.valueOf(allCrypto.length);
        } else {
            i = 1;
            while (i < cryptoText.length) {
                byte[] cryptbs = Base64.decode(cryptoText[i]);
                if (allCrypto == null) {
                    allCrypto = new byte[cryptbs.length];
                    System.arraycopy(cryptbs, 0, allCrypto, 0, cryptbs.length);
                } else {
                    byte[] tmp = allCrypto;
                    allCrypto = new byte[tmp.length + cryptbs.length];
                    System.arraycopy(tmp, 0, allCrypto, 0, tmp.length);
                    System.arraycopy(cryptbs, 0, allCrypto, tmp.length, cryptbs.length);
                }
                cryptoLength = String.valueOf(cryptoLength) + cryptbs.length + ",";
                ++i;
            }
        }
        req.setEncCertDN(dn);
        req.setCryptoText(Base64.decode(cryptoText[0]));
        req.setHashValue(allCrypto);
        req.setBankName(cryptoLength);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("decryptWangLianEnvelope{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                byte[][] plainText = NetSignAgentUtil.splitTextFromTransValue(res.getPlainText());
                return plainText;
            }
            return null;
        }
        this.logString("decryptWangLianEnvelope {connect to server failed}");
        return null;
    }

    public boolean symmDecAndSetSymmkey(byte[] cryptoText, String decKeylable, String destKeyLable, String modAndPadding) {
        return this.decryptAndSetSymmKey(cryptoText, decKeylable, modAndPadding, destKeyLable, null);
    }

    private boolean decryptAndSetSymmKey(byte[] cryptoText, String decKeylable, String modAndPadding, String destKeyLable, String certDN) {
        return false;
    }

    public String makeWangLianEnvelope(InputStream plain, String dn, String encAlg, OutputStream cryptoText) {
        NSMessage req = NetSignAgentUtil.createMessage("MakeWangLianEnvelopedProcessor");
        req.setEncCertDN(dn);
        req.setSymmetricalAlg(encAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("makeWangLianEnvelope{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                byte[][] cipher = NetSignAgentUtil.splitTextFromTransValue(res.getCryptoText());
                String ret = Base64.encode(cipher[0]);
                try {
                    if (encAlg.toUpperCase().equals("SM4")) {
                        NetSignAgentUtil.symmCipherSM4(plain, cryptoText, cipher[1], null, SM4ECB.ENC_MOD);
                    } else {
                        NetSignAgentUtil.symmCipher(plain, cryptoText, cipher[1], null, encAlg, "/ECB/PKCS5Padding", 1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    this.returnCode = -1022;
                    return null;
                }
                return ret;
            }
            return null;
        }
        this.logString("makeWangLianEnvelope {connect to server failed}");
        return null;
    }

    public String getServerInfo(String type) {
        NSMessage req = NetSignAgentUtil.createMessage("GetServerInfoProcessor");
        req.setSignCertDN("cavium");
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("getServerInfo{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return new String(res.getPlainText());
            }
            return null;
        }
        this.logString("getServerInfo {connect to server failed}");
        return null;
    }

    public void decryptWangLianEnvelope(String envelope, InputStream cryptoText, String dn, OutputStream plainText) {
        NSMessage req = NetSignAgentUtil.createMessage("DecryptWangLianEnvelopeProcessor");
        try {
            if (envelope == null || cryptoText == null || cryptoText.available() == 0 || plainText == null) {
                this.returnCode = -1026;
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            this.returnCode = -1022;
            return;
        }
        req.setEncCertDN(dn);
        req.setCryptoText(Base64.decode(envelope));
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("decryptWangLianEnvelope{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                byte[][] plain = NetSignAgentUtil.splitTextFromTransValue(res.getPlainText());
                try {
                    String encAlg = WangLianUtil.getSymmAlg(plain[0]);
                    byte[] key = WangLianUtil.getKeyInPlainEnv(plain[0], encAlg);
                    if (encAlg.toUpperCase().equals("SM4")) {
                        NetSignAgentUtil.symmCipherSM4(cryptoText, plainText, key, null, SM4ECB.DEC_MOD);
                    } else {
                        NetSignAgentUtil.symmCipher(cryptoText, plainText, key, null, encAlg, "/ECB/PKCS5Padding", 2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    this.returnCode = -1027;
                }
                return;
            }
            return;
        }
        this.logString("decryptWangLianEnvelope {connect to server failed}");
    }

    public String[] makePCACEnvelope(byte[][] plainText, String dn, String encAlg) {
        NSMessage req = NetSignAgentUtil.createMessage("MakePCACTYSHEnvelopeProcessor");
        String plainLength = "";
        byte[] allPlain = null;
        if (plainText.length == 0) {
            this.returnCode = -1027;
            return null;
        }
        if (plainText.length == 1) {
            allPlain = plainText[0];
            plainLength = String.valueOf(plainText[0].length);
        } else {
            int i = 0;
            while (i < plainText.length) {
                if (allPlain == null) {
                    allPlain = new byte[plainText[0].length];
                    System.arraycopy(plainText[0], 0, allPlain, 0, plainText[0].length);
                } else {
                    byte[] tmp = allPlain;
                    allPlain = new byte[tmp.length + plainText[i].length];
                    System.arraycopy(tmp, 0, allPlain, 0, tmp.length);
                    System.arraycopy(plainText[i], 0, allPlain, tmp.length, plainText[i].length);
                }
                plainLength = String.valueOf(plainLength) + plainText[i].length + ",";
                ++i;
            }
        }
        req.setPlainText(allPlain);
        req.setBankName(plainLength);
        req.setEncCertDN(dn);
        req.setSymmetricalAlg(encAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("makePCACEnvelope{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                byte[][] cryptoText = NetSignAgentUtil.splitTextFromTransValue(res.getCryptoText());
                String[] ret = new String[cryptoText.length];
                int i = 0;
                while (i < ret.length) {
                    ret[i] = Base64.encode(cryptoText[i]);
                    ++i;
                }
                return ret;
            }
            return null;
        }
        this.logString("makePCACEnvelope{connect to server failed}");
        return null;
    }

    public byte[][] decryptPCACEnvelope(String[] cryptoText, String dn, String encAlg) {
        NSMessage req = NetSignAgentUtil.createMessage("DecryptPCACTYSHEnvelopeProcessor");
        String cryptoLength = "";
        byte[] allCrypto = null;
        if (cryptoText.length < 2) {
            this.returnCode = -1022;
            return null;
        }
        if (cryptoText.length == 2) {
            allCrypto = Base64.decode(cryptoText[1]);
            cryptoLength = String.valueOf(allCrypto.length);
        } else {
            int i = 1;
            while (i < cryptoText.length) {
                byte[] cryptbs = Base64.decode(cryptoText[i]);
                if (allCrypto == null) {
                    allCrypto = new byte[cryptbs.length];
                    System.arraycopy(cryptbs, 0, allCrypto, 0, cryptbs.length);
                } else {
                    byte[] tmp = allCrypto;
                    allCrypto = new byte[tmp.length + cryptbs.length];
                    System.arraycopy(tmp, 0, allCrypto, 0, tmp.length);
                    System.arraycopy(cryptbs, 0, allCrypto, tmp.length, cryptbs.length);
                }
                cryptoLength = String.valueOf(cryptoLength) + cryptbs.length + ",";
                ++i;
            }
        }
        req.setEncCertDN(dn);
        req.setCryptoText(Base64.decode(cryptoText[0]));
        req.setHashValue(allCrypto);
        req.setSymmetricalAlg(encAlg);
        req.setBankName(cryptoLength);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("decryptPCACEnvelope{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                byte[][] plainText = NetSignAgentUtil.splitTextFromTransValue(res.getPlainText());
                return plainText;
            }
            return null;
        }
        this.logString("decryptPCACEnvelope {connect to server failed}");
        return null;
    }

    public String rawSignHash(byte[] digest, String dn, String digestAlg) {
        this.logString("rawSignHash{origBytes:" + digest + ";dn:" + dn + "}");
        if (digest == null) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("RAWSignHashProcessor");
        req.setPlainText(digest);
        req.setSignCertDN(dn);
        req.setDigestAlg(digestAlg);
        req.setApiPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("rawSign{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                byte[] signed = res.getCryptoText();
                return Base64.encode(signed);
            }
            return null;
        }
        this.logString("rawSign{connect to server failed}");
        return null;
    }

    public boolean rawVerifyHash(byte[] digest, String signedStr, String dn, String digestAlg) {
        this.logString("rawVerifyHash{origBytes:" + digest + ";signedStr:" + signedStr + ";dn:" + dn + "}");
        if (digest == null || signedStr == null || "".equals(signedStr) || dn == null || "".equals(dn)) {
            this.returnCode = -1026;
            return false;
        }
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyHashProcessor");
        req.setCryptoText(Base64.decode(signedStr));
        req.setPlainText(digest);
        req.setSignCertDN(dn);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("rawVerifyHash{returnCode:" + this.returnCode + "}");
            return this.returnCode >= 0;
        }
        this.logString("rawVerifyHash{connect to server failed}");
        return false;
    }

    public String CUPNCPRawSign(byte[] plain, String dn, String digestAlg) {
        this.logString("CUPNCPRawSign{plain:" + plain + ";digestAlg:" + digestAlg + ";dn:" + dn + "}");
        if (plain == null || digestAlg == null || "".equals(digestAlg)) {
            this.returnCode = -1026;
            return null;
        }
        if ((digestAlg = digestAlg.toUpperCase()).equals("0")) {
            digestAlg = "SHA256";
        } else if (digestAlg.equals("1")) {
            digestAlg = "SM3";
        } else if (digestAlg.equals("SHA-256")) {
            digestAlg = "SHA256";
        }
        byte[] digest = null;
        if (digestAlg.equals("SM3")) {
            digest = SM3.SM3Digest(plain);
        } else {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA256", "INFOSEC");
                digest = md.digest(plain);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.returnCode = -100101;
                return null;
            }
        }
        NSMessage req = NetSignAgentUtil.createMessage("CUPNCPRawSignProcessor");
        req.setPlainText(digest);
        req.setSignCertDN(dn);
        req.setApiPasswd(this.pwd);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("rawSign{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                byte[] signed = res.getCryptoText();
                return Base64.encode(signed);
            }
            return null;
        }
        this.logString("rawSign{connect to server failed}");
        return null;
    }

    public boolean CUPNCPRawVerify(byte[] plain, String signature, String dn, String digestAlg) {
        this.logString("CUPNCPRawVerify{plain:" + plain + ";digestAlg:" + digestAlg + ";dn:" + dn + "}");
        if (plain == null || digestAlg == null || "".equals(digestAlg) || signature == null || "".equals(signature)) {
            this.returnCode = -1026;
            return false;
        }
        if ((digestAlg = digestAlg.toUpperCase()).equals("0")) {
            digestAlg = "SHA256";
        } else if (digestAlg.equals("1")) {
            digestAlg = "SM3";
        } else if (digestAlg.equals("SHA-256")) {
            digestAlg = "SHA256";
        }
        byte[] digest = null;
        if (digestAlg.equals("SM3")) {
            digest = SM3.SM3Digest(plain);
        } else {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA256", "INFOSEC");
                digest = md.digest(plain);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.returnCode = -100101;
                return false;
            }
        }
        NSMessage req = NetSignAgentUtil.createMessage("CUPNCPRawVerifyProcessor");
        req.setCryptoText(Base64.decode(signature));
        req.setPlainText(digest);
        req.setSignCertDN(dn);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("rawVerify{returnCode:" + this.returnCode + "}");
            return this.returnCode >= 0;
        }
        this.logString("rawSign{connect to server failed}");
        return false;
    }

    public String[] CUPNCPEncrypt(byte[] plain, String subject, String encAlg) {
        if (plain == null || subject == null || "".equals(subject)) {
            this.returnCode = -1026;
            return null;
        }
        if ("0".equals(encAlg)) {
            encAlg = "DESEde";
        }
        if ("1".equals(encAlg)) {
            encAlg = "SM4";
        }
        NSMessage req = NetSignAgentUtil.createMessage("CUPNCPEncryptProcessor");
        req.setPlainText(plain);
        req.setEncCertDN(subject);
        req.setSymmetricalAlg(encAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("CUPNCPEncrypt{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                byte[][] cryptoText = NetSignAgentUtil.splitTextFromTransValue(res.getCryptoText());
                String[] ret = new String[cryptoText.length];
                int i = 0;
                while (i < ret.length) {
                    ret[i] = Base64.encode(cryptoText[i]);
                    ++i;
                }
                return ret;
            }
            return null;
        }
        this.logString("CUPNCPEncrypt {connect to server failed}");
        return null;
    }

    public byte[] CUPNCPDecrypt(String[] cryptoText, String subject, String encAlg) {
        if (cryptoText == null || subject == null || "".equals(subject) || cryptoText.length < 2) {
            this.returnCode = -1026;
            return null;
        }
        if ("0".equals(encAlg)) {
            encAlg = "DESEde";
        }
        if ("1".equals(encAlg)) {
            encAlg = "SM4";
        }
        NSMessage req = NetSignAgentUtil.createMessage("CUPNCPDecryptProcessor");
        req.setEncCertDN(subject);
        req.setCryptoText(Base64.decode(cryptoText[0]));
        req.setHashValue(Base64.decode(cryptoText[1]));
        req.setSymmetricalAlg(encAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("CUPNCPDecrypt{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return res.getPlainText();
            }
            return null;
        }
        this.logString("CUPNCPDecrypt {connect to server failed}");
        return null;
    }

    public String CUPBCPRawSign(byte[] plain, String certID, String digestAlg) {
        if (plain == null || "".equals(certID)) {
            this.returnCode = -1026;
            return null;
        }
        digestAlg = digestAlg == null ? "SHA1" : digestAlg.toUpperCase();
        byte[] tbs = this.getCUPBCPPlain(plain, digestAlg);
        return this.rawSign(tbs, certID, digestAlg);
    }

    public boolean CUPBCPRawVerify(byte[] plain, String signature, String certID, String digestAlg) {
        if (plain == null || "".equals(certID) || signature == null || "".equals(signature)) {
            this.returnCode = -1026;
            return false;
        }
        digestAlg = digestAlg == null ? "SHA1" : digestAlg.toUpperCase();
        byte[] tbs = this.getCUPBCPPlain(plain, digestAlg);
        return this.rawVerify(tbs, signature, certID, digestAlg);
    }

    private byte[] getCUPBCPPlain(byte[] plain, String digestAlg) {
        byte[] digest = null;
        if ("SM3".equals(digestAlg)) {
            digest = SM3.SM3Digest(plain);
        } else {
            try {
                MessageDigest md = MessageDigest.getInstance(digestAlg, "INFOSEC");
                digest = md.digest(plain);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.returnCode = -100101;
                return null;
            }
        }
        return Utils.toHexString(digest).getBytes();
    }

    public String CUPBCPEncrypt(byte[] plain, String certID) {
        byte[] cipher = this.asymmEncrypt(plain, "/ECB/PKCS1Padding", certID);
        if (cipher != null) {
            return Base64.encode(cipher);
        }
        return null;
    }

    public byte[] CUPBCPDecrypt(String cryptoText, String certID) {
        if (cryptoText == null || cryptoText.length() == 0 || "".equals(certID)) {
            this.returnCode = -1026;
            return null;
        }
        return this.asymmDecrypt(Base64.decode(cryptoText), "/ECB/PKCS1Padding", certID);
    }

    public String CUPSTCRawSign(byte[] plain, String certID, String digestAlg) {
        if (plain == null || "".equals(certID)) {
            this.returnCode = -1026;
            return null;
        }
        byte[] tbs = this.getCUPSTCPlain(plain, digestAlg = digestAlg == null ? "SHA256" : digestAlg.toUpperCase());
        if (tbs == null) {
            return null;
        }
        return this.rawSign(tbs, certID, digestAlg);
    }

    private byte[] getCUPSTCPlain(byte[] plain, String digestAlg) {
        byte[] digest = null;
        if ("SM3".equals(digestAlg)) {
            digest = SM3.SM3Digest(plain);
        } else if ("SHA256".equals(digestAlg)) {
            SHA256Digest sha256Digest = new SHA256Digest();
            digest = new byte[32];
            sha256Digest.update(plain, 0, plain.length);
            sha256Digest.doFinal(digest, 0);
        } else {
            this.returnCode = -1111;
            return null;
        }
        return Utils.toHexString(digest).toUpperCase().getBytes();
    }

    public boolean CUPSTCRawVerify(byte[] plain, String signature, String certID, String digestAlg) {
        if (plain == null || "".equals(certID) || signature == null || "".equals(signature)) {
            this.returnCode = -1026;
            return false;
        }
        byte[] tbs = this.getCUPSTCPlain(plain, digestAlg = digestAlg == null ? "SHA256" : digestAlg.toUpperCase());
        if (tbs == null) {
            return false;
        }
        return this.rawVerify(tbs, signature, certID, digestAlg);
    }

    public String CUPSTCEncrypt(byte[] plain, String keyType) {
        if (keyType == null || !"1".equals(keyType) && !"3".equals(keyType)) {
            this.returnCode = -1050;
            return null;
        }
        String keylabel = "1".equals(keyType) ? CUPSTC_PINKEY : CUPSTC_TRANSKEY;
        byte[] enced = this.symmEncrypt(plain, keylabel, "/ECB/NoPadding");
        if (enced != null) {
            return Base64.encode(enced);
        }
        return null;
    }

    public byte[] CUPSTCDecrypt(String cryptoText, String keyType) {
        if (keyType == null || !"1".equals(keyType) && !"3".equals(keyType)) {
            this.returnCode = -1050;
            return null;
        }
        String keylabel = "1".equals(keyType) ? CUPSTC_PINKEY : CUPSTC_TRANSKEY;
        byte[] deced = this.symmDecrypt(Base64.decode(cryptoText), keylabel, "/ECB/NoPadding");
        if (deced != null && this.checkCUPSTCDATA(deced)) {
            return deced;
        }
        deced = this.symmDecrypt(Base64.decode(cryptoText), String.valueOf(keylabel) + ".bak", "/ECB/NoPadding");
        if (deced != null) {
            if (this.checkCUPSTCDATA(deced)) {
                return deced;
            }
            this.returnCode = -1014;
            return null;
        }
        return null;
    }

    private boolean checkCUPSTCDATA(byte[] decData) {
        String str = new String(decData).trim();
        return str.startsWith("{");
    }

    public String CUPSTCEncryptWorkingKey(String keyText, String certID) {
        byte[] plainText = null;
        plainText = keyText.getBytes();
        byte[] enced = this.asymmEncrypt(plainText, "/ECB/PKCS1Padding", certID);
        if (enced != null) {
            return Base64.encode(enced);
        }
        return null;
    }

    public String CUPSTCDecryptWorkingKey(String cryptoText, String certID) {
        byte[] deced = this.asymmDecrypt(Base64.decode(cryptoText), "/ECB/PKCS1Padding", certID);
        if (deced != null) {
            return new String(deced);
        }
        return null;
    }

    public boolean CUPSTCRenewKey(String keytype) {
        return false;
    }

    public boolean CUPSTCSetWorkingKey(String key, String keytype) {
        byte[] keyData;
        if (key == null || key.length() == 0 || keytype == null || "".equals(keytype)) {
            this.returnCode = -1026;
            return false;
        }
        if (!keytype.equals("1") && !keytype.equals("3")) {
            this.returnCode = -1050;
            return false;
        }
        if (key.length() % 2 == 1) {
            key = "0" + key;
        }
        if ((keyData = new BigInteger(key, 16).toByteArray()).length > key.length() / 2) {
            byte[] tmp = new byte[key.length() / 2];
            System.arraycopy(keyData, keyData.length - tmp.length, tmp, 0, tmp.length);
            keyData = tmp;
        }
        if (keytype.equals("1")) {
            return this.setWorkingKey(CUPSTC_PINKEY, keyData, "DESEde", true);
        }
        return this.setWorkingKey(CUPSTC_TRANSKEY, keyData, "DESEde", true);
    }

    public boolean setWorkingKey(String keyLabel, byte[] key, String keyType, boolean needBackup) {
        if (key == null || key.length == 0 || keyType == null || "".equals(keyType)) {
            this.returnCode = -1026;
            return false;
        }
        NSMessage req = NetSignAgentUtil.createMessage("SetSymmKeyProcessor");
        req.setBankID(keyLabel);
        req.setSymmetricalAlg(keyType);
        req.setPlainText(key);
        req.setTransCert(needBackup);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("setWorkingKey{returnCode:" + this.returnCode + "}");
            return this.returnCode >= 0;
        }
        this.logString("setWorkingKey{connect to server failed}");
        return false;
    }

    public byte[] asymmEncrypt(byte[] plain, String modAndPadding, String certID) {
        if (plain == null || plain.length == 0 || "".equals(certID) || modAndPadding == null || "".equals(modAndPadding)) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("UnSymmEncryptionProcessor");
        req.setBankID("enc");
        req.setSymmetricalAlg(modAndPadding);
        req.setPlainText(plain);
        req.setEncCertDN(certID);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("asymmEncrypt{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return res.getCryptoText();
            }
            return null;
        }
        this.logString("asymmEncrypt{connect to server failed}");
        return null;
    }

    public byte[] asymmDecrypt(byte[] cryptoText, String modAndPadding, String certID) {
        if (cryptoText == null || cryptoText.length == 0 || "".equals(certID) || modAndPadding == null || "".equals(modAndPadding)) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("UnSymmEncryptionProcessor");
        req.setBankID("dec");
        req.setSymmetricalAlg(modAndPadding);
        req.setCryptoText(cryptoText);
        req.setEncCertDN(certID);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("asymmDecrypt{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return res.getPlainText();
            }
            return null;
        }
        this.logString("asymmDecrypt{connect to server failed}");
        return null;
    }

    public byte[] symmEncrypt(byte[] plainText, byte[] key, String symmetricalAlg, String modAndPadding) {
        if (plainText == null || plainText.length == 0 || key == null || key.length == 0 || modAndPadding == null || "".equals(modAndPadding)) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("SymmEncryptionProcessor");
        req.setBankID("enc");
        req.setHashValue(key);
        req.setSymmetricalAlg(symmetricalAlg);
        req.setBankName(modAndPadding);
        req.setPlainText(plainText);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("symmEncrypt{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return res.getCryptoText();
            }
            return null;
        }
        this.logString("symmEncrypt{connect to server failed}");
        return null;
    }

    public byte[] symmEncrypt(byte[] plainText, String keyLabel, String modAndPadding) {
        if (plainText == null || plainText.length == 0 || keyLabel == null || "".equals(keyLabel) || modAndPadding == null || "".equals(modAndPadding)) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("SymmEncryptionProcessor");
        req.setBankID("enc");
        req.setEncCertDN(keyLabel);
        req.setBankName(modAndPadding);
        req.setPlainText(plainText);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("symmEncrypt{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return res.getCryptoText();
            }
            return null;
        }
        this.logString("symmEncrypt{connect to server failed}");
        return null;
    }

    public byte[] symmDecrypt(byte[] cryptoText, String keyLabel, String modAndPadding) {
        if (cryptoText == null || cryptoText.length == 0 || keyLabel == null || "".equals(keyLabel) || modAndPadding == null || "".equals(modAndPadding)) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("SymmEncryptionProcessor");
        req.setBankID("dec");
        req.setEncCertDN(keyLabel);
        req.setBankName(modAndPadding);
        req.setCryptoText(cryptoText);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("symmDecrypt{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return res.getPlainText();
            }
            return null;
        }
        this.logString("symmDecrypt{connect to server failed}");
        return null;
    }

    public byte[] symmDecrypt(byte[] cryptoText, byte[] key, String symmetricalAlg, String modAndPadding) {
        if (cryptoText == null || cryptoText.length == 0 || key == null || key.length == 0 || modAndPadding == null || "".equals(modAndPadding)) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("SymmEncryptionProcessor");
        req.setBankID("dec");
        req.setHashValue(key);
        req.setBankName(modAndPadding);
        req.setSymmetricalAlg(symmetricalAlg);
        req.setCryptoText(cryptoText);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("symmDecrypt{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return res.getPlainText();
            }
            return null;
        }
        this.logString("symmDecrypt{connect to server failed}");
        return null;
    }

    public void clientDebug(byte[] msg) {
        if (msg == null) {
            msg = "null".getBytes();
        }
        NSMessage req = NetSignAgentUtil.createMessage("ClientDebugProcessor");
        req.setPlainText(msg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
        } else {
            this.logString("CUPBCPDecrypt{connect to server failed}");
        }
    }

    public boolean equals(Poolable p) {
        return false;
    }

    public void init(Object para) throws Exception {
    }

    public void destory() throws Exception {
        this.closeSignServer();
    }

    public String messageDigest(byte[] plain, String digestAlg) {
        if (plain == null || digestAlg == null) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("MessageDigestProcessor");
        req.setPlainText(plain);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("messageDigest{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return Base64.encode(res.getCryptoText());
            }
            return null;
        }
        this.logString("messageDigest{connect to server failed}");
        return null;
    }

    public void setCUPSTCEncoding(String encoding) {
        this.CUPSTCEncoding = encoding;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String CUPSTCEncryptAndSign(String jsonMessage, String encryptCertID, String signCertID) {
        JsonObject jsonObject;
        String signature;
        block34: {
            JsonParser jsonParser = new JsonParser(this.CUPSTCEncoding);
            signature = null;
            String encryptResult = null;
            jsonObject = null;
            JsonValueObject encryptData = null;
            if (PBCAgent2GUtil.empty(jsonMessage) || PBCAgent2GUtil.empty(signCertID)) {
                this.returnCode = -1026;
                return null;
            }
            try {
                jsonObject = jsonParser.parse(jsonMessage.toCharArray());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.returnCode = -1060;
                return null;
            }
            if (PBCAgent2GUtil.empty(jsonObject)) {
                this.returnCode = -1062;
                return null;
            }
            String txnType = PBCAgent2GUtil.getValueByKey(jsonObject, "txnType");
            if (PBCAgent2GUtil.empty(txnType)) {
                this.returnCode = -1061;
                return null;
            }
            try {
                encryptData = (JsonValueObject)jsonObject.getValue("encryptData");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.returnCode = -1063;
                return null;
            }
            if (PBCAgent2GUtil.empty(encryptData) && !txnType.equals("SA008")) {
                this.returnCode = -1061;
                return null;
            }
            if ("SA009".equals(txnType)) {
                JsonObject encryptJson = (JsonObject)encryptData.getValue();
                String newKey = PBCAgent2GUtil.getValueByKey(encryptJson, "newKey");
                String keyTp = PBCAgent2GUtil.getValueByKey(encryptJson, "keyTp");
                String keyLb = PBCAgent2GUtil.getValueByKey(encryptJson, "keyLabel");
                if (!(!PBCAgent2GUtil.notEmpty(newKey) || PBCAgent2GUtil.empty(keyTp) && PBCAgent2GUtil.empty(keyLb))) {
                    this.CUPSTCSetWorkingKey(newKey, keyTp, keyLb);
                    if (this.getReturnCode() < 0) {
                        return null;
                    }
                }
                if (PBCAgent2GUtil.empty(encryptCertID)) {
                    this.returnCode = -1026;
                    return null;
                }
                encryptResult = this.CUPSTCEncryptWorkingKey(encryptData.toJson(), encryptCertID);
                if (this.getReturnCode() < 0) {
                    return null;
                }
                if (PBCAgent2GUtil.empty(encryptResult)) {
                    this.returnCode = -1080;
                    return null;
                }
                PBCAgent2GUtil.putStringToJson(jsonObject, "encryptData", encryptResult);
            } else {
                if ("SA008".equals(txnType)) {
                    if (PBCAgent2GUtil.notEmpty(encryptData)) {
                        try {
                            encryptResult = this.CUPSTCEncrypt(encryptData.toJson().getBytes(this.CUPSTCEncoding), "3");
                            if (this.getReturnCode() < 0) {
                                return null;
                            }
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        if (PBCAgent2GUtil.empty(encryptResult)) {
                            this.returnCode = -1080;
                            return null;
                        }
                        PBCAgent2GUtil.putStringToJson(jsonObject, "encryptData", encryptResult);
                    }
                    GenericCertificate[] certs = this.getGenericCertificate(signCertID);
                    if (this.getReturnCode() < 0) {
                        return null;
                    }
                    if (certs != null && certs[0] != null) {
                        String cert = certs[0].getBase64Cert();
                        if (!PBCAgent2GUtil.notEmpty(cert)) {
                            this.returnCode = -1091;
                            return null;
                        }
                        PBCAgent2GUtil.putStringToJson(jsonObject, "cerFile", cert);
                        break block34;
                    } else {
                        this.returnCode = -1090;
                        return null;
                    }
                }
                try {
                    encryptResult = this.CUPSTCEncrypt(encryptData.toJson().getBytes(this.CUPSTCEncoding), "3");
                    if (this.getReturnCode() < 0) {
                        return null;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                if (PBCAgent2GUtil.empty(encryptResult)) {
                    this.returnCode = -1080;
                    return null;
                }
                PBCAgent2GUtil.putStringToJson(jsonObject, "encryptData", encryptResult);
            }
        }
        JsonValueObject riskInfo = (JsonValueObject)jsonObject.getValue("riskInfo");
        if (PBCAgent2GUtil.notEmpty(riskInfo)) {
            PBCAgent2GUtil.putStringToJson(jsonObject, "riskInfo", Base64.encode(riskInfo.toJson().getBytes()));
        }
        String signString = PBCAgent2GUtil.getCUPSTCSignString(jsonObject);
        try {
            signature = this.CUPSTCRawSign(signString.getBytes(this.CUPSTCEncoding), signCertID, "SHA256");
            if (this.getReturnCode() < 0) {
                return null;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (PBCAgent2GUtil.notEmpty(signature)) {
            PBCAgent2GUtil.putStringToJson(jsonObject, "signature", signature);
            return jsonObject.toJson();
        }
        this.returnCode = -1100;
        return null;
    }

    public String CUPSTCDecryptAndVerify(String jsonMessage, String encryptCertID, String signCertID) {
        JsonParser jsonParser = new JsonParser(this.CUPSTCEncoding);
        JsonObject jsonObject = null;
        if (PBCAgent2GUtil.empty(jsonMessage) || PBCAgent2GUtil.empty(signCertID)) {
            this.returnCode = -1026;
            return null;
        }
        try {
            jsonObject = jsonParser.parse(jsonMessage.toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.returnCode = -1060;
            return null;
        }
        if (jsonObject == null) {
            this.returnCode = -1062;
            return null;
        }
        String signature = PBCAgent2GUtil.getValueByKey(jsonObject, "signature");
        if (PBCAgent2GUtil.notEmpty(signature)) {
            this.CUPSTCRawVerify(PBCAgent2GUtil.getCUPSTCSignString(jsonObject).getBytes(), signature, signCertID, "SHA256");
            if (this.getReturnCode() < 0) {
                return null;
            }
        } else {
            this.returnCode = -1061;
            return null;
        }
        String riskInfo = PBCAgent2GUtil.getValueByKey(jsonObject, "riskInfo");
        if (PBCAgent2GUtil.notEmpty(riskInfo)) {
            try {
                String decryptRiskInfo = new String(Base64.decode(riskInfo), this.CUPSTCEncoding);
                PBCAgent2GUtil.putObjectToJson(jsonObject, "riskInfo", decryptRiskInfo, jsonParser);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        String decryptMessage = null;
        String txnType = PBCAgent2GUtil.getValueByKey(jsonObject, "txnType");
        if (PBCAgent2GUtil.empty(txnType)) {
            this.returnCode = -1061;
            return null;
        }
        String encryptData = PBCAgent2GUtil.getValueByKey(jsonObject, "encryptData");
        if (PBCAgent2GUtil.empty(encryptData) && !"SA008".equals(txnType)) {
            this.returnCode = -1061;
            return null;
        }
        if ("SA009".equals(txnType)) {
            if (PBCAgent2GUtil.empty(encryptCertID)) {
                this.returnCode = -1026;
                return null;
            }
            decryptMessage = this.CUPSTCDecryptWorkingKey(encryptData, encryptCertID);
            if (this.getReturnCode() < 0) {
                return null;
            }
            JsonObject decryptJson = null;
            if (PBCAgent2GUtil.empty(decryptMessage)) {
                this.returnCode = -1110;
                return null;
            }
            try {
                decryptJson = jsonParser.parse(decryptMessage.toCharArray());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.returnCode = -1060;
                return null;
            }
            String newKey = PBCAgent2GUtil.getValueByKey(decryptJson, "newKey");
            String keyTp = PBCAgent2GUtil.getValueByKey(decryptJson, "keyTp");
            String keyLb = PBCAgent2GUtil.getValueByKey(decryptJson, "keyLabel");
            if (!(!PBCAgent2GUtil.notEmpty(newKey) || PBCAgent2GUtil.empty(keyTp) && PBCAgent2GUtil.empty(keyLb))) {
                this.CUPSTCSetWorkingKey(newKey, keyTp, keyLb);
                if (this.getReturnCode() < 0) {
                    return null;
                }
            } else {
                this.returnCode = -1070;
                return null;
            }
            PBCAgent2GUtil.putObjectToJson(jsonObject, "encryptData", decryptMessage, jsonParser);
        } else if ("SA008".equals(txnType)) {
            if (PBCAgent2GUtil.notEmpty(encryptData)) {
                byte[] bs = this.CUPSTCDecrypt(encryptData, "3");
                if (this.getReturnCode() < 0) {
                    return null;
                }
                if (bs == null) {
                    this.returnCode = -1110;
                    return null;
                }
                try {
                    decryptMessage = new String(bs, this.CUPSTCEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                if (PBCAgent2GUtil.empty(decryptMessage)) {
                    this.returnCode = -1110;
                    return null;
                }
                PBCAgent2GUtil.putObjectToJson(jsonObject, "encryptData", decryptMessage, jsonParser);
            }
            X509Certificate certificate = null;
            String cerFile = PBCAgent2GUtil.getValueByKey(jsonObject, "cerFile");
            if (PBCAgent2GUtil.notEmpty(cerFile)) {
                try {
                    certificate = NetSignAgent.generateCertificate(cerFile.getBytes());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.returnCode = -1061;
                return null;
            }
            this.uploadCert(null, certificate);
            if (this.getReturnCode() < 0) {
                return null;
            }
        } else {
            byte[] bs = this.CUPSTCDecrypt(encryptData, "3");
            if (this.getReturnCode() < 0) {
                return null;
            }
            if (bs == null) {
                this.returnCode = -1110;
                return null;
            }
            try {
                decryptMessage = new String(bs, this.CUPSTCEncoding);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (PBCAgent2GUtil.empty(decryptMessage)) {
                this.returnCode = -1110;
                return null;
            }
            PBCAgent2GUtil.putObjectToJson(jsonObject, "encryptData", decryptMessage, jsonParser);
        }
        return jsonObject.toJson();
    }

    public boolean CUPSTCSetWorkingKey(String key, String keyType, String keyLabel) {
        byte[] keyData;
        if (PBCAgent2GUtil.empty(key) || PBCAgent2GUtil.empty(keyType) && PBCAgent2GUtil.empty(keyLabel)) {
            this.returnCode = -1026;
            return false;
        }
        if (key.length() % 2 == 1) {
            key = "0" + key;
        }
        if ((keyData = new BigInteger(key, 16).toByteArray()).length > key.length() / 2) {
            byte[] tmp = new byte[key.length() / 2];
            System.arraycopy(keyData, keyData.length - tmp.length, tmp, 0, tmp.length);
            keyData = tmp;
        }
        String tem = null;
        if (PBCAgent2GUtil.empty(keyLabel)) {
            if (!"1".equals(keyType) && !"3".equals(keyType)) {
                this.returnCode = -1050;
                return false;
            }
            tem = "1".equals(keyType) ? CUPSTC_PINKEY : CUPSTC_TRANSKEY;
        } else if (keyLabel.matches("^[0-9A-Za-z_]{1,50}$")) {
            tem = keyLabel;
        } else {
            this.returnCode = -1050;
            return false;
        }
        return this.setWorkingKey(tem, keyData, "DESEde", true);
    }

    public String CUPSTCEncrypt(byte[] plain, String keyType, String keyLabel) {
        byte[] enced = null;
        String tem = null;
        if (PBCAgent2GUtil.empty(keyType) && PBCAgent2GUtil.empty(keyLabel) || PBCAgent2GUtil.empty(plain)) {
            this.returnCode = -1026;
            return null;
        }
        if (PBCAgent2GUtil.empty(keyLabel)) {
            if (!"1".equals(keyType) && !"3".equals(keyType)) {
                this.returnCode = -1050;
                return null;
            }
            tem = "1".equals(keyType) ? CUPSTC_PINKEY : CUPSTC_TRANSKEY;
        } else {
            tem = keyLabel;
        }
        enced = this.symmEncrypt(plain, tem, "/ECB/NoPadding");
        if (enced != null) {
            return Base64.encode(enced);
        }
        return null;
    }

    public byte[] CUPSTCDecrypt(String cryptoText, String keyType, String keyLabel) {
        byte[] deced = null;
        String tem = null;
        if (PBCAgent2GUtil.empty(keyType) && PBCAgent2GUtil.empty(keyLabel)) {
            this.returnCode = -1026;
            return null;
        }
        if (PBCAgent2GUtil.empty(keyLabel)) {
            if (!"1".equals(keyType) && !"3".equals(keyType)) {
                this.returnCode = -1050;
                return null;
            }
            tem = "1".equals(keyType) ? CUPSTC_PINKEY : CUPSTC_TRANSKEY;
        } else {
            tem = keyLabel;
        }
        deced = this.symmDecrypt(Base64.decode(cryptoText), tem, "/ECB/NoPadding");
        if (deced != null && this.checkCUPSTCDATA(deced)) {
            return deced;
        }
        deced = this.symmDecrypt(Base64.decode(cryptoText), String.valueOf(tem) + ".bak", "/ECB/NoPadding");
        if (deced != null) {
            if (this.checkCUPSTCDATA(deced)) {
                return deced;
            }
            this.returnCode = -1014;
            return null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String CUPSTCEncryptAndSign(String jsonMessage, String encryptCertID, String signCertID, String traKeyLabel, String pinKeyLabel) {
        JsonObject jsonObject;
        block34: {
            JsonParser jsonParser = new JsonParser(this.CUPSTCEncoding);
            if (PBCAgent2GUtil.empty(jsonMessage) || PBCAgent2GUtil.empty(signCertID)) {
                this.returnCode = -1026;
                return null;
            }
            try {
                jsonObject = jsonParser.parse(jsonMessage.toCharArray());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.returnCode = -1060;
                return null;
            }
            if (jsonObject == null) {
                this.returnCode = -1062;
                return null;
            }
            String txnType = PBCAgent2GUtil.getValueByKey(jsonObject, "txnType");
            if (PBCAgent2GUtil.empty(txnType)) {
                this.returnCode = -1061;
                return null;
            }
            JsonValueObject encryptData = null;
            try {
                encryptData = (JsonValueObject)jsonObject.getValue("encryptData");
            }
            catch (Exception e1) {
                e1.printStackTrace();
                this.returnCode = -1063;
                return null;
            }
            if (PBCAgent2GUtil.empty(encryptData) && !txnType.equals("SA008")) {
                this.returnCode = -1061;
                return null;
            }
            String encryptResult = null;
            if ("SA009".equals(txnType)) {
                JsonObject encryptJson = (JsonObject)encryptData.getValue();
                String newKey = PBCAgent2GUtil.getValueByKey(encryptJson, "newKey");
                String keyTp = PBCAgent2GUtil.getValueByKey(encryptJson, "keyTp");
                String keyLb = PBCAgent2GUtil.getValueByKey(encryptJson, "keyLabel");
                if (!(!PBCAgent2GUtil.notEmpty(newKey) || PBCAgent2GUtil.empty(keyTp) && PBCAgent2GUtil.empty(keyLb))) {
                    this.CUPSTCSetWorkingKey(newKey, keyTp, keyLb);
                    if (this.getReturnCode() < 0) {
                        return null;
                    }
                }
                if (PBCAgent2GUtil.empty(encryptCertID)) {
                    this.returnCode = -1026;
                    return null;
                }
                encryptResult = this.CUPSTCEncryptWorkingKey(encryptData.toJson(), encryptCertID);
                if (this.getReturnCode() < 0) {
                    return null;
                }
                if (PBCAgent2GUtil.empty(encryptResult)) {
                    this.returnCode = -1080;
                    return null;
                }
                PBCAgent2GUtil.putStringToJson(jsonObject, "encryptData", encryptResult);
            } else {
                if ("SA008".equals(txnType)) {
                    if (PBCAgent2GUtil.notEmpty(encryptData)) {
                        try {
                            encryptResult = this.CUPSTCEncrypt(encryptData.toJson().getBytes(this.CUPSTCEncoding), "3", traKeyLabel);
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        if (this.getReturnCode() < 0) {
                            return null;
                        }
                        if (PBCAgent2GUtil.empty(encryptResult)) {
                            this.returnCode = -1080;
                            return null;
                        }
                        PBCAgent2GUtil.putStringToJson(jsonObject, "encryptData", encryptResult);
                    }
                    GenericCertificate[] certs = this.getGenericCertificate(signCertID);
                    if (this.getReturnCode() < 0) {
                        return null;
                    }
                    if (certs != null && certs[0] != null) {
                        String cert = certs[0].getBase64Cert();
                        if (!PBCAgent2GUtil.notEmpty(cert)) {
                            this.returnCode = -1091;
                            return null;
                        }
                        PBCAgent2GUtil.putStringToJson(jsonObject, "cerFile", cert);
                        break block34;
                    } else {
                        this.returnCode = -1090;
                        return null;
                    }
                }
                try {
                    encryptResult = this.CUPSTCEncrypt(encryptData.toJson().getBytes(this.CUPSTCEncoding), "3", traKeyLabel);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                if (this.getReturnCode() < 0) {
                    return null;
                }
                if (PBCAgent2GUtil.empty(encryptResult)) {
                    this.returnCode = -1080;
                    return null;
                }
                PBCAgent2GUtil.putStringToJson(jsonObject, "encryptData", encryptResult);
            }
        }
        JsonValueObject riskInfo = (JsonValueObject)jsonObject.getValue("riskInfo");
        if (PBCAgent2GUtil.notEmpty(riskInfo)) {
            PBCAgent2GUtil.putStringToJson(jsonObject, "riskInfo", Base64.encode(riskInfo.toJson().getBytes()));
        }
        String signString = PBCAgent2GUtil.getCUPSTCSignString(jsonObject);
        String signature = null;
        try {
            signature = this.CUPSTCRawSign(signString.getBytes(this.CUPSTCEncoding), signCertID, "SHA256");
            if (this.getReturnCode() < 0) {
                return null;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (PBCAgent2GUtil.notEmpty(signature)) {
            PBCAgent2GUtil.putStringToJson(jsonObject, "signature", signature);
            return jsonObject.toJson();
        }
        this.returnCode = -1100;
        return null;
    }

    public String CUPSTCDecryptAndVerify(String jsonMessage, String encryptCertID, String signCertID, String traKeyLabel, String pinKeyLabel) {
        JsonParser jsonParser = new JsonParser(this.CUPSTCEncoding);
        JsonObject jsonObject = null;
        if (PBCAgent2GUtil.empty(jsonMessage) || PBCAgent2GUtil.empty(signCertID)) {
            this.returnCode = -1026;
            return null;
        }
        try {
            jsonObject = jsonParser.parse(jsonMessage.toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.returnCode = -1060;
            return null;
        }
        if (jsonObject == null) {
            this.returnCode = -1062;
            return null;
        }
        String signature = PBCAgent2GUtil.getValueByKey(jsonObject, "signature");
        if (PBCAgent2GUtil.notEmpty(signature)) {
            this.CUPSTCRawVerify(PBCAgent2GUtil.getCUPSTCSignString(jsonObject).getBytes(), signature, signCertID, "SHA256");
            if (this.getReturnCode() < 0) {
                return null;
            }
        } else {
            this.returnCode = -1061;
            return null;
        }
        String riskInfo = PBCAgent2GUtil.getValueByKey(jsonObject, "riskInfo");
        if (PBCAgent2GUtil.notEmpty(riskInfo)) {
            try {
                String decryptRiskInfo = new String(Base64.decode(riskInfo), this.CUPSTCEncoding);
                PBCAgent2GUtil.putObjectToJson(jsonObject, "riskInfo", decryptRiskInfo, jsonParser);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        String decryptMessage = null;
        String txnType = PBCAgent2GUtil.getValueByKey(jsonObject, "txnType");
        if (PBCAgent2GUtil.empty(txnType)) {
            this.returnCode = -1061;
            return null;
        }
        String encryptData = PBCAgent2GUtil.getValueByKey(jsonObject, "encryptData");
        if (PBCAgent2GUtil.empty(encryptData) && !"SA008".equals(txnType)) {
            this.returnCode = -1061;
            return null;
        }
        if ("SA009".equals(txnType)) {
            if (PBCAgent2GUtil.empty(encryptCertID)) {
                this.returnCode = -1026;
                return null;
            }
            decryptMessage = this.CUPSTCDecryptWorkingKey(encryptData, encryptCertID);
            if (this.getReturnCode() < 0) {
                return null;
            }
            JsonObject decryptJson = null;
            if (PBCAgent2GUtil.empty(decryptMessage)) {
                this.returnCode = -1110;
                return null;
            }
            try {
                decryptJson = jsonParser.parse(decryptMessage.toCharArray());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.returnCode = -1060;
                return null;
            }
            String newKey = PBCAgent2GUtil.getValueByKey(decryptJson, "newKey");
            String keyTp = PBCAgent2GUtil.getValueByKey(decryptJson, "keyTp");
            String keyLb = PBCAgent2GUtil.getValueByKey(decryptJson, "keyLabel");
            if (!(!PBCAgent2GUtil.notEmpty(newKey) || PBCAgent2GUtil.empty(keyTp) && PBCAgent2GUtil.empty(keyLb))) {
                this.CUPSTCSetWorkingKey(newKey, keyTp, keyLb);
                if (this.getReturnCode() < 0) {
                    return null;
                }
            } else {
                this.returnCode = -1070;
                return null;
            }
            PBCAgent2GUtil.putObjectToJson(jsonObject, "encryptData", decryptMessage, jsonParser);
        } else if ("SA008".equals(txnType)) {
            if (PBCAgent2GUtil.notEmpty(encryptData)) {
                byte[] bs = this.CUPSTCDecrypt(encryptData, "3", traKeyLabel);
                if (this.getReturnCode() < 0) {
                    return null;
                }
                if (bs == null) {
                    this.returnCode = -1110;
                    return null;
                }
                try {
                    decryptMessage = new String(bs, this.CUPSTCEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                if (PBCAgent2GUtil.empty(decryptMessage)) {
                    this.returnCode = -1110;
                    return null;
                }
                PBCAgent2GUtil.putObjectToJson(jsonObject, "encryptData", decryptMessage, jsonParser);
            }
            X509Certificate certificate = null;
            String cerFile = PBCAgent2GUtil.getValueByKey(jsonObject, "cerFile");
            if (PBCAgent2GUtil.notEmpty(cerFile)) {
                try {
                    certificate = NetSignAgent.generateCertificate(cerFile.getBytes());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.returnCode = -1061;
                return null;
            }
            this.uploadCert(null, certificate);
            if (this.getReturnCode() < 0) {
                return null;
            }
        } else {
            byte[] bs = this.CUPSTCDecrypt(encryptData, "3", traKeyLabel);
            if (this.getReturnCode() < 0) {
                return null;
            }
            if (bs == null) {
                this.returnCode = -1110;
                return null;
            }
            try {
                decryptMessage = new String(bs, this.CUPSTCEncoding);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (PBCAgent2GUtil.empty(decryptMessage)) {
                this.returnCode = -1110;
                return null;
            }
            PBCAgent2GUtil.putObjectToJson(jsonObject, "encryptData", decryptMessage, jsonParser);
        }
        return jsonObject.toJson();
    }

    public String CUPCQPEncryptAndSign(String jsonMessage, String encryptCertID, String signCertID) {
        if (PBCAgent2GUtil.empty(jsonMessage)) {
            this.returnCode = -1026;
            return null;
        }
        JsonObject jsonObject = null;
        JsonParser jsonParser = new JsonParser("utf-8");
        try {
            jsonObject = jsonParser.parse(jsonMessage.toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.returnCode = -1060;
            return null;
        }
        if (jsonObject == null) {
            this.returnCode = -1062;
            return null;
        }
        String cardNo = PBCAgent2GUtil.getValueByKey(jsonObject, "cardNo");
        String mobile = PBCAgent2GUtil.getValueByKey(jsonObject, "mobile");
        String realNm = PBCAgent2GUtil.getValueByKey(jsonObject, "realNm");
        String certifId = PBCAgent2GUtil.getValueByKey(jsonObject, "certifId");
        String accType = PBCAgent2GUtil.getValueByKey(jsonObject, "accType");
        String certType = PBCAgent2GUtil.getValueByKey(jsonObject, "certType");
        boolean encrypt = false;
        if (PBCAgent2GUtil.notEmpty(cardNo) && PBCAgent2GUtil.notEmpty(mobile) && PBCAgent2GUtil.notEmpty(realNm) && PBCAgent2GUtil.notEmpty(certifId)) {
            if (!PBCAgent2GUtil.notEmpty(accType)) {
                accType = "01";
                PBCAgent2GUtil.putStringToJson(jsonObject, "accType", accType);
            }
            if (!PBCAgent2GUtil.notEmpty(certType)) {
                certType = "01";
                PBCAgent2GUtil.putStringToJson(jsonObject, "certType", certType);
            }
            encrypt = true;
        }
        if (!"NoSign".equals(signCertID)) {
            String appId = PBCAgent2GUtil.getValueByKey(jsonObject, "appId");
            if (PBCAgent2GUtil.empty(appId)) {
                this.returnCode = -1061;
                return null;
            }
            String indUsrId = PBCAgent2GUtil.getValueByKey(jsonObject, "indUsrId");
            if (PBCAgent2GUtil.empty(indUsrId)) {
                this.returnCode = -1061;
                return null;
            }
            String nonceStr = PBCAgent2GUtil.getValueByKey(jsonObject, "nonceStr");
            if (PBCAgent2GUtil.empty(nonceStr)) {
                this.returnCode = -1061;
                return null;
            }
            String timestamp = PBCAgent2GUtil.getValueByKey(jsonObject, "timestamp");
            if (PBCAgent2GUtil.empty(timestamp)) {
                this.returnCode = -1061;
                return null;
            }
            String chn1 = PBCAgent2GUtil.getValueByKey(jsonObject, "chnl");
            if (PBCAgent2GUtil.empty(chn1)) {
                this.returnCode = -1061;
                return null;
            }
            String signature = null;
            try {
                String signString = PBCAgent2GUtil.getCUPCQSignString(jsonObject);
                signature = this.rawSign(signString.getBytes("utf-8"), signCertID, "SHA256");
                if (this.getReturnCode() < 0) {
                    return null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (PBCAgent2GUtil.notEmpty(signature)) {
                PBCAgent2GUtil.putStringToJson(jsonObject, "signature", signature);
            } else {
                this.returnCode = -1100;
                return null;
            }
        }
        if (encrypt) {
            byte[] key = new byte[24];
            byte[] keys = new byte[16];
            new NSRandom().nextBytes(keys);
            System.arraycopy(keys, 0, key, 0, 16);
            System.arraycopy(keys, 0, key, 16, 8);
            byte[] enced = this.asymmEncrypt(key, "/ECB/PKCS1Padding", encryptCertID);
            if (this.getReturnCode() < 0) {
                return null;
            }
            if (enced == null) {
                this.returnCode = -1080;
                return null;
            }
            PBCAgent2GUtil.putStringToJson(jsonObject, "symmetricKey", Base64.encode(enced));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("cardNo", cardNo);
            map.put("mobile", mobile);
            map.put("realNm", realNm);
            map.put("certifId", certifId);
            map.put("accType", accType);
            map.put("certType", certType);
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String keyTem = (String)entry.getKey();
                String valueTem = (String)entry.getValue();
                String Tem = PBCAgent2GUtil.symmEncryptLocal(valueTem, key, "DESede", "/ECB/PKCS5Padding");
                if (!PBCAgent2GUtil.notEmpty(Tem)) {
                    this.returnCode = -1015;
                    return null;
                }
                PBCAgent2GUtil.putStringToJson(jsonObject, keyTem, Tem);
            }
        } else if (PBCAgent2GUtil.notEmpty(cardNo) || PBCAgent2GUtil.notEmpty(mobile) || PBCAgent2GUtil.notEmpty(realNm) || PBCAgent2GUtil.notEmpty(certifId) || PBCAgent2GUtil.notEmpty(accType) || PBCAgent2GUtil.notEmpty(certType)) {
            this.returnCode = -1061;
            return null;
        }
        return jsonObject.toJson();
    }

    public String CUPCQPDecryptAndVerify(String jsonMessage, String encryptCertID, String signCertID) {
        String signature;
        if (PBCAgent2GUtil.empty(jsonMessage)) {
            this.returnCode = -1026;
            return null;
        }
        JsonObject jsonObject = null;
        JsonParser jsonParser = new JsonParser("utf-8");
        try {
            jsonObject = jsonParser.parse(jsonMessage.toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.returnCode = -1060;
            return null;
        }
        if (jsonObject == null) {
            this.returnCode = -1062;
            return null;
        }
        String symmetricKey = PBCAgent2GUtil.getValueByKey(jsonObject, "symmetricKey");
        if (PBCAgent2GUtil.notEmpty(symmetricKey)) {
            byte[] key = this.asymmDecrypt(Base64.decode(symmetricKey), "/ECB/PKCS1Padding", encryptCertID);
            if (this.getReturnCode() < 0) {
                return null;
            }
            if (key == null) {
                this.returnCode = -1110;
                return null;
            }
            String cardNo = PBCAgent2GUtil.getValueByKey(jsonObject, "cardNo");
            String mobile = PBCAgent2GUtil.getValueByKey(jsonObject, "mobile");
            String realNm = PBCAgent2GUtil.getValueByKey(jsonObject, "realNm");
            String certifId = PBCAgent2GUtil.getValueByKey(jsonObject, "certifId");
            String certType = PBCAgent2GUtil.getValueByKey(jsonObject, "certType");
            String accType = PBCAgent2GUtil.getValueByKey(jsonObject, "accType");
            if (PBCAgent2GUtil.notEmpty(cardNo) && PBCAgent2GUtil.notEmpty(mobile) && PBCAgent2GUtil.notEmpty(realNm) && PBCAgent2GUtil.notEmpty(certifId) && PBCAgent2GUtil.notEmpty(accType) && PBCAgent2GUtil.notEmpty(certType)) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("cardNo", cardNo);
                map.put("mobile", mobile);
                map.put("realNm", realNm);
                map.put("certifId", certifId);
                map.put("certType", certType);
                map.put("accType", accType);
                Iterator it = map.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String keyTem = (String)entry.getKey();
                    String valueTem = (String)entry.getValue();
                    String Tem = PBCAgent2GUtil.symmDecryptLocal(valueTem, key, "DESede", "/ECB/PKCS5Padding");
                    if (!PBCAgent2GUtil.notEmpty(Tem)) {
                        this.returnCode = -1016;
                        return null;
                    }
                    PBCAgent2GUtil.putStringToJson(jsonObject, keyTem, Tem);
                }
            } else {
                this.returnCode = -1061;
                return null;
            }
        }
        if (PBCAgent2GUtil.notEmpty(signature = PBCAgent2GUtil.getValueByKey(jsonObject, "signature"))) {
            try {
                String signString = PBCAgent2GUtil.getCUPCQSignString(jsonObject);
                this.rawVerify(signString.getBytes("utf-8"), signature, signCertID, "SHA256");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (this.getReturnCode() < 0) {
                return null;
            }
        }
        return jsonObject.toJson();
    }

    public String CUPCQPEncAndSign(String jsonMessage, String encryptCertID, String signCertID) {
        if ("".equals(jsonMessage) || jsonMessage == null) {
            this.returnCode = -1026;
            return null;
        }
        JsonObject jsonObject = null;
        JsonParser jsonParser = new JsonParser("utf-8");
        try {
            jsonObject = jsonParser.parse(jsonMessage.toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.returnCode = -1060;
            return null;
        }
        if (jsonObject == null) {
            this.returnCode = -1062;
            return null;
        }
        String cardNo = PBCAgent2GUtil.getValueByKey(jsonObject, "cardNo");
        String mobile = PBCAgent2GUtil.getValueByKey(jsonObject, "mobile");
        String realNm = PBCAgent2GUtil.getValueByKey(jsonObject, "realNm");
        String certifId = PBCAgent2GUtil.getValueByKey(jsonObject, "certifId");
        String accType = PBCAgent2GUtil.getValueByKey(jsonObject, "accType");
        String certType = PBCAgent2GUtil.getValueByKey(jsonObject, "certType");
        boolean encrypt = false;
        if (PBCAgent2GUtil.notEmpty(cardNo) && PBCAgent2GUtil.notEmpty(mobile) && PBCAgent2GUtil.notEmpty(realNm) && PBCAgent2GUtil.notEmpty(certifId)) {
            if (!PBCAgent2GUtil.notEmpty(accType)) {
                accType = "01";
                PBCAgent2GUtil.putStringToJson(jsonObject, "accType", accType);
            }
            if (!PBCAgent2GUtil.notEmpty(certType)) {
                certType = "01";
                PBCAgent2GUtil.putStringToJson(jsonObject, "certType", certType);
            }
            encrypt = true;
        }
        if (!"NoSign".equals(signCertID)) {
            String appId = PBCAgent2GUtil.getValueByKey(jsonObject, "appId");
            if (appId == null || "".equals(appId)) {
                this.returnCode = -1061;
                return null;
            }
            String indUsrId = PBCAgent2GUtil.getValueByKey(jsonObject, "indUsrId");
            if (indUsrId == null || "".equals(indUsrId)) {
                this.returnCode = -1061;
                return null;
            }
            String nonceStr = PBCAgent2GUtil.getValueByKey(jsonObject, "nonceStr");
            if (nonceStr == null || "".equals(nonceStr)) {
                this.returnCode = -1061;
                return null;
            }
            String timestamp = PBCAgent2GUtil.getValueByKey(jsonObject, "timestamp");
            if (timestamp == null || "".equals(timestamp)) {
                this.returnCode = -1061;
                return null;
            }
            String chnl = PBCAgent2GUtil.getValueByKey(jsonObject, "chnl");
            if (chnl == null || "".equals(chnl)) {
                this.returnCode = -1061;
                return null;
            }
            String signature = null;
            try {
                String signString = PBCAgent2GUtil.getCUPCQSignString(jsonObject);
                signature = this.rawSign(signString.getBytes("utf-8"), signCertID, "SHA256");
                if (this.getReturnCode() < 0) {
                    return null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!"".equals(signature) && signature != null) {
                PBCAgent2GUtil.putStringToJson(jsonObject, "signature", signature);
            } else {
                this.returnCode = -1100;
                return null;
            }
        }
        if (encrypt) {
            JsonObject newJsonObj = new JsonObject();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("infosecEncoding", "utf-8");
            map.put("cardNo", cardNo);
            map.put("mobile", mobile);
            map.put("realNm", realNm);
            map.put("certifId", certifId);
            map.put("accType", accType);
            map.put("certType", certType);
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry item = it.next();
                JsonValueString jsonString = new JsonValueString();
                jsonString.setValue((String)item.getValue());
                newJsonObj.put((String)item.getKey(), jsonString);
            }
            String jsonString = this.CUPCQPEncryptJson(newJsonObj.toJson(), encryptCertID);
            if (jsonString == null) {
                if (this.returnCode == 0) {
                    this.returnCode = -1080;
                }
                return null;
            }
            newJsonObj = jsonParser.parse(jsonString.toCharArray());
            Enumeration keyNames = newJsonObj.getNames();
            while (keyNames.hasMoreElements()) {
                String key = (String)keyNames.nextElement();
                PBCAgent2GUtil.putStringToJson(jsonObject, key, PBCAgent2GUtil.getValueByKey(newJsonObj, key));
            }
        } else if (PBCAgent2GUtil.notEmpty(cardNo) || PBCAgent2GUtil.notEmpty(mobile) || PBCAgent2GUtil.notEmpty(realNm) || PBCAgent2GUtil.notEmpty(certifId) || PBCAgent2GUtil.notEmpty(accType) || PBCAgent2GUtil.notEmpty(certType)) {
            this.returnCode = -1061;
            return null;
        }
        return jsonObject.toJson();
    }

    public String CUPCQPVerifyAndDec(String jsonMessage, String encryptCertID, String signCertID) {
        String signature;
        if ("".equals(jsonMessage) || jsonMessage == null) {
            this.returnCode = -1026;
            return null;
        }
        JsonObject jsonObject = null;
        JsonParser jsonParser = new JsonParser("utf-8");
        try {
            jsonObject = jsonParser.parse(jsonMessage.toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.returnCode = -1060;
            return null;
        }
        if (jsonObject == null) {
            this.returnCode = -1062;
            return null;
        }
        String symmetricKey = PBCAgent2GUtil.getValueByKey(jsonObject, "symmetricKey");
        if (PBCAgent2GUtil.notEmpty(symmetricKey)) {
            String cardNo = PBCAgent2GUtil.getValueByKey(jsonObject, "cardNo");
            String mobile = PBCAgent2GUtil.getValueByKey(jsonObject, "mobile");
            String realNm = PBCAgent2GUtil.getValueByKey(jsonObject, "realNm");
            String certifId = PBCAgent2GUtil.getValueByKey(jsonObject, "certifId");
            String certType = PBCAgent2GUtil.getValueByKey(jsonObject, "certType");
            String accType = PBCAgent2GUtil.getValueByKey(jsonObject, "accType");
            JsonObject newJsonObj = new JsonObject();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("infosecEncoding", "utf-8");
            map.put("cardNo", cardNo);
            map.put("mobile", mobile);
            map.put("realNm", realNm);
            map.put("certifId", certifId);
            map.put("accType", accType);
            map.put("certType", certType);
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry item = it.next();
                JsonValueString jsonString = new JsonValueString();
                jsonString.setValue((String)item.getValue());
                newJsonObj.put((String)item.getKey(), jsonString);
            }
            String jsonString = this.CUPCQPDecryptJson(newJsonObj.toJson(), encryptCertID, symmetricKey);
            if (jsonString == null) {
                if (this.returnCode == 0) {
                    this.returnCode = -1080;
                }
                return null;
            }
            newJsonObj = jsonParser.parse(jsonString.toCharArray());
            Enumeration keyNames = newJsonObj.getNames();
            while (keyNames.hasMoreElements()) {
                String key = (String)keyNames.nextElement();
                PBCAgent2GUtil.putStringToJson(jsonObject, key, PBCAgent2GUtil.getValueByKey(newJsonObj, key));
            }
        }
        if (PBCAgent2GUtil.notEmpty(signature = PBCAgent2GUtil.getValueByKey(jsonObject, "signature"))) {
            try {
                String signString = PBCAgent2GUtil.getCUPCQSignString(jsonObject);
                this.rawVerify(signString.getBytes("utf-8"), signature, signCertID, "SHA256");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (this.getReturnCode() < 0) {
                return null;
            }
        }
        return jsonObject.toJson();
    }

    private String CUPCQPEncryptJson(String jsonMessage, String encCertID) {
        byte[] key = new byte[24];
        byte[] keys = new byte[16];
        new NSRandom().nextBytes(keys);
        System.arraycopy(keys, 0, key, 0, 16);
        System.arraycopy(keys, 0, key, 16, 8);
        NSMessageOpt res = this.multipleEncryptAndDecrypt(jsonMessage, key, "DESede", "enc", encCertID, null, "/ECB/PKCS5Padding", false);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("CUPCQPEncryptJosn{returnCode:" + this.returnCode + "}");
            if (this.returnCode > 0) {
                JsonParser jsonParser = new JsonParser("utf-8");
                JsonObject jsonObject = jsonParser.parse(res.getEncCertDN().toCharArray());
                PBCAgent2GUtil.putStringToJson(jsonObject, "symmetricKey", Base64.encode(res.getEncKey()));
                return jsonObject.toJson();
            }
            return null;
        }
        this.logString("CUPCQPEncryptJosn{ connect to server failed }");
        return null;
    }

    private String CUPCQPDecryptJson(String jsonMessage, String encCertID, String key) {
        NSMessageOpt res = this.multipleEncryptAndDecrypt(jsonMessage, Base64.decode(key), "DESede", "dec", encCertID, null, "/ECB/PKCS5Padding", true);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("CUPCQPEncryptJosn{returnCode:" + this.returnCode + "}");
            if (this.returnCode > 0) {
                return res.getEncCertDN();
            }
            return null;
        }
        this.logString("CUPCQPEncryptJosn{ connect to server failed }");
        return null;
    }

    protected NSMessageOpt multipleEncryptAndDecrypt(String jsonMessage, String keyLable, String symmencAlg, String mod, String encryptCertID, byte[] iv, String symModAndPadd) {
        if ("".equals(jsonMessage) || "".equals(symmencAlg) || "".equals(mod)) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("NSSJsonEncryptAndDecryptProcessor");
        try {
            req.setPlainText(jsonMessage.getBytes(ExtendedConfig.getEncoding() == null ? "GBK" : ExtendedConfig.getEncoding()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.returnCode = -1027;
            return null;
        }
        req.setEncCertDN(encryptCertID);
        req.setSymmetricalAlg(symmencAlg);
        req.setBankID(mod);
        req.setBankName(keyLable);
        req.setKeyHash(iv);
        req.setDigestAlg(symModAndPadd);
        NSMessageOpt res = this.sendMsg(req);
        return res;
    }

    protected NSMessageOpt multipleEncryptAndDecrypt(String jsonMessage, byte[] key, String symmencAlg, String mod, String encryptCertID, byte[] iv, String symModAndPadd, boolean isEnckey) {
        if ("".equals(jsonMessage) || "".equals(symmencAlg) || "".equals(mod)) {
            this.returnCode = -1026;
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("NSSJsonEncryptAndDecryptProcessor");
        try {
            req.setPlainText(jsonMessage.getBytes(ExtendedConfig.getEncoding() == null ? "GBK" : ExtendedConfig.getEncoding()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.returnCode = -1027;
            return null;
        }
        req.setEncCertDN(encryptCertID);
        req.setSymmetricalAlg(symmencAlg);
        req.setEncKey(key);
        req.setBankID(mod);
        req.setKeyHash(iv);
        req.setUsedTSA(isEnckey);
        req.setDigestAlg(symModAndPadd);
        NSMessageOpt res = this.sendMsg(req);
        return res;
    }

    public byte[][] symmEncrypt(byte[] plainText, byte[] key, byte[] iv, String symmetricalAlg, String modAndPadding) throws NetSignAgentException, ServerProcessException {
        this.logString("symmEncrypt{plainText:" + plainText + "key:" + key + " iv: " + iv + " symmetricalAlg:" + symmetricalAlg + " modAndPadding:" + modAndPadding + "}");
        NSMessage req = NetSignAgentUtil.createMessage("SymmEncryptionWithModeProcessor");
        if (plainText == null || plainText.length < 0) {
            throw new NetSignAgentException("Parameter error: plainText is null ");
        }
        if (key == null || key.length < 0) {
            throw new NetSignAgentException("Parameter error: key is null ");
        }
        if (symmetricalAlg == null || symmetricalAlg.equals("")) {
            throw new NetSignAgentException("Parameter error: symmetricalAlg is null ");
        }
        req.setPlainText(plainText);
        req.setEncKey(key);
        req.setKeyHash(iv);
        req.setSymmetricalAlg(symmetricalAlg);
        req.setBankName(modAndPadding);
        req.setBankID("enc");
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("symmEncrypt{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                byte[][] result = new byte[][]{res.getCryptoText(), res.getKeyHash()};
                return result;
            }
            throw new ServerProcessException(res.getErrMsg());
        }
        this.logString("symmEncrypt{connect to server failed}");
        throw new NetSignAgentException("symmEncrypt connect to server failed");
    }

    public byte[] symmDecrypt(byte[] cryptoText, byte[] key, byte[] iv, String symmetricalAlg, String modAndPadding) throws NetSignAgentException, ServerProcessException {
        this.logString("symmDecrypt{ key:" + key + " iv: " + iv + " symmetricalAlg:" + symmetricalAlg + " modAndPadding:" + modAndPadding + "}");
        NSMessage req = NetSignAgentUtil.createMessage("SymmEncryptionWithModeProcessor");
        if (key == null || key.length < 0) {
            throw new NetSignAgentException("Parameter error: key is null ");
        }
        if (cryptoText == null || cryptoText.length < 0) {
            throw new NetSignAgentException("Parameter error: cryptoText is null ");
        }
        if (symmetricalAlg == null || symmetricalAlg.equals("")) {
            throw new NetSignAgentException("Parameter error: symmetricalAlg is null ");
        }
        req.setEncKey(key);
        req.setKeyHash(iv);
        req.setCryptoText(cryptoText);
        req.setSymmetricalAlg(symmetricalAlg);
        req.setBankName(modAndPadding);
        req.setBankID("dec");
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("symmDecrypt{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return res.getPlainText();
            }
            throw new ServerProcessException(res.getErrMsg());
        }
        this.logString("symmDecrypt{connect to server failed}");
        throw new NetSignAgentException("symmDecrypt connect to server failed");
    }
}

